/*
 * Tables used by the 68000 dis-assembler.
 * Written by Pratt, separated by Bothner.
 *
 * There are two tables, each which is a list of Entries.
 * The tables should be searched for the first match.
 *
 * struct Entry {
 *    char length;	- Length of remainder of entry, in bytes.
 *    char modifier;	- Controls parameter extraction.
 *    u_short mask;	- Which bits are significant in matching.
 *    u_short pattern;	- The bit string to match against.
 *    char program[??]; - The output to generate.
 *
 * Procedure:
 * 1. Look for the first entry which matches the current memory word
 *    (i.e. where the word equals 'pattern' where 'mask' is one).
 * 2. Each consecutive field of don't-care-bits (according to 'mask')
 *    is extracted right-to-left into the 'args' array.
 * 3. Uses the 'modifier' field to extract more data (which might
 *    be further along in the code stream), and put them in 'args'.
 * 4. Use the 'program' and the 'args' array to generate text output.
 */

/*
 * The substitution commands below are of the form 128+code+16*arg
 * When encountered in a program: 128 signals a non-ascii command;
 * 'code' tells which command it is (it is the same as the index to the
 * switch statement in the subst proecdure in disasm.c); and
 * 'arg' is used by subst to select of of the arguments.
 */
#define IX(i)	(128+0+16*i)	/* Output an index (register) */
#define D(i)	(128+1+16*i)	/* Data register as per args[i] */
#define A(i)	(128+2+16*i)	/* Address register as per args[i] */
#define EA(i)	(128+4+16*i)	/* Effective address as per args[i] */
#define SIZ(i)	(128+5+16*i)	/* Insert one of "bwl*" depending on args[i] */
#define VAL(i)	(128+7+16*i)	/* output the value of args[i], in decimal */
#define SYM(i)	(128+8+16*i)
#define REV(i)	(128+9+16*i)	/* same as HEX(i), except bits are reversed */
#define HEX(i)	(128+10+16*i)	/* output the value of args[i], in hex */
#define Q(i)	(128+12+16*i)	/* Choose the args[i]'th next string: */
#define OR ','			/* - Separates alternative strings */
#define QE ')'			/* - End of list of strings */
#define CC(i)	(128+13+16*i)	/* Insert a condition, e.g. "eq" */
#define REL(i)	(128+14+16*i)	/* Symbolic output of relative displacement */

unsigned char optab[] = {
#include "ops68.h"
};				/* Table of opcode patterns? */

unsigned char eatab[] = {
#include "ea68.h"
};				/* Table of eff. add. patterns? */
