/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANDFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * Marvin Theimer, Eric Berglund  5/83
 *
 * If Addr24 is defined, mask off top 8 tag bits. Per Bothner. March 1984.
 */


#include <b.out.h>
#include <Vio.h>
#include "Vdb.h"


/*
 * This file contains the routines which maintain and manipulate the
 * breakpoint data structure bp, in response to explicit user commands
 * and to special calls from Vdebug to temporarily set or remove
 * breakpoints.  They include ClearBreakpoint, RemoveBreakpoint, SetBreakpoint,
 * ResetBreakpoint, FindUserBreakpoint, and PrintBreakpoints.
 *
 * Breakpoint 0 is reserved for single stepping over subroutine calls.
 * Breakpoint 1 is reserved for single stepping over trap instructions.
 */


extern short GetMemWord(), GetInstrWord();
extern PrintAddress(), PutMemData();


/* Replace a breakpoint with the instruction that should be there.  This
 * routine is called when the breakpoint will be restored after execution
 * of the instruction.
 */

ClearBreakpoint(bpno)
    short bpno;
  {
    register struct bpstr *bpptr;
    bpptr = &bp[bpno];
    PutMemWord(bpptr->pc, &( bpptr->oldinst ) );
				    /* replace original instruction */
  }


/* Remove the breakpoint "permanently", i.e. from both the program and the
 * bp list.
 */

RemoveBreakpoint(bpno)
    short bpno;
  {
    register struct bpstr *bpptr;
    register int i;

    for( i = 0, bpptr = &bp[0]; i < BPMAX; i++, bpptr++ )
      if ((i == bpno) || (bpno == ANY))
	if( bpptr->pc != NULL )		/*  breakpoint in use ? */
	  {
	    PutMemWord(bpptr->pc, &( bpptr->oldinst ) );
					/* replace original instruction */
	    bpptr->pc = NULL;
	  }
  }



/* Set a breakpoint.  Returns index of bp set.
 */

SetBreakpoint(whichBp, pc)
    int whichBp;
    short *pc;
{
    register struct bpstr *bpptr;
    int i1, i2;
    register int i;
    short bpInst = BPINST;
    SystemCode error;

    i1 = 0;
    i2 = 0;
    for( i = 2, bpptr = &bp[2]; i < BPMAX; i++, bpptr++ )
      {
	if (bpptr->pc == pc)
	  {
	    i1 = i;
	    PutMemWord( bpptr->pc, &( bpptr->oldinst ) );
	    bpptr->pc = NULL;
	  }
	else if ((bpptr->pc == NULL) && (i2 == 0))
	  i2 = i;
      }

    if (whichBp != ANY)
	bpptr = &bp[whichBp];
    else
	if (i1)
	    whichBp = i1;
	else if (i2)
	    whichBp = i2;
	else
	  {
	    printf("Too many breakpoints.\n");
	    return(0);
	  }
    bpptr = &bp[whichBp];
    bpptr->pc = pc;
    bpptr->oldinst = GetInstrWord((char *)pc,&error);
    PutMemWord((char *)pc, &bpInst );
    return(whichBp);
}


/* Restore a breakpoint which was removed temporarily so its instruction
 * could be executed.
 */

ResetBreakpoint(whichBp, pc)
    int whichBp;
    short *pc;
  {
    register struct bpstr *bpptr;
    SystemCode error;
    short bpInst = BPINST;

    bpptr = &bp[whichBp];
    bpptr->pc = pc;
    bpptr->oldinst = GetMemWord((char *)pc,&error);
    PutMemWord((char *)pc, &bpInst );
    return(whichBp);
  }


/* Return index of user-set breakpoint for current pc if any was set.
 * Return 0 otherwise.  Note that we search only the indices of the
 * breakpoints which can be set by the user: 2 to BPMAX - 1.
 */


FindUserBreakpoint(pc)
    short *pc;
  {
    register struct bpstr *bpptr;
    register int i;

#ifdef Addr24
    pc = (short*)((int)pc & 0xFFFFFF);
#endif
    for( i = 2, bpptr = &bp[2]; i < BPMAX; i++, bpptr++ )
      {
#ifdef Addr24
	if ((short*)((int)bpptr->pc & 0xFFFFFF)== pc)
#else
	if (bpptr->pc == pc)
#endif
	    return(i);
      }
    return(0);
  }


/* Print user's breakpoints.
 */

PrintBreakpoints()
  {
	register struct bpstr *bpptr;
	register short i;

    for( i = 2, bpptr = &bp[2]; i < BPMAX; i++, bpptr++ )
      {
	if( bpptr->pc )
	  {
	    putchar('B');
	    printnum(i);
	    printf("%s", " @ ");
	    PrintAddress( bpptr->pc );
	    putchar('\n');
	  }
      }
  }
