/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANDFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * Marvin Theimer, Eric Berglund,  5/83
 */


/*
 * Primary include file for Vdb.
 */

#define FALSE 0
#define TRUE 1

#define LineLength 256		/* Max size of input line. */
#define MaxArgs 32		/* Max number of arguments. */
#define ARGDELIM ','		/* Delimiter character for input args. */

#define PAGE_LENGTH 24		/* Number of lines to use for display-page
				   commands. */
#define MAX_CODE_LINE_LENGTH 80	/* Disassembler line limit. */
#define DEFRADIX  16		/* Default radix for input and output. */
#define DEFOFFSET 0xfff		/* Offset from a symbol allowed by dasm. */

#define INSTRBLK  512		/* Size of program memory cached in debugger's
				   team space. */

#define CacheSize 100		/* For saving symbol table entries. This
				   is enough even for very large programs. */
#define MAXNUMPARAMSTOPRINT  6	/* No. of parameters to print in stackdump. */

#define BPMAX		16	/* Number of breakpoints allowed */

#define SSBP		0	/* Index of breakpoint used for subroutine
				   single-stepping. */
#define TRBP		1	/* Index of breakpoint used for trap
				   single-stepping. */
#define ANY		BPMAX	/* Indicates any breakpoint. */

#define ATBREAKPOINT		TRUE
#define NOT_ATBREAKPOINT	FALSE
#define EXCEPTION		TRUE
#define NOT_EXCEPTION		FALSE
#define NOARGS  6		/* Maximum number of opcode args for dasm. */
#define NEARGS  3		/* Maximum number of eff.addr. args for dasm. */

#define MAXSYMLEN  128		/* Maximum symbol length that dasm will print--
				   must agree with dl68? */
#define DEF_MAXSYMLEN	16

#define SYMLENWOUTNAME 7	/* Length of a symbol table entry without
				   counting the name of the symbol itself.
				   This should be changed if the sym struct
				   in <b.out.h> is ever changed from char,
				   char, long.  That strange definition
				   causes the compiler to add two extra bytes
				   in the b.out file between the length and
				   the value of the symbol, bringing the
				   total number of bytes to eight.  The
				   loader ld68, however, removes those two
				   bytes, leaving six.  My 7 is there to
				   include the \0 at the end of the symbol
				   name. --EJB */


/* Type field definitions, used in symbol section of .r file. */
#define CHARTYPE	0x01	/* character type */
#define BYTETYPE	0x02	/* byte */
#define WORDTYPE	0x03	/* word */
#define LONGTYPE	0x04	/* long */
#define INSTTYPE	0x05	/* instruction */
#define STRTYPE		0x06	/* string */
#define TYPEFIELDMASK	0x07	/* mask for type field */

#define SIGNEDTYPE	0x08	/* basic signed type */
#define POINTERTYPE	0x10	/* pointer to something */
#define USERTYPE	0x20	/* user-defined type */
#define VDBSYM		0x80	/* symbol is an internal Vdb symbol */
#define DEFTOMODE	INSTTYPE

#define STACKENTRYSIZE	 4	/* size of a stack word in bytes */
#define NUM_REGS_SAVED	11	/* kernel routines save d2-d7, a2-a6 */

#define TRACEBIT	0x8000	/* trace bit in status register */

#define FP    		14	/* frame pointer index in SavedRegisters */
#define SP		15	/* stack pointer index in SavedRegisters */

#define BPINST		0x484f	/* Official illegal instruction */
#define BSRINST		0x6100	/* one flavour of subroutine call */
#define JSRINST		0x4E80	/* another flavour */
#define TRAPINST	0x4e40	/* a third flavour */

#define ADDQL4		0x588f	/* instruction to add 4 to stack pointer */
#define ADDQL8		0x508f	/* instruction to add 8 to stack pointer */
#define ADDL		0xdffc 	/* instruction to add contents of next long to
				    stack pointer */
#define ADDW		0xdefc 	/* instruction to add contents of next word to
				    stack pointer */
#define LEA		0x4fef	/* a faster version of ADDW */

#define UNLKA6		0x4e5e  /* instruction to move to caller's frame */
#define MOVEML3F3ESP	0x48e73f3e
				/* instruction to save regs before trap */
#define MOVEMLSP7CFC	0x4cdf7cfc
				/* instruction to restore regs after trap */
#define RTS		0x4e75  /* instruction to return to caller */

#define JSRLENGTH	6	/* length of JSR instruction */
#define BSRLONGLENGTH	4	/* length of long BSR instruction */
#define BSRSHRTLENGTH	2	/* length of short BSR instruction */

#define JSRMASK  	0xFFC0  /* first 10 bits to check for JSR */
#define BSRLONGMASK	0xFFFF  /* 16 bits to check for BSR, long version */
#define BSRSHRTMASK	0xFF00  /* 8 bits to check for BSR, short version */

#define wordadr(pc) ((char *) ( ((long) pc) & ~1 ))
				/* Return an even pc */

#define PutMemByte( address, data )    PutMemData( address, data, 1 )
#define PutMemWord( address, data )    PutMemData( address, data, 2 )
#define PutMemLong( address, data )    PutMemData( address, data, 4 )
#define PutMemString( address, data, nbytes )  PutMemData( address, data, nbytes )

enum DbCmds			/* Vdb commands */
  {
    DisplayNextCmd,
    DisplayPrevCmd,
    DisplayPtrCmd,
    DisplayNextPageCmd,
    DisplayPrevPageCmd,
    DisplayEqCmd,
    DisplayRegCmd,
    DumpCmd,
    DumpCharCmd,
    ReplaceCmd,
    ReplaceRegCmd,
    GoCmd,
    GoBrkptCmd,
    GoQuitCmd,
    SingleStepCmd,
    SingleStepSbrCmd,
    BpCmd,
    SearchCmd,
    MaskCmd,
    IRadixCmd,
    ORadixCmd,
    TmpTypeCmd,
    TypeCmd,
    StackTraceCmd,
    StopProcessCmd,
    OffsetCmd,
    SymLengthCmd,
    WatchCmd,
    WatchBrkptCmd,
    HelpCmd,
    FileInputCmd,
    QuitCmd,
    StatsCmd,
    BadCmd,
    NoCmd
  };



/* structure of a symbol table definition */
typedef struct Symtabdef
  {
    struct sym *start;
    struct sym *limit;
  } symtabdef;


/* breakpoint mechanism */
struct bpstr {
	short *pc;		/* pc at breakpoint */
	short oldinst;		/* old instruction */
	short count;		/* proceed counter */
	};

struct bpstr bp[BPMAX];		/* breakpoint structures */
struct bpstr *cbptr;		/* current breakpoint or NULL */

/* Symbol table entry record */
typedef struct SymRecord
  {
    struct sym symbol;		/* type, length, value, and */
    char symName[MAXSYMLEN];	/* name. */
  } SymRec;

/* type-out structure for dasm */
struct cbuffr
  {
    char buf[MAX_CODE_LINE_LENGTH];	/* output buffer */
    int pnt;			/* pointer into output buffer */
    int col;			/* output column number */
  };

struct cbuffr OutputBuffer, HexBuffer;
struct cbuffr *cbfp;		/* pointer to OutputBuffer or HexBuffer */


File *Symfile;			/* User program's symbol table file.
				   Normally the program's .r file. */
File *CmdFile;			/* File for user's commands.  Usually stdin. */
struct bhdr filhdr;		/* fileheader of the .r file */


ProcessId CurExceptionPid;	/* Pid of process which incurred
					   the current exception. */
short *ProgramCounter;		/* Current pc */
long StatusRegister;		/* Current sr */
long SavedRegisters[16];	/* Current register values */

char *LoadOrigin;		/* Start of non-kernel part of team space. */
char *LinkOrigin;		/* Address team was linked to run at, 
				 *  normally equal to LoadOrigin */
char *DebugeeTeamSize;		/* Team size of program being debugged. */
char *Dot;			/* last location examined */

char SsFlag;			/* flag set non-zero if single stepping */
char SsSbrFlag;			/* flag set non-zero if single stepping over
				   subroutine calls */
long SsCount;			/* how many single steps */
char InSubrFlag;		/* SsSbrFlag && in a subroutine currently */


int LargestOffset;		/* ...(from a defined symbol) that can be
				   printed by dasm. Defaults to DEFOFFSET.*/

int StringLength;		/* length to use for strings which aren't
				   delimited by \0.  Default is 80. */

int MaxSymLength;		/* settable maximum number of characters
				   of a symbol name which can be displayed. */

char SymType; 			/* type of last symbol found */
int offset;			/* Offset in symbol table file of a 
				   symbol */

short InputRadix;		/* Defaults to DEFRADIX */
short OutputRadix;		/* Defaults to DEFRADIX */

char TypeOutMode, TempTypeOutMode, ActualTypeOutMode;
				/* type-out modes */

char StopProcessFlag;		/* 0 if team stops on exception, else only
				   the process with the exception stops. */
char QuitFlag;			/* 1 if debugger is supposed to kill itself
				   after releasing control. */

char WatchFlag;			/* Are we staring at some address? */
char WatchBrkptFlag;		/* Are we only looking during breakpoints? */
char *WatchAddr;		/* What address is it? */
char WatchType;			/* What type is the data? */
int OldWatchValue;		/* What used to be there? */

#ifdef Addr24
#define FixAddress(x) ((char *)((long)(x) & 0xFFFFFF))
#define DoFixAddress(xPtr) (*(long*)(xPtr) &= 0xFFFFFF)
#else
#define FixAddress(x) ((char *)(x))
#define DoFixAddress(xPtr)
#endif Addr24
