#include <Venviron.h>
#include <Vio.h>

#define BUFFERSIZE  16384

CopyFile(source, dest)
    char *source, *dest ;
  {
    register File *infile, *outfile ;
    register int bytes ;
    int done ;
    char *buffer, *bend ;
    register char  *inp, *outp ;
    SystemCode error ;
    int imb, omb ;
    register int inbs, outbs, ib, ob ;
    
    if( strcmp(source,"-") ) 
      {
        infile = Open( source, FREAD|FBLOCK_MODE, &error);
        if( error || (infile == NULL)) 
          {
            PrintError( error, source );
	    return( error ) ;
          }
      }
    else
      infile = stdin ;

    if( strcmp(dest,"-") )
      {
        outfile = Open(dest, FCREATE|FBLOCK_MODE, &error);
        if( error || (outfile == NULL) )
          {
            PrintError( error, dest );
            return( error ) ;
          }
      }
    else
	outfile = stdout ;

    if( (infile->type & (STREAM|VARIABLE_BLOCK)) || 
        (outfile->type & (STREAM|VARIABLE_BLOCK)) ||
	(BytePosition(outfile) % BlockSize(outfile) != 0) )
      {
	slowcopy( infile, outfile ) ;
	error = OK;
	buffer = NULL;
	goto split;
      }
    
    buffer = (char * ) malloc( BUFFERSIZE ) ;
    if( buffer == (char *) NULL )
      {
        fprintf( stderr, "ran out of mallocspace\n" )  ;
	error = NO_MEMORY ;
	goto split ;
      }
    done = 0 ;
    error = OK ;
    imb = infile->type & MULTI_BLOCK ;     /* true if infile is multiblock */
    omb = outfile->type & MULTI_BLOCK ;	   /* true if outfile is multiblock */
    inp = outp = buffer ;                  /* pointers into buffer */
    bend = buffer + BUFFERSIZE ;           /* end of buffer */
    inbs = infile->blocksize ;		   /* blocksize of infile */
    outbs = outfile->blocksize ;	   /* and of outfile */
    Flush(outfile);
    
    while( 1 )
      {
        /* read into buffer */
        ib = imb ? (((bend-inp)/inbs)*inbs) : inbs ;
        bytes = Read( infile, inp, ib ) ;
	infile->block += (bytes/inbs) ;
	if( bytes - (bytes/inbs)*inbs )
	    ++infile->block ;
	if( bytes < ib )
	    if( infile->lastexception == END_OF_FILE )
	        done = 1 ;
	    else if( bytes < inbs )
	      {
                PrintError( infile->lastexception, source );
		error =  outfile->lastexception  ;
		goto split ;
	      }
	inp += bytes ;
	
	/* write from buffer into dest file */
	while( inp-outp >= outbs )
	  {
	    ob = omb ? ((inp-outp)/outbs)*outbs : outbs ;
	    bytes = Write( outfile, outp, ob ) ;
	    outfile->block += (bytes/outbs)  ;
	    if( bytes < outbs )
	      {
                PrintError( outfile->lastexception, dest );
		error =  outfile->lastexception  ;
		goto split ;
	      }
	    outp += bytes ;
	  }
	if( inp-outp > 0 )
	    if( done )
	      {
	        bytes =  Write( outfile, outp, inp-outp ) ;
	        if( bytes < inp-outp )
	          {
                    PrintError( outfile->lastexception, dest );
		    error =  outfile->lastexception  ;
		    goto split ;
	          }
		goto split ;
	      }
	    else	/* strange buffer sizes */
	      {
	        Copy( buffer, outp, inp-outp ) ;
		inp =  (buffer + ( unsigned ) (inp-outp)) ; 
		outp = buffer ;
	      }
	else
	  {
	    if( done ) goto split ;
	    inp = outp = buffer ;
	  }
      }

split:

    if (infile == stdin)
      {
        if (Interactive(infile)) ClearEof(infile);
      }
    else
	Close( infile ) ;

    if (outfile == stdout) 
      {
	Flush(stdout);
        ClearEof(stdout);
	Seek(stdout, 0, FILE_END);
      }
    else
        Close( outfile ) ;

    if( buffer ) free( buffer ) ;
    if( error ) PrintError( error, "returning from CopyFile with error: " ) ;
    return( error ) ;
  }

slowcopy( infile, outfile )
    register File *infile, *outfile ;
  {
    register int c ;
    SystemCode error ;

    if (infile->type & FBLOCK_MODE)
      {
        infile = OpenFile(infile->fileserver,
			  infile->fileid, FREAD, &error);
        if( ! infile )
            PrintError( error, "Cannot open first file\n" ) ;
      }
    if (outfile->type & FBLOCK_MODE)
      {
        outfile = OpenFile(outfile->fileserver,
			   outfile->fileid, FCREATE, &error);
        if( ! outfile )
            PrintError( error, "Cannot open second file\n" ) ;
      }
    
    while( (c=getc( infile )) != EOF )
        putc( c, outfile ) ;
  }
