#include "checkers.h"

#define min(a,b) ((a>b) ? (b) : (a))
#define max(a,b) ((a>b) ? (a) : (b))


extern File *ff  ;
int firsttime = 1 ;

int Tree( oldb,  level, ab )
    int *oldb; unsigned level; int ab;
   /*
    * This function creates and maintains the tree which is used for
    * determining the next move.  The tree retains all of the information
    * upon which the generated move is based.  The tree is grown and
    * released recursively, to a depth given by 'Depth.'  Also, 'Reverse'
    * is used to change the sides of the game, so that the computer can
    * determine the human's counter-move.  'Generate' actually creates the
    * move, given the board situation from 'oldb.'  As well, 'Posit' is
    * used to calculate the current value of 'oldb'; this value is returned
    * from each 'Tree' call and is used to choose the move that yields the
    * highest value, ie. the most favourable board situation for the
    * computer.
    */
  {
    extern int Po, Pod, Dir, Depth, *Reverse();   
    extern int abarray[] ;
    extern unsigned *Ch_cap();
    unsigned	*capt;
    int  x, pos, pods, dirs, side, value, *newb;
    int i, orglevel ;

    orglevel = level ;

    /* Make local duplicates of the three (3) following external (static)
    * variables; since these are local they are allocated on the stack and
    * their values will be lost upon returning from the appropriate
    * recursive call.
    */
    pos = Po;
    pods = Pod;
    dirs = Dir;
    newb = (int *) malloc( 64*BYTES_PER_WORD );
    /* If the current level is odd set side to one (1); otherwise set
    * it to negative one (-1).
    */
    side = (level&1) ? 1 : -1;


#ifdef DEBUG
    fprintf (ff, " called level=%3d  side=%3d  ab=%8d\n",
        orglevel, side, abarray[level]) ; 
if (firsttime)
  {
  /*  PrintBoard(ff,oldb) */
  }
#endif   

    /* Set the pointer to the capture stack to null. */

    capt = 0;

    /* If the current level of the tree is less than the given depth,
    * create and analyse the next move (node) and its ramifications
    * (sub-tree).
    */
    if( level < Depth )
      {

        /* Initialize 'value' so that it can be recognized as not representing
        * any possible board. Note that if no move is possible for black then
	* this will indicate a win for white. "level" is added so that the
	* computer is more likely to make a move which leads to the quickest
	* win.
	*/

        value = (-INFINITY + level++) * side;
        Po = 7;
        Pod = Dir = 0;

       /* Use 'Ch_cap' to allocate a stack for further moves if a capture
        * is possible.
 	*/
        capt = Ch_cap( oldb );

	if (side<0) /* we are on an even level, and thus are minimizing */
	  {
	    abarray[level-1] = max(abarray[level-3], abarray[level-1]) ; 
	  }
	else
	  {
	    abarray[level-1] = min(abarray[level-3], abarray[level-1]) ; 
	  }
	/* the abarray array mess will have to be kleened up later, to be
	   valid under all crcumstances.: shift everything right by one */

       /* As long as further moves are possible (at the same level),
        * repeat the loop.
	*/
        while( Generate( oldb, newb, capt ) )
          {

            /* Switch sides using 'Reverse'; then call 'Tree' recursively
            * to determine the counter-move. */

            Reverse( newb );
#ifdef DEBUG
	    for (i=0; i<MAXDEPTH; i++)
	              fprintf(ff, "%6d", abarray[i]) ;
	    fprintf(ff,"C(%d),  %d\n", orglevel, value) ;
#endif	     
	    abarray[level] = value ;
            x = Tree( newb,  level, abarray[level] );

            /* Only the move that gives the best board position ought
            * to be remembered. */

            if( (x * side) >= (value * side) )
              {

                /* Store the value and move for the best board situation
                * produced so far.  The move is stored by copying the
                * 'board' matrix which has been created after the move
                * has been executed.  Note that 'Reverse' must be called
                * to switch the sides back.
		*/
                value = x;

                /* The following statement decides whether or not 'pruning'
                * of the tree ought to occur:  if the value of the board
                * at the current level is lower than the value of the
                * board at the previous level, then do not bother growing
                * the tree any further along the current path; rather,
                * return and try something else from the previous level
                * (ie. calling node).
		*/
                if( (x * side) >= (abarray[level-1] * side) )
                  {
#ifdef DEBUG
		    fprintf(ff, "    pruning level %d value %d ab %d\n",
		        orglevel, x, abarray[level-1]) ;
#endif
                    value = INFINITY * side;
                    break;
                  }
		  
		/* if we are not pruning, we might be able to tighten the
		   alpha-beta screws somewhat */
            }
        }
#ifdef DEBUG
      fprintf (ff, " returning level=%d  side=%d  value=%8d  ab=%8d\n",
       		orglevel, side, value, abarray[level-1]) ; 
#endif
     }
    else

       /* Determine the value of the board after the best move possible
        * has been made.  Then, make the move by actually copying the
        * 'working' matrix into the 'board' matrix.
	*/
      {
        value = side * Posit( oldb );
#ifdef DEBUG
        firsttime = 0 ;
	fprintf(ff, 
	    "at bottom returning level=%3d  side=%3d  value=%8d  ab=%8d\n",
       		orglevel, side, value, abarray[level-2]) ;
#endif
      }

    /* Restore the external variables that were used in this call. */

    Po = pos;
    Pod = pods;
    Dir = dirs;

   /* Free the space allocated as a stack for moves, and then return  the
    * value for the board that has resulted from this call.
    */
    if( capt ) free( capt );
    free( newb );
    /*  for (i=0; i<MAXDEPTH; i++)
     	    fprintf(ff, "%7d", abarray[i]) ;*/
#ifdef DEBUG
     fprintf(ff,"Returning %d\n", value) ;
     fflush (ff) ;
#endif     
    return( value );
  }
