#include <Vio.h>
#include "checkers.h"

int problemno = -1 ;
int Quit ;
File *ff ;
extern struct slaves Slaves[] ;

main( argc, argv ) int argc; char **argv;

    /* This is the driving routine for the checkers program. */

  {
    extern int   Board[], PrevBoard[], Value, PrevValue, Depth;
    extern int Po, Pod, Dir, update() ;
    extern ProcessId Master ;
    extern int abarray[] ;
    extern ProcessId Group ;
    Message msg ;
    struct rMsg *rmsg = (struct rMsg *) msg ;
    struct initMsg *imsg = (struct initMsg *) msg ;
    int         *oldb, *newb, s, i ;
    int slave , masterwatch() ;
    ProcessId pid, master ;
    int genno, oldgenno  ;
    unsigned	*capt ;
    extern unsigned *Ch_cap();
    SystemCode error ;

    oldb = (int *) calloc( sizeof(int), 64 );
    newb = (int *) calloc( sizeof(int), 64 );

    /* let master send init data */
    pid = Receive (msg) ;
    imsg->requestcode = OK ;
    Reply (msg, pid) ;
    master = imsg->master ;
    Depth = imsg->memsize ;
    slave = imsg->slave ;
    Group = (ProcessId) imsg->segptr ;
    if( imsg->recreating )
        Master = pid ;
    else
        Master = master ;
    problemno = 0 ;
    capt = 0 ;
    
    Ready( Create( 0, masterwatch, 512),  1, master ) ;

#   ifdef VERBOSE
        ff = stdin ;
#   endif
#   ifdef DEBUG
      {
        char fname[100] ;
      
        sprintf(fname, "debug.rem%d", rmsg->slave) ;
        if ((ff = fopen(fname, "w")) == 0)
            printf ("Remcheckers cannot open %s\n", fname) ;
      }
#   endif
#   ifdef DEBUG
        fprintf(ff, "remcheckers Group is %x\n", Group) ;
#   endif

    /* just for safety purposes */
    for (i=0; i<MAXDEPTH; i++)
    	abarray[i] = (INFINITY-i)*((i&1) ? 1 : -1) ;
	
    startup (0, update, 512) ;
    

    rmsg->requestcode = NEEDWORK ;

    /* Do the following until the game is over: */

    while(1)
      {
#       ifdef VERBOSE
	    fflush (ff) ;
#       endif

        rmsg->segptr = (char *) oldb ;
	rmsg->seglength = 64*BYTES_PER_WORD ;
	rmsg->slave = slave ;
	rmsg->problemno = problemno ;

	/* send to master and get enough info to call Tree */
	while (Send(msg, Master) != Master)
	  {
#           ifdef DEBUG
	       printf("send in slave %d failed\n", rmsg->slave) ;
#           endif
	    Delay( 1, 0 ) ;
	  }
	Master = master ;
	while (rmsg->requestcode != HERE_S_SOME_WORK)
	  {
	    /* printf (" got TRYAGAIN\n") ; */
	    rmsg->requestcode = NEEDWORK ;
	    rmsg->slave = slave ;
            rmsg->segptr = (char *) oldb ;
	    rmsg->seglength = 64*BYTES_PER_WORD ;
	    while (Send (msg, Master) != Master)
	      {
#               ifdef DEBUG
	            printf("send in slave %d failed\n", rmsg->slave) ;
#               endif
		Delay( 1, 0 ) ;
	      }
	  }
	Depth = rmsg->depth ;
	if (rmsg->problemno != problemno)
	    /* A new board was MoveToed. Reinitialize variables */
	  {
	    problemno = rmsg->problemno ;
	    Quit = 0 ;
	    if (capt) free(capt) ;
            capt = Ch_cap( oldb );
	    abarray[-2] = -INFINITY ;
	    abarray[-1] = INFINITY ;
    	    for (i=0; i<MAXDEPTH; i++)
    		abarray[i] = (INFINITY-(i-1))*((i&1) ? 1 : -1) ;
	  }
	
	/* Generate the correct board */    
        Po = 7;
	Pod = Dir = 0;
	for (i=0; i<rmsg->genno; i++)
		Generate( oldb, 0, capt ) ;
	Generate( oldb, newb, capt ) ;

        Reverse( newb);

	abarray[rmsg->level] = rmsg->value ;
	abarray[rmsg->level-1] = rmsg->secondvalue ;

	/* Computer makes its move. */
#   ifdef DEBUG
      fprintf(ff, "More Work: %d.%d level %d value %d secondvalue %d\n",
        rmsg->problemno, rmsg->genno, rmsg->level, rmsg->value,
	rmsg->secondvalue) ;
#    endif
	 
	rmsg->value = Tree( newb,  rmsg->level, rmsg->value );

	if (Quit)
	  {
	    if (rmsg->level&1)
	        rmsg->value = INFINITY ;
	    else
	        rmsg->value = -INFINITY ;
#	    ifdef VERBOSE
	        fprintf(ff, "slave %d Quiting\n", rmsg->slave) ;
#	    endif
	  }
        rmsg->requestcode = RESULT_NEEDWORK ;
      }
  }
