/*
 * V-System checker program
 * CopyRight (c) 1981 David Cheriton, all rights reserved.
 * transliterated from Verex and Zed. July 1983.
 */
#include <Vio.h>
#include "checkers.h"


       /* 'Board' is the vector for the data for the current board.
        * -1  is for 'out of bounds' squares; 1 and 2 are for player
        * pieces (refer to the manifest constants); 0 is an empty
        * square.
	*/
int     Board[64]  = {
                OB,     OB,     OB,     OB,     OB,
    OB,     OB,      BC,      BC,      BC,      BC,     OB,
        OB,      BC,      BC,      BC,      BC,     OB,
    OB,     OB,      BC,      BC,      BC,      BC,     OB,
        OB,      EMPTY,      EMPTY,      EMPTY,      EMPTY,     OB,
    OB,     OB,      EMPTY,      EMPTY,      EMPTY,      EMPTY,     OB,
        OB,      RC,      RC,      RC,      RC,     OB,
    OB,     OB,      RC,      RC,      RC,      RC,     OB,
        OB,      RC,      RC,      RC,      RC,     OB,
    OB,     OB,     OB,     OB,     OB,     OB };


/* PrevBoard is used to save the board as it existed before the human's last
 * move, in case he wants to back up. */
int PrevBoard[64];

        /* The default search tree depth is 4. */

        Depth = 4;


        /* 'Po' is for board position, 'Pod' is a vector index, and
         * 'Dir' indicates movement direction.
	 */
        int Po;
        int Pod;
        int Dir;

        /* 'Swapl' is used to swap the playing pieces, so that the computer
        * can determine the human's counter-move.
	*/
int     Swapl[6] = { -1,  0,  2,  1,  4,  3 };

        /* 'Pdisp' is a vector containing the displacements that are
        * used in determining the target square for a normal move.
        * 'Pdispd' has the same function, but it contains displacements
        * for 'jump' or capture moves, in which double the distance
        * is needed.
	*/
int     Pdisp[4] = { 6,  7,  -6,  -7 };
int     Pdispd[4] = { 12,  14,  -12,  -14 };


       /* Used to address the 'Board' elements (squares). */

int     Index[64] = {
         0, 13, 0, 26, 0, 39, 0, 52, 
         7, 0, 20, 0, 33, 0, 46, 0, 
         0, 14, 0, 27, 0, 40, 0, 53, 
         8, 0, 21, 0, 34, 0, 47, 0, 
         0, 15, 0, 28, 0, 41, 0, 54, 
         9, 0, 22, 0, 35, 0, 48, 0, 
         0, 16, 0, 29, 0, 42, 0, 55, 
         10, 0, 23, 0, 36, 0, 49, 0 };

        /* Used in translating positions from command (alphanumeric)
        * form into numeric form (addresses into 'Index').
	*/
        char *Sqnam[64] = {
           0,   0,   0,   0,   0,
           0,   0,     "B8",     "D8",     "F8",     "H8",   0,
           0,     "A7",     "C7",     "E7",     "G7",   0,
           0,   0,     "B6",     "D6",     "F6",     "H6",   0,
           0,     "A5",     "C5",     "E5",     "G5",   0,
           0,   0,     "B4",     "D4",     "F4",     "H4",   0,
           0,     "A3",     "C3",     "E3",     "G3",   0,
           0,   0,     "B2",     "D2",     "F2",     "H2",   0,
           0,     "A1",     "C1",     "E1",     "G1",   0,
           0,   0,   0,   0,   0,   0,   0 };

       /* the following vectors contain data about the
        * weighting of squares due to their positions. */

int     Winner_value[64] = {

               0,  0,  0,  0,  0, 
         0,  0, 15,  8,  5,  1,  0,
           0,  1, 12,  6,  2,  0,
         0,  0, 12,  8,  3,  5,  0,
           0,  8,  7,  4,  6,  0,
         0,  0,  6,  4,  8,  8,  0,
           0,  5,  3,  7, 12,  0,
         0,  0,  2,  6, 12,  1,  0,
           0,  1,  5,  8, 15,  0,
         0,  0,  0,  0,  0,  0 };

int     Basic_value[64] = {
        
               0,  0,  0,  0,  0, 
         0,  0,  4,  3,  1,  1,  0,
           0,  4,  3,  2,  1,  0,
         0,  0,  5,  4,  3,  2,  0,
           0,  6,  5,  4,  3,  0,
         0,  0,  8,  7,  6,  5,  0,
           0, 12, 10,  8,  6,  0,
         0,  0, 15, 12, 12, 15,  0,
           0, 15, 15, 15, 15,  0,
         0,  0,  0,  0,  0,  0 };
        

        /* 'Value' contains the current value of the 'Board', which
        * is based on the types of pieces and the positions of the
        * squares that they occupy.
	*/

int     Value, PrevValue;


/* The following added on for the distributed version of the game */

ProcessId Proc[MAXSLAVES], Master, Group ;
int NoOfTeams, NoOfHosts ;
int internalABARRAY[MAXDEPTH+3] ;
int *abarray = &internalABARRAY[2] ;



