#include "checkers.h"

#define	CLEAR -1
#define DONE 5

Edit()

   /* This subprogram allows the (human) player to change the board, by adding
    * selected pieces to the board, and/or deleting pieces from the board.
    */
  {
    extern int   Board[], Index[];
    extern short Edit_Menu_FirstSquare;

    short	response, selectedSquare, i, j;

    begin_Edit_Mode();

    /* The user must first select from the Edit mode menu. */
    while ( (response = GetResponse(TRUE)) < Edit_Menu_FirstSquare-1 )
	;

    /* Loop until "Done" is selected. */
    while(1)
      {
	switch (response - Edit_Menu_FirstSquare)
	  {
	    case DONE:
		/* Leave Edit mode. */
		end_Edit_Mode();
		return;

	    case CLEAR:
		/* Clear the screen. */
		for (i=0; i<64; ++i)
		    if ( (j=Index[i]) != 0 )
			Board[j] = EMPTY;
		FullDisplay(Board, FALSE);

		/* Get the next item selected from the menu. */
		while ( (response = GetResponse(TRUE))
		       < Edit_Menu_FirstSquare-1 )
		    ;
		break;

	    default:
		/* The user has selected one of the 'pieces' in the
		 * Edit mode menu (possibly the empty square).
		 */
		selectedSquare = response - Edit_Menu_FirstSquare;

		/* Highlight this square. */
		Edit_Menu_Highlight(selectedSquare, 1);

		/* For each square (on the board) that the user selects,
		 * change that square to the piece originally selected from
		 * the menu.
		 */
		while ( (response = GetResponse(TRUE))
		       < Edit_Menu_FirstSquare-1 )
		  {
		    Board[response] = selectedSquare;
		    UpdateDisplayedSquare(response, FALSE);
		  }

		/* 'Unhighlight' the originally selected menu item,
		 * and continue round the outer loop.
		 */
		Edit_Menu_Highlight(selectedSquare, 0);
		break; /* From the 'switch', not the loop. */
	  }
      }
  }
