/*
 * ranlib - create table of contents for archive; string table version
 * Version hacked up to handle 68000 .b files
 * Per Bothner. May 1983.
 */
#include <sys/types.h>
#include <ar.h>
#include <ranlib.h>
#include "pagsiz.h"
#include <m68k/b.out.h>
#undef OMAGIC
#undef NMAGIC
#undef FMAGIC
#undef IMAGIC
#undef N_BADMAG
#undef N_TXTOFF
#undef N_SYMOFF
#include <a.out.h>
/* Note that OMAGIC in a.out.h is 0407 and in b.out.h is 0405 ! */
#include <stdio.h>

struct	ar_hdr	archdr;
#define	OARMAG 0177545
long	arsize;
struct	exec	exp;
FILE	*fi, *fo;
long	off, oldoff;
long	atol(), ftell();
#define TABSZ	5000
struct	ranlib tab[TABSZ];
int	tnum;
#define	STRTABSZ	75000
char	tstrtab[STRTABSZ];
int	tssiz;
char	*strtab;
int	ssiz;
int	new;
char	tempnm[] = "__.SYMDEF";
char	firstname[17];

main(argc, argv)
char **argv;
{
	char cmdbuf[1024];
	char magbuf[SARMAG+1];
	int scratchint;

	--argc;
	while(argc--) {
		fi = fopen(*++argv,"r");
		if (fi == NULL) {
			fprintf(stderr, "ranlib: cannot open %s\n", *argv);
			continue;
		}
		off = SARMAG;
		fread(magbuf, 1, SARMAG, fi);
		if (strncmp(magbuf, ARMAG, SARMAG)) {
			if (*(int *)magbuf == OARMAG)
				fprintf(stderr, "old format ");
			else
				fprintf(stderr, "not an ");
			fprintf(stderr, "archive: %s\n", *argv);
			continue;
		}
		fseek(fi, 0L, 0);
		new = tnum = 0;
		if (nextel(fi) == 0) {
			fclose(fi);
			continue;
		}
		do { /* for each component ... */
			long o;

			fread((char *)&exp, 1, sizeof(struct exec), fi);
#ifndef LITTLE_ENDIAN
			ByteSwapLongInPlace((long *)&exp, sizeof(struct exec));
#endif LITTLE_ENDIAN
			if (N_BADMAG(exp))
				continue;
			if (exp.a_syms == 0) {
				fprintf(stderr, "ranlib: warning: %s(%s): no symbol table\n", *argv, archdr.ar_name);
				continue;
			}
			o = N_STROFF(exp) - sizeof (struct exec);
			if (strcmp(archdr.ar_name+strlen(archdr.ar_name)-2,
			           ".o"))
				 parse_b_out_syms();
			else if (ftell(fi)+o+sizeof(ssiz) >= off) {
				fprintf(stderr, "ranlib: %s(%s): old format .o file\n", *argv, archdr.ar_name);
				exit(1);
			}
			else { fseek(fi, o, 1); parse_a_out_syms(); }
		} while(nextel(fi));
		new = fixsize();
		fclose(fi);
		fo = fopen(tempnm, "w");
		if(fo == NULL) {
			fprintf(stderr, "can't create temporary\n");
			exit(1);
		}
		scratchint = tnum * sizeof (struct ranlib);
#ifndef LITTLE_ENDIAN
		ByteSwapLongInPlace((long *)tab, scratchint);
		ByteSwapLongInPlace(&scratchint, sizeof(scratchint));
#endif LITTLE_ENDIAN
		fwrite(&scratchint, 1, sizeof (scratchint), fo);
		fwrite((char *)tab, tnum, sizeof(struct ranlib), fo);
#ifndef LITTLE_ENDIAN
		ByteSwapLongCopy(&tssiz, &scratchint, sizeof(tssiz));
		fwrite(&scratchint, 1, sizeof (tssiz), fo);
#else LITTLE_ENDIAN
		fwrite(&tssiz, 1, sizeof (tssiz), fo);
#endif LITTLE_ENDIAN
		fwrite(tstrtab, tssiz, 1, fo);
		fclose(fo);
		if(new)
			sprintf(cmdbuf, "ar rlb %s %s %s\n", firstname, *argv, tempnm);
		else
			sprintf(cmdbuf, "ar rl %s %s\n", *argv, tempnm);
		if(system(cmdbuf))
			fprintf(stderr, "ranlib: ``%s'' failed\n", cmdbuf);
		else
			fixdate(*argv);
		unlink(tempnm);
	}
	exit(0);
}

parse_a_out_syms()
  {
    register n;
    struct nlist sym;
	fread((char *)&ssiz, 1, sizeof (ssiz), fi);
#ifndef LITTLE_ENDIAN
	ByteSwapLongInPlace(&ssiz, sizeof(ssiz));
#endif LITTLE_ENDIAN
	strtab = (char *)calloc(1, ssiz);
	if (strtab == 0) {
		fprintf(stderr, "ranlib: ran out of memory\n");
		exit(1);
	}
	fread(strtab+sizeof(ssiz), ssiz - sizeof(ssiz), 1, fi);
	fseek(fi, -(exp.a_syms+ssiz), 1);
	n = exp.a_syms / sizeof(struct nlist);
	while (--n >= 0) {
		fread((char *)&sym, 1, sizeof(sym), fi);
#ifndef LITTLE_ENDIAN
		ByteSwapLongInPlace((long *)&sym.n_un.n_strx, sizeof(long));
		ByteSwapShortInPlace((short *)&sym.n_desc, sizeof(short));
		ByteSwapLongInPlace((long *)&sym.n_value, sizeof(long));
#endif LITTLE_ENDIAN
		if (sym.n_un.n_strx == 0)
			continue;
		sym.n_un.n_name = strtab + sym.n_un.n_strx;
		if ((sym.n_type&N_EXT)==0)
			continue;
		if (sym.n_type&N_TYPE != N_UNDF || sym.n_value!=0)
		    stash(sym.n_un.n_name);
		}
 }

parse_b_out_syms()
  {
    struct sym bsym;
#ifndef LITTLE_ENDIAN
    char bsymbuf[SYMSIZE_VAX];
#endif LITTLE_ENDIAN
#define filhdr (*(struct bhdr *)&exp)

    fseek(fi, SYMPOS - TEXTPOS, 1);
    while (exp.a_syms > 0)
      {
#ifndef LITTLE_ENDIAN
	fread(bsymbuf, SYMSIZE_VAX, 1, fi);
	bsym.stype = bsymbuf[0];
	bsym.slength = bsymbuf[1];
	ByteSwapLongCopy(&bsymbuf[4], &bsym.svalue, sizeof(long));
#else LITTLE_ENDIAN
	fread(&bsym, SYMSIZE_VAX, 1, fi);
#endif LITTLE_ENDIAN
	exp.a_syms -= SYMSIZE_VAX;
	if (tssiz + bsym.slength >= STRTABSZ)
	  {
	    fprintf(stderr, "ranlib: string table overflow\n");
	    exit(1);
	  }
	fread(tstrtab + tssiz, bsym.slength, 1, fi);
	exp.a_syms -= bsym.slength;
	getc(fi); exp.a_syms--; /* skip null byte */
	if (bsym.stype & EXTERN && (bsym.stype & 0xF || bsym.svalue))
	  {
	    if (tnum >= TABSZ) 
	      {
		    fprintf(stderr, "ranlib: symbol table overflow\n");
		    exit(1);
	      }
	    tab[tnum].ran_un.ran_strx = tssiz;
	    tab[tnum].ran_off = oldoff;
	    tnum++;
	    tssiz += bsym.slength;
	    tstrtab[tssiz++] = 0;
	  }
      }
  }

nextel(af)
FILE *af;
{
    register r;
    register char *cp;
    oldoff = off;
    fseek(af, off, 0);
    r = fread((char *)&archdr, 1, sizeof(struct ar_hdr), af);
    if (r != sizeof(struct ar_hdr))
	return(0);
    for (cp=archdr.ar_name; cp < & archdr.ar_name[sizeof(archdr.ar_name)]; cp++)
	if (*cp == ' ')
	    *cp = '\0';
    archdr.ar_name[sizeof(archdr.ar_name)] = 0;
    arsize = atol(archdr.ar_size);
    if (arsize & 1)
	arsize++;
    off = ftell(af) + arsize;
    return(1);
}

stash(s)
    register char *s;
{
	int i;

	if(tnum >= TABSZ) {
		fprintf(stderr, "ranlib: symbol table overflow\n");
		exit(1);
	}
	tab[tnum].ran_un.ran_strx = tssiz;
	tab[tnum].ran_off = oldoff;
	while (tstrtab[tssiz++] = *s++)
		if (tssiz > STRTABSZ) {
			fprintf(stderr, "ranlib: string table overflow\n");
			exit(1);
		}
	tnum++;
}

fixsize()
{
    int i;
    off_t offdelta;

    if (tssiz&1)
	tssiz++;
    offdelta = sizeof(archdr) + sizeof (tnum) + tnum * sizeof(struct ranlib) +
	sizeof (tssiz) + tssiz;
    off = SARMAG;
    nextel(fi);
    if(strncmp(archdr.ar_name, tempnm, sizeof (archdr.ar_name)) == 0) {
	new = 0;
	offdelta -= sizeof(archdr) + arsize;
    } else {
	new = 1;
	strncpy(firstname, archdr.ar_name, sizeof(archdr.ar_name));
    }
    for(i=0; i<tnum; i++)
	tab[i].ran_off += offdelta;
    return(new);
}

/* patch time */
fixdate(s)
	char *s;
{
#ifdef Vsystem
#include <Vdirectory.h>
	SystemCode ReadDescriptor(), err;
	ArbitraryDescriptor desc;
#else
	long time();
#endif Vsystem
	long timestamp;
	char buf[24];
	FILE *fd;

	fd = fopen(s, "r+");
	if(fd == NULL) {
		fprintf(stderr, "ranlib: can't reopen %s\n", s);
		return;
	}
#ifndef Vsystem
	/* UNIX version */
	timestamp = time((long *)NULL) + 5;
#else
	/* We can't assume the local clock is in sync with the
	 *  file server's, so we base the timestamp on the file's
	 *  current modified time instead.  That time should
	 *  be about right since this function is called immediately
	 *  after ar has finished modifying the file by putting in
	 *  the new __.SYMDEF header.
	 */
	err = ReadDescriptor(FileServer(fd), FileId(fd), &desc);
	if (err != OK)
	  {
	    fprintf(stderr, "ranlib: can't read descriptor for %s: %s\n",
	    	    s, ErrorString(err));
	    return;
	  }
	timestamp = 10 +
	   (desc.e.descriptortype == UNIXFILE_DESCRIPTOR ? desc.u.st_mtime :
	    desc.e.descriptortype == FILE_DESCRIPTOR ? desc.f.timestamp : 0);
#endif Vsystem
	sprintf(buf, "%-*ld", sizeof(archdr.ar_date), timestamp);
	fseek(fd, (long)SARMAG + ((char *)archdr.ar_date-(char *)&archdr), 0);
	fwrite(buf, sizeof(archdr.ar_date), 1, fd);
	fclose(fd);
}
