#include "fep.h"

SystemCode
ReadRecord( globalinfo, Week, when )
Globals *globalinfo;
WeekRecord *Week;
int when;
  {
    Message msg;
    CalendarIoRequest *request = (CalendarIoRequest *) msg;
    CalendarIoReply *reply = (CalendarIoReply *) msg;
    
    SystemCode replycode;
    
    request->requestcode = READ_RECORD;
    request->name = globalinfo->who;
    request->fileid = globalinfo->fileid;
    request->weekptr = Week;
    request->date = when;
    request->length = sizeof(WeekRecord);

    Send(msg,globalinfo->calpid);
    
    switch(reply->replycode)
      {
        case OK:
	    break;
	    
	case NO_PERMISSION:
	    printf("Access denied, no permission\n");
	    break;
	    
	case BAD_ARGS:
	    printf("Arguments to Calendar Server are invalid\n");
	    abort();
	    break;
	    
	case NOT_AVAILABLE:
	    printf ("Record not available\n");
	    break;
	    
	default:
	    printf("Record not found \n");
	    break;
      }	    
    replycode = reply->replycode;
    return(replycode);
  }