#include "fep.h"

main()
 {
   ProcessId calpid;
   
   int selection;
   int date, chr;
   char name[NAME_LEN], *nameptr = &name[0], *GetName();
   char inputline[80];
   int usernumber;
   Globals globalinfo;
   
   ClearScreen;
   
   calpid = GetPid(CALENDAR_SERVER, ANY_PID);
   if (!calpid)
     {
       printf("ERROR - Calendar Server not found\n");
       abort();
     }
   
   globalinfo.calpid = calpid;
     
   date = GetDate(stdin, "Enter today's date (MMDDYY) : ");
   GetName(stdin, nameptr, NAME_LEN);
   usernumber = FindName(nameptr);
   printf("user %d - %s\n",usernumber, name);
   
   globalinfo.date = date;
   globalinfo.userid = usernumber;
   globalinfo.who = name;
   
   selection = 1;
   
   while(selection)
     {
       ClearScreen;
       printf("Choose option :\n\n");
       printf("   0 - quit program\n");
       printf("   1 - schedule/unschedule appointments\n");
       printf("   2 - view/update calendar\n\n");
       printf("Enter option : ");
       gets(inputline);
       sscanf(inputline,"%d",&selection);

       ClearScreen;
       
       switch(selection)
         {
	   case SCHEDULE_APPOINTMENT:
	       printf("          Schedule Appointment\n");
	       ScheduleAppointment( &globalinfo, name, date, calpid);
	       break;
	   
	   case VIEW_CALENDAR:
	       printf("          View Calendar\n");
	       View( &globalinfo, name, date, calpid);
	       break;
	       
	   case QUIT_PROGRAM:
	       break;
	       
	   default:
	       printf("please choose a valid option\n");
	       break;
	  }
	if (selection == QUIT_PROGRAM)
	    break;
	printf("Type <cr> to continue.");
	gets(inputline);
      }
  }
  
     
   