/* 
 *     Message type definitions for Calendar Server interface
 */

typedef struct
  {
    SystemCode     requestcode;
    int            fileid;
    unsigned short unused;
    unsigned       filler[3];
    int            date;
    char           *name;
    unsigned       length;
  } CalendarRequest;

typedef struct
  {
    SystemCode replycode;
    int fileid;
  } CalendarReply;

typedef struct
  {
    SystemCode     requestcode;
    char           *name;
    int            date;
    int            fileid;
    unsigned short unused;
    unsigned       filler[2];
    WeekRecord     *weekptr;
    unsigned       length;
  } CalendarIoRequest;
  
typedef struct
  {
    SystemCode replycode;
    char           *name;
    int            date;
    int            fileid;
    unsigned short unused;
    unsigned       filler[2];
    WeekRecord     *weekptr;
    unsigned       length;
  } CalendarIoReply;


/* request codes for calendar requests */

#define CREATE_CALENDAR CREATE_INSTANCE
#define READ_RECORD     READ_INSTANCE
#define UPDATE_RECORD   WRITE_INSTANCE
#define LIST_REGISTERED 0x1400
#define CLOSE_CALENDAR  RELEASE_INSTANCE

#define INVALID_REQUEST MODE_NOT_SUPPORTED
