static	char *sccsid = "@(#)main.c	4.5 (Berkeley) 83/03/03";
# include "defs"
/*
command make to update programs.
Flags:	'd'  print out debugging comments
	'p'  print out a version of the input graph
	's'  silent mode--don't print out commands
	'f'  the next argument is the name of the description file;
	     "makefile" is the default
	'i'  ignore error codes from the shell
	'S'  stop after any command fails (normally do parallel work)
	'n'   don't issue, just print, commands
	't'   touch (update time of) files but don't issue command
	'q'   don't do anything, but check if object is up to date;
	      returns exit code 0 if up to date, -1 if not
*/

struct nameblock *mainname	= NULL;
struct nameblock *firstname	= NULL;
struct nameblock *firstpattern	= NULL;
struct nameblock **lastpattern	= &firstpattern;
struct lineblock *sufflist	= NULL;
struct varblock *firstvar	= NULL;
struct pattern *firstpat	= NULL;
struct dirhdr *firstod		= NULL;

#ifdef unix
#include <signal.h>
int sigivalue	= 0;
int sigqvalue	= 0;
#endif unix
int waitpid	= 0;

int dbgflag	= NO;
int prtrflag	= NO;
int silflag	= NO;
int noexflag	= NO;
int keepgoing	= NO;
int noruleflag	= NO;
int touchflag	= NO;
int questflag	= NO;
int ndocoms	= NO;
int ignerr	= NO;    /* default is to stop on error */
int okdel	= YES;
int inarglist;
#ifdef pwb
char *prompt	= ">";	/* other systems -- pick what you want */
#else
char *prompt	= "";	/* other systems -- pick what you want */
#endif
int nopdir	= 0;
char junkname[20];
char funny[128];
char	options[26 + 1] = { '-' };

#ifdef Vsystem
int RootStackSize = 20000;	/* used by teamroot to set the stacksize */
#endif

main(argc,argv)
int argc;
char *argv[];
{
register struct nameblock *p;
int i, j, nfargs;
TIMETYPE tjunk;
char c, *s, *argi;
int descgiven = 0; /* # of descriptor files given with -f switches */
static char onechar[2] = "X";
#ifdef unix
int intrupt();
#endif

char *op = options + 1;

#ifdef METERFILE
meter(METERFILE);
#endif

funny['\0'] = (META | TERMINAL);
#ifdef Vsystem
for(s = "|&<>@'\"$*" ; *s ; ++s)
#else
for(s = "=|^();&<>*?[]:$`'\"\\\n" ; *s ; ++s)
#endif Vsystem
	funny[*s] |= META;
for(s = "\n\t :;&>|" ; *s ; ++s)
	funny[*s] |= TERMINAL;


inarglist = 1;
/* get all switches and definitions */
for(i=1; i<argc; ++i) {
	argi = argv[i];
	if (argi==0) continue;
	if (argi[0]=='-') {
		argv[i] = 0;
		for (j=1 ; (c=argi[j])!='\0' ; ++j) {
			*op++ = c;	/* collect options for MFLAGS macro */
			switch (c) {

			case 'D':
				op--;		/* don't pass this one */
				j++;
				if (argi[j] == '\0')
				    fatal("Bad -D option");
				if (eqsign(&argi[j])) { }
				else setvar(&argi[j], "");
				goto nextArg;
			case 'd':
				dbgflag = YES;
				break;

			case 'p':
				prtrflag = YES;
				break;

			case 's':
				silflag = YES;
				break;

			case 'i':
				ignerr = YES;
				break;

			case 'S':
				keepgoing = NO;
				break;

			case 'k':
				keepgoing = YES;
				break;

			case 'n':
				noexflag = YES;
				break;

			case 'r':
				noruleflag = YES;
				break;

			case 't':
				touchflag = YES;
				break;

			case 'q':
				questflag = YES;
				break;

			case 'f':
				op--;		/* don't pass this one */
				if(i >= argc-1)
				  fatal("No description argument after -f flag");
				descgiven++;
				argv[descgiven] = argv[i+1];
				argv[i+1] = 0;
	/* argv[1:descgiven] contains filenames culled from -f switches */
				break;

			default:
				onechar[0] = c;	/* to make lint happy */
				fatal1("Unknown flag argument %s", onechar);
			}
 	nextArg: ;
		}
	}
	else if (eqsign(argi)) /* no starting '-'; check for '=' */
		argv[i] = 0;
}
inarglist = 0;

*op++ = '\0';
if (strcmp(options, "-") == 0)
	*options = '\0';
setvar("MFLAGS", options);		/* MFLAGS=options to make */
setvar("$","$");
setvar("*", STAR);

if( descgiven )
    /* read the given descriptor files */
    for (i = 1; i <= descgiven; i++) {
	if( rddescf(argv[i]) )
		fatal1("Cannot open %s", argv[i]);
	argv[i] = 0;
    }
else
    /* read default descriptor file */
#if defined(unix) || defined(Vsystem)
    if (rddescf("buildfile"))  if( rddescf("makefile") )  rddescf("Makefile");
#endif
#ifdef gcos
    rddescf("makefile");
#endif

if(prtrflag) printdesc(NO);

if( srchname(".IGNORE") ) ++ignerr;
if( srchname(".SILENT") ) silflag = 1;
if(p=srchname(".SUFFIXES")) sufflist = p->linep;
if( !sufflist ) fprintf(stderr,"(No suffix list)\n");
FixSuffixes();
SetPath();

#ifdef unix
sigivalue = (int) signal(SIGINT, SIG_IGN) & 01;
sigqvalue = (int) signal(SIGQUIT, SIG_IGN) & 01;
enbint(intrupt);
#endif

nfargs = 0;

for(i=1; i<argc; ++i)
	if((s=argv[i]) != 0)
		{
		if((p=srchname(s)) == 0)
			{
			p = makename(s);
			}
		++nfargs;
		doname(p, 0, &tjunk);
		if(dbgflag) printdesc(YES);
		}

/*
If no file arguments have been encountered, make the first
name encountered that doesn't start with a dot
*/

if(nfargs == 0)
	if(mainname == 0)
		fatal("No arguments or description file");
	else	{
		doname(mainname, 0, &tjunk);
		if(dbgflag) printdesc(YES);
		}

exit(0);
}

#ifdef unix

#include <sys/stat.h>

intrupt()
{
struct varblock *varptr();
char *p;
TIMETYPE exists();
struct stat sbuf;

if(okdel && !noexflag && !touchflag &&
	(p = varptr("@")->varval) &&
	(stat(p, &sbuf) >= 0 && (sbuf.st_mode&S_IFMT) == S_IFREG) &&
	!isprecious(p) )
		{
		fprintf(stderr, "\n***  %s removed.", p);
		unlink(p);
		}

if(junkname[0])
	unlink(junkname);
fprintf(stderr, "\n");
exit(2);
}




isprecious(p)
char *p;
{
register struct lineblock *lp;
register struct depblock *dp;
register struct nameblock *np;

if(np = srchname(".PRECIOUS"))
	for(lp = np->linep ; lp ; lp = lp->nxtlineblock)
		for(dp = lp->depp ; dp ; dp = dp->nxtdepblock)
			if (dp->depname != NULL &&
			    ! unequal(p, dp->depname->namep))
				return(YES);

return(NO);
}


enbint(k)
int (*k)();
{
if(sigivalue == 0)
	signal(SIGINT,k);
if(sigqvalue == 0)
	signal(SIGQUIT,k);
}
#endif

extern char *builtin[];

char **linesptr	= builtin;

#define MAXFILELEVEL 20
int fileLevel = 0;
FILE *fileStack[MAXFILELEVEL];
char *(fileNameEndStack[MAXFILELEVEL]);
#define MAXFILENAME 200
char fileNameBuf[MAXFILENAME] = "";
char *fileName = fileNameBuf, *fileNameEnd = fileNameBuf;

FILE * fin;
int firstrd	= 0;

FILE *
pushDescFile(name)
    char *name;
  { register char *p; FILE *f;
    if (fileLevel >= MAXFILELEVEL)
	fatal("Too many nested include files");
    fileStack[fileLevel] = fin;
    fileNameEndStack[fileLevel] = fileNameEnd;
    if (dbgflag) printf("[#include %s", name);
    if(!unequal(name, "-"))
	f = stdin;
    else
      {
	strncpy(fileNameEnd, name, MAXFILENAME - (fileNameEnd - fileNameBuf));
	if (*name == '/' || *name == '[') fileName = fileNameEnd;
        f = fopen(fileName, "r");
	if (dbgflag) printf(" => %s", fileName);
	p = fileNameEnd + strlen(fileNameEnd);
	while (p > fileNameEnd && p[-1] != '/' && p[-1] != ']') p--;
	fileNameEnd = p;
      }
    if (f != NULL) fileLevel++;
    if (dbgflag) printf(":\n");
    return f;
  }

popDescFile()
  { int i;
    if (fin != NULL && fin != stdin)
	fclose (fin);
    if (dbgflag) printf("]\n");
    fileLevel--;
    fileNameEnd = fileNameEndStack[fileLevel];
    fin = fileStack[fileLevel];
    fileName = fileNameBuf;
    for (i = 0; i <= fileLevel; i++)
      { register char *p = fileNameEndStack[i];
	if (*p == '/' || *p == '[') fileName = p;
      }
    return fileLevel;
  }


rddescf(descfile)
char *descfile;
{
FILE * k;

/* read and parse description */

if( !firstrd++ )
	{
	if( !noruleflag )
		rdd1( (FILE *) NULL);

#ifdef pwb
		{
		char *nlog, s[100];
		nlog = logdir();
		if ( (k=fopen( concat(nlog,"/makecomm",s), "r")) != NULL)
			rdd1(k);
		else if ( (k=fopen( concat(nlog,"/Makecomm",s), "r")) != NULL)
			rdd1(k);
	
		if ( (k=fopen("makecomm", "r")) != NULL)
			rdd1(k);
		else if ( (k=fopen("Makecomm", "r")) != NULL)
			rdd1(k);
		}
#endif

	}

if( (k = pushDescFile(descfile)) != NULL)
	return( rdd1(k) );

return(1);
}




rdd1(k)
FILE * k;
{
extern int yylineno;
extern char *zznextc;

fin = k;
yylineno = 0;
zznextc = 0;

if( yyparse() )
	fatal("Description file error");

if (fin != NULL)
    popDescFile();

return(0);
}

printdesc(prntflag)
int prntflag;
{
struct nameblock *p;
struct depblock *dp;
struct varblock *vp;
struct dirhdr *od;
struct shblock *sp;
struct lineblock *lp;

#ifdef unix
if(prntflag)
	{
	printf("Open directories:\n");
	for (od = firstod; od; od = od->nxtopendir)
		printf("\t%d: %s\n", od->dirfc->dd_fd, od->dirn);
	}
#endif

if(firstvar != 0) printf("Macros:\n");
for(vp = firstvar; vp ; vp = vp->nxtvarblock)
	printf("\t%s = %s\n" , vp->varname , vp->varval);

for(p = firstname; p; p = p->nxtnameblock)
	{
	printf("\n%s",p->namep);
	if(p->linep != 0) printf(":");
	if(prntflag) printf("  done=%d",p->done);
	if(p==mainname) printf("  (MAIN NAME)");
	for(lp = p->linep ; lp ; lp = lp->nxtlineblock)
		{
		if( dp = lp->depp )
			{
			printf("\n\tdepends on:");
			for(; dp ; dp = dp->nxtdepblock)
				if(dp->depname != 0)
					printf(" %s ", dp->depname->namep);
			}
	
		if(sp = lp->shp)
			{
			printf("\n\tcommands:\n");
			for( ; sp!=0 ; sp = sp->nxtshblock)
				printf("\t%s\n", sp->shbp);
			}
		}
	}
printf("\n");
fflush(stdout);
}
