static	char *sccsid = "@(#)dosys.c	4.7 (Berkeley) 83/06/22";
#include "defs"
#ifdef unix
#include <signal.h>
#endif unix

dosys(comstring,nohalt)
register char *comstring;
int nohalt;
{
register int status;

#ifdef Vsystem
if (index(comstring, ';') || index(comstring, '`'))
    status = doremoteshell(comstring);
else
#endif Vsystem
if(metas(comstring))
	status = doshell(comstring,nohalt);
else	status = doexec(comstring);

return(status);
}



metas(s)   /* Are there are any  Shell meta-characters? */
register char *s;
{
register char c;

while( (funny[c = *s++] & META) == 0 )
	;
return( c );
}

#ifndef Vsystem
doshell(comstring,nohalt)
char *comstring;
int nohalt;
{
#ifdef SHELLENV
char *getenv(), *rindex();
char *shellcom = getenv("SHELL");
char *shellstr;
#endif
if((waitpid = vfork()) == 0)
	{
	enbint(SIG_DFL);
	doclose();

#ifdef SHELLENV
	if (shellcom == 0) shellcom = SHELLCOM;
	shellstr = rindex(shellcom, '/') + 1;
	execl(shellcom, shellstr, (nohalt ? "-c" : "-ce"), comstring, 0);
#else
	execl(SHELLCOM, "sh", (nohalt ? "-c" : "-ce"), comstring, 0);
#endif
	fatal("Couldn't load Shell");
	}

return( await() );
}




int intrupt();

await()
{
int status;
register int pid;

enbint(SIG_IGN);
while( (pid = wait(&status)) != waitpid)
	if(pid == -1)
		fatal("bad wait code");
waitpid = 0;
enbint(intrupt);
return(status);
}

#else Vsystem
int doshell(comstring, nohalt)
char *comstring;
  {
    int status;

    status = system(comstring);
    Resynch(stdin);
    Resynch(stdout);
    Seek(stdout, 0, FILE_END);
    Resynch(stderr);
    Seek(stderr, 0, FILE_END);
    return(status);
  }
  
int doremoteshell(comstring)
char *comstring;
  {
    SystemCode err;
    int status;

    if (Execl(stdin, stdout, stderr, &status, &err,
    		"fexecute", "sh", "-c", comstring, 0) == 0)
      {
        fprintf(stderr,
		"Build: Error trying to execute 'fexecute sh -c %s': %s\n",
		comstring, ErrorString(err));
	return(-1);
      }
    else
      {
        Resynch(stdin);
	Resynch(stdout);
	Seek(stdout, 0, FILE_END);
	Resynch(stderr);
	Seek(stderr, 0, FILE_END);
        return(status);
      }
  }


#define MAXARGS 1024

int doexec(comstring)
char *comstring;
  {
    char **args = (char **) malloc(MAXARGS*sizeof(char *));
    ProcessId pid;
    SystemCode err;
    int status;
    
    ParseLine(comstring, args, MAXARGS);
    if (Execv(stdin, stdout, stderr, &status, &err, args) == 0)
      {
        fprintf(stderr, "Build: Error trying to execute %s: %s\n",
		args[0], ErrorString(err));
	status = -1;
      }
    else
      {
        Resynch(stdin);
	Resynch(stdout);
	Seek(stdout, 0, FILE_END);
	Resynch(stderr);
	Seek(stderr, 0, FILE_END);
      }
    free(args);
    return(status);
  }
#endif Vsystem




#ifndef Vsystem
doclose()	/* Close open directory files before exec'ing */
{
register struct dirhdr *od;

for (od = firstod; od; od = od->nxtopendir)
	if (od->dirfc != NULL) {
		closedir(od->dirfc);
		od->dirfc = NULL;
	}
}
#endif Vsystem



#ifndef Vsystem

#define MAXARGV	400

doexec(str)
register char *str;
{
register char *t;
char *argv[MAXARGV];
register char **p;

while( *str==' ' || *str=='\t' )
	++str;
if( *str == '\0' )
	return(-1);	/* no command */

p = argv;
for(t = str ; *t ; )
	{
	if (p >= argv + MAXARGV)
		fatal1("%s: Too many arguments.", str);
	*p++ = t;
	while(*t!=' ' && *t!='\t' && *t!='\0')
		++t;
	if(*t)
		for( *t++ = '\0' ; *t==' ' || *t=='\t'  ; ++t)
			;
	}

*p = NULL;

if((waitpid = fork()) == 0)
	{
	enbint(SIG_DFL);
	doclose();
	enbint(intrupt);
	execvp(str, argv);
	fatal1("Cannot load %s",str);
	}

return( await() );
}
#endif Vsystem

#ifdef Vsystem
#include <Vdirectory.h>

touch(force, name)
int force;
char *name;
  {
    ArbitraryDescriptor desc;
    int junk;
    File *fad;
    SystemCode r;
    unsigned long size;

    if ((r = NReadDescriptor(name, &desc)) != OK)
      {
	if (force && r == NOT_FOUND)
	    goto create;
	else
	  {
	    fprintf(stderr, "touch: error on file %s: %s.\n", 
	    		name, ErrorString(r));
	    Flush(stderr);
	    return;
	  }
      }

    switch (desc.e.descriptortype)
      {
	case FILE_DESCRIPTOR:
	  size = desc.f.size;
	  break;
	case UNIXFILE_DESCRIPTOR:
	  size = desc.u.st_size;
	  break;
	default:
	  fprintf(stderr, "touch: can't touch objects of type %d.\n",
	  		desc.e.descriptortype);
	  Flush(stderr);
	  return;
      }

    if (size == 0)
	goto create;

    if( (fad = Open(name, FMODIFY, &r)) == NULL)
	goto bad;

    if( (junk = getc(fad)) == EOF )
      {
	r = Eof(fad);
	Close(fad);
	goto bad;
      }

    Seek(fad, 0, ABS_BYTE);
    junk = putc(junk, fad);
    Flush(fad);
    r = Eof(fad);
    Close(fad);

    if ( r == OK || (r == END_OF_FILE && junk != EOF) )
	return;

bad:
    fprintf(stderr, "Cannot touch %s: %s\n", name, ErrorString(r));
    Flush(stderr);
    return;

create:
    if( (fad = Open(name, FCREATE, &r)) == NULL)
	goto bad;
    Close(fad);
  }
#else

#include <errno.h>

#include <sys/stat.h>



touch(force, name)
int force;
char *name;
{
struct stat stbuff;
char junk[1];
int fd;

if( stat(name,&stbuff) < 0)
	if(force)
		goto create;
	else
		{
		fprintf(stderr, "touch: file %s does not exist.\n", name);
		return;
		}

if(stbuff.st_size == 0)
	goto create;

if( (fd = open(name, 2)) < 0)
	goto bad;

if( read(fd, junk, 1) < 1)
	{
	close(fd);
	goto bad;
	}
lseek(fd, 0L, 0);
if( write(fd, junk, 1) < 1 )
	{
	close(fd);
	goto bad;
	}
close(fd);
return;

bad:
	fprintf(stderr, "Cannot touch %s\n", name);
	return;

create:
	if( (fd = creat(name, 0666)) < 0)
		goto bad;
	close(fd);
}

#endif Vsystem
