/* Part of the 'bits' font/bitmap editor
 * Transformations: reflection and rotation
 * Copyright (c) Per Bothner, March 1983.
 */
#include "bits.h"
static PopUpEntry TransformMenu[] =
  {
    "Rotate 90 deg. clockwise",		1,
    "Rotate 90 deg. anti-clockwise",	2,
    "Rotate 180 degrees",		3,
    "Reflect about horizontal axis",	4,
    "Reflect about vertical axis",	5,
    0, 0
  };

DoTransform()
  { int w, h, w1, h1, op = popup(TransformMenu); register MemRaster *r;
    if (op <= 0) return;
    if (op <= 2) { h = curRaster->width; w = curRaster->height;}
    else { w = curRaster->width; h = curRaster->height;}
    r = SubRaster(0, 0, 0, 0, h, w);
    w1 = w-1; h1 = h-1;
    switch (op)
      { register x, y;
	case 1:
	    for (x = w; --x >=0 ;) for (y = h; --y >= 0; )
		ChangeBit(r, x, y, ChangeBit(curRaster, y, w1-x, 3));
	    break;
	case 2:
	    for (x = w; --x >=0 ;) for (y = h; --y >= 0; )
		ChangeBit(r, x, y, ChangeBit(curRaster, h1-y, x, 3));
	    break;
	case 3:
	    for (x = w; --x >=0 ;) for (y = h; --y >= 0; )
		ChangeBit(r, x, y, ChangeBit(curRaster, w1-x, h1-y, 3));
	    break;
	case 4:
	    for (x = w; --x >=0 ;) for (y = h; --y >= 0; )
		ChangeBit(r, x, y, ChangeBit(curRaster, x, h1-y, 3));
	    break;
	case 5:
	    for (x = w; --x >=0 ;) for (y = h; --y >= 0; )
		ChangeBit(r, x, y, ChangeBit(curRaster, w1-x, y, 3));
	    break;
      }
    UpdateChar(-1); Update(r);
  }
