/* part of the 'bits' bitmap/font editor. (c) Per Bothner Nov 1983. */
#include "bits.h"
#define Xdata FontTab[256]
#define Xraster Xdata.raster
static MemRaster _Xraster = {0};
short SampleVgt = -1;
NewSample(field)
    Field *field;
  { char *s;
    printf("\033[%d;%dH\033[K", field->row, field->col + SampleHeadWidth);
    if (SampleVgt >= 0)
      {
	ModifyPad(stdin, LineBuffer+Echo+LF_Output+CR_Input); 
	EditLine(stdin, SampleText, strlen(SampleText));
      }
    s = GetString();
    if (!s) return;
    strncpy(SampleText, s, 65);
    UpdateSample();
  }

UpdateSample()
  {
    CalculateSample();
    Xraster = &_Xraster;
    if (_Xraster.start)
	if (_Xraster.width < Xdata.bBox[X] || _Xraster.height < Xdata.bBox[Y])
	    {free(_Xraster.start); _Xraster.start = 0;}
    if (!_Xraster.start)
	Xraster =
	    SubRaster(&_Xraster, 0, 0, 0, Xdata.bBox[Y]+10, Xdata.bBox[X]+80);
    PutSample();
    if (SampleVgt < 0)
      {
	DefineSymbol(sdf, SampleTopItem, 0);
	EndSymbol(sdf, SampleTopItem, 0);
	SampleVgt = CreateVGT(sdf, GRAPHICS+ZOOMABLE, SampleTopItem,
	    "bits (text sample)");
	DefaultView(SampleVgt, Xdata.bBox[X] + 100, Xdata.bBox[Y] + 40,
	    -10, -3, 0, 0, 0, 0);
      }
    EditSymbol(sdf, SampleTopItem);
    DeleteItem(sdf, SampleItem);
    AddItem(sdf, SampleItem, 1, Xraster->width, 1, Xraster->height,
        0, SDF_RASTER, _Xraster.start);
    EndSymbol(sdf, SampleTopItem, SampleVgt); 
  }
static unsigned char *xp;
static Xgetc()
  { int ch = *xp++, i;
    if (ch <= 0) return -1;
    if (ch != '\\') return ch;
    /* handle C-style `\` escapes */
    switch (ch = *xp++)
      {
	case 0:		return '\\';
	case '\\':	return '\\';
	case 'b':	return '\b';
	case 't':	return '\t';
	case 'e':	return '\033';
	case 'r':	return '\r';
	case 'n':	return '\n';
	default:
	    if (ch >= '0'  && ch <= '7')
	      {
		i = ch - '0'; ch = *xp;
		if (ch >= '0'  && ch <= '7')
		  { i <<= 3; i += ch - '0'; ch = *++xp;
		    if (ch >= '0'  && ch <= '7')
		      {i <<= 3; i += ch - '0'; ++xp;}
		  }
		return i;
	      }
	    if (ch >= 0x40 && ch < 0x60) return ch & 037;
	    xp--; return '\\';
      }
  }
CalculateSample()
  { int ch, pMin[2], pMax[2];
    Scaled p[2];
    register coord; /* either X or Y */
    register struct CharData *fPtr;
    pMin[X] = pMin[Y] = 29999; pMax[X] = pMax[Y] = -29999;
    p[X] = p[Y] = 0;
    for (fPtr = FontTab+256; --fPtr >= FontTab; ) fPtr->inSample = 0;
    for (xp = SampleText; (ch = Xgetc()) >= 0; )
      {
	fPtr = &FontTab[ch];
	fPtr->inSample = 1;
	for (coord = 0; coord <= 1; coord++)
	  { int p0 = (p[coord]>>16) - fPtr->origin[coord];
	    if (p0 < pMin[coord]) pMin[coord] = p0;
	    p0 += fPtr->bBox[coord];
	    if (p0 > pMax[coord]) pMax[coord] = p0;
	    p[coord] += fPtr->width[coord];
	  }
      }
    for (coord = 0; coord <= 1; coord++)
      {
        Xdata.bBox[coord] = pMax[coord] - pMin[coord] + 1;
        Xdata.origin[coord] = -pMin[coord];
	Xdata.width[coord] = p[coord];
      }
  }
PutSample()
  { int ch; MemRaster dest, *cR;
    Scaled p[2];
    p[X] = Xdata.origin[X]<<16; p[Y] = Xdata.origin[Y]<<16;
    RasterOp(Xraster, 0, GXclear);
    for (xp = SampleText; (ch = Xgetc()) >= 0; )
      { register struct CharData *fPtr = &FontTab[ch];
	if (fPtr->status == NullChar) continue;
	if (fPtr->status == NotReadChar) (*LoadChar)(ch);
	cR = fPtr->raster;
	SubRaster(&dest, Xraster,
	    (p[X]>>16) - fPtr->origin[X], (p[Y]>>16) - fPtr->origin[Y],
	    cR->height, cR->width);
	RasterOp(&dest, cR, GXpaint);
	p[X] += fPtr->width[X];
	p[Y] += fPtr->width[Y];
      }
  }
