#ifndef lint
static	char sccsid[] = "@(#)ar.c	4.5 (Berkeley) 9/25/83";
#endif

#ifndef BUFSIZ
#define BUFSIZ 1024
#endif

/*
 * ar - portable (ascii) format version
 */
#include <sys/types.h>
#include <sys/time.h>

#include <stdio.h>
#include <ar.h>

#include <Vdirectory.h>
ArbitraryDescriptor stbuf;

struct	ar_hdr	arbuf;
struct	lar_hdr {
	char	lar_name[16];
	long	lar_date;
	u_short	lar_uid;
	u_short	lar_gid;
	u_short	lar_mode;
	long	lar_size;
} larbuf;

#define	SKIP	1
#define	IODD	2
#define	OODD	4
#define	HEAD	8

char	*man	=	{ "mrxtdpq" };
char	*opt	=	{ "uvnbailo" };

int	rcmd();
int	dcmd();
int	xcmd();
int	tcmd();
int	pcmd();
int	mcmd();
int	qcmd();
int	(*comfun)();
char	flg[26];
char	**namv;
int	namc;
char	*arnam;
char	*ponam;
char	*tmpnam		=	{ "/tmp/vXXXXXX" };
char	*tmp1nam	=	{ "/tmp/v1XXXXXX" };
char	*tmp2nam	=	{ "/tmp/v2XXXXXX" };
char	*tfnam;
char	*tf1nam;
char	*tf2nam;
char	*file;
char	name[16];
FILE	*af;
FILE	*tf;
FILE	*tf1;
FILE	*tf2;
FILE	*qf;
int	bastate;
char	buf[BUFSIZ];
int	truncate;			/* ok to truncate argument filenames */

FILE	*stats();
unsigned long TimeStamp(), FileSize(), UnixPerms(), UnixUid(), UnixGid();

char	*trim();
char	*mktemp();
char	*ctime();
SystemCode ReadDescriptor();

main(argc, argv)
char *argv[];
{
	register i;
	register char *cp;

	if(argc < 3)
		usage();
	cp = argv[1];
	for(cp = argv[1]; *cp; cp++)
	switch(*cp) {
	case 'o':
	case 'l':
	case 'v':
	case 'u':
	case 'n':
	case 'a':
	case 'b':
	case 'c':
	case 'i':
		flg[*cp - 'a']++;
		continue;

	case 'r':
		setcom(rcmd);
		continue;

	case 'd':
		setcom(dcmd);
		continue;

	case 'x':
		setcom(xcmd);
		continue;

	case 't':
		setcom(tcmd);
		continue;

	case 'p':
		setcom(pcmd);
		continue;

	case 'm':
		setcom(mcmd);
		continue;

	case 'q':
		setcom(qcmd);
		continue;

	default:
		fprintf(stderr, "ar: bad option `%c'\n", *cp);
		done(1);
	}
	if(flg['l'-'a']) {
		tmpnam = "vXXXXXX";
		tmp1nam = "v1XXXXXX";
		tmp2nam = "v2XXXXXX";
	}
	if(flg['i'-'a'])
		flg['b'-'a']++;
	if(flg['a'-'a'] || flg['b'-'a']) {
		bastate = 1;
		ponam = trim(argv[2]);
		argv++;
		argc--;
		if(argc < 3)
			usage();
	}
	arnam = argv[2];
	namv = argv+3;
	namc = argc-3;
	if(comfun == 0) {
		if(flg['u'-'a'] == 0) {
			fprintf(stderr, "ar: one of [%s] must be specified\n", man);
			done(1);
		}
		setcom(rcmd);
	}
	(*comfun)();
	done(notfound());
}

setcom(fun)
int (*fun)();
{

	if(comfun != 0) {
		fprintf(stderr, "ar: only one of [%s] allowed\n", man);
		done(1);
	}
	comfun = fun;
}

rcmd()
{
	register FILE *f;
	unsigned long mtime;

	init();
	getaf();
	while(!getdir()) {
		bamatch();
		if(namc == 0 || match()) {
			f = stats();
			if(f == NULL) {
				if(namc)
					fprintf(stderr, "ar: cannot open %s\n", file);
				goto cp;
			}
			if(flg['u'-'a']) {
				if(TimeStamp(&stbuf) <= larbuf.lar_date) {
					fclose(f);
					goto cp;
				}
			}
			mesg('r');
			copyfil(af, NULL, IODD+SKIP);
			movefil(f);
			continue;
		}
	cp:
		mesg('c');
		copyfil(af, tf, IODD+OODD+HEAD);
	}
	cleanup();
}

dcmd()
{

	init();
	if(getaf())
		noar();
	while(!getdir()) {
		if(match()) {
			mesg('d');
			copyfil(af, NULL, IODD+SKIP);
			continue;
		}
		mesg('c');
		copyfil(af, tf, IODD+OODD+HEAD);
	}
	install();
}

xcmd()
{
	register FILE *f;
#ifdef undef
	struct timeval tv[2];
#endif undef

	if(getaf())
		noar();
	while(!getdir()) {
		if(namc == 0 || match()) {
			f = fopen(file, "w");
			/* %%% should get permissions from archive */
			if(f == NULL) {
				fprintf(stderr, "ar: %s cannot create\n", file);
				goto sk;
			}
			mesg('x');
			copyfil(af, f, IODD);
			fclose(f);
#ifdef undef
			if (flg['o'-'a']) {
				tv[0].tv_sec = tv[1].tv_sec = larbuf.lar_date;
				tv[0].tv_usec = tv[1].tv_usec = 0;
				utimes(file, tv);
			}
#endif undef
			continue;
		}
	sk:
		mesg('c');
		copyfil(af, NULL, IODD+SKIP);
		if (namc > 0  &&  !morefil())
			done(0);
	}
}

pcmd()
{

	if(getaf())
		noar();
	while(!getdir()) {
		if(namc == 0 || match()) {
			if(flg['v'-'a']) {
				printf("\n<%s>\n\n", file);
				fflush(stdout);
			}
			copyfil(af, 1, IODD);
			continue;
		}
		copyfil(af, NULL, IODD+SKIP);
	}
}

mcmd()
{

	init();
	if(getaf())
		noar();
	tf2nam = mktemp(tmp2nam);
	tf2 = fopen(tf2nam, "w+");
	if(tf2 == NULL) {
		fprintf(stderr, "ar: cannot create third temp\n");
		done(1);
	}
	while(!getdir()) {
		bamatch();
		if(match()) {
			mesg('m');
			copyfil(af, tf2, IODD+OODD+HEAD);
			continue;
		}
		mesg('c');
		copyfil(af, tf, IODD+OODD+HEAD);
	}
	install();
}

tcmd()
{

	if(getaf())
		noar();
	while(!getdir()) {
		if(namc == 0 || match()) {
			if(flg['v'-'a'])
				longt();
			printf("%s\n", trim(file));
		}
		copyfil(af, NULL, IODD+SKIP);
	}
}

qcmd()
{
	register i;
	FILE *f;

	if (flg['a'-'a'] || flg['b'-'a']) {
		fprintf(stderr, "ar: abi not allowed with q\n");
		done(1);
	}
	truncate++;
	getqf();

	fseek(qf, 0, FILE_END);
	for(i=0; i<namc; i++) {
		file = namv[i];
		if(file == 0)
			continue;
		namv[i] = 0;
		mesg('q');
		f = stats();
		if(f < 0) {
			fprintf(stderr, "ar: %s cannot open\n", file);
			continue;
		}
		tf = qf;
		movefil(f);
		qf = tf;
	}
}

init()
{

	tfnam = mktemp(tmpnam);
	tf = fopen(tfnam, "w+");
	if(tf == NULL) {
		fprintf(stderr, "ar: cannot create temp file\n");
		done(1);
	}
	if (fwrite(ARMAG, SARMAG, 1, tf) != 1)
		wrerr();
}

getaf()
{
	char mbuf[SARMAG];

	af = fopen(arnam, "r");
	if(af == NULL)
		return(1);
	if (fread(mbuf, SARMAG, 1, af) != 1 || 
	    strncmp(mbuf, ARMAG, SARMAG)) {
		fprintf(stderr, "ar: %s not in archive format\n", arnam);
		done(1);
	}
	return(0);
}

getqf()
{
	char mbuf[SARMAG];

	if ((qf = fopen(arnam, "r+")) == NULL) {
		if(!flg['c'-'a'])
			fprintf(stderr, "ar: creating %s\n", arnam);
		if ((qf = fopen(arnam, "w+")) < 0) {
			fprintf(stderr, "ar: cannot create %s\n", arnam);
			done(1);
		}
		if (fwrite(ARMAG, SARMAG, 1, qf) != 1)
			wrerr();
	} else if (fread(mbuf, SARMAG, 1, qf) != 1
		|| strncmp(mbuf, ARMAG, SARMAG)) {
		fprintf(stderr, "ar: %s not in archive format\n", arnam);
		done(1);
	}
}

usage()
{
	printf("usage: ar [%s][%s] archive files ...\n", man, opt);
	done(1);
}

noar()
{

	fprintf(stderr, "ar: %s does not exist\n", arnam);
	done(1);
}

done(c)
{

	if(tfnam)
		unlink(tfnam);
	if(tf1nam)
		unlink(tf1nam);
	if(tf2nam)
		unlink(tf2nam);
	exit(c);
}

notfound()
{
	register i, n;

	n = 0;
	for(i=0; i<namc; i++)
		if(namv[i]) {
			fprintf(stderr, "ar: %s not found\n", namv[i]);
			n++;
		}
	return(n);
}

morefil()
{
	register i, n;

	n = 0;
	for(i=0; i<namc; i++)
		if(namv[i])
			n++;
	return(n);
}

cleanup()
{
	register i;
	register FILE *f;

	truncate++;
	for(i=0; i<namc; i++) {
		file = namv[i];
		if(file == 0)
			continue;
		namv[i] = 0;
		mesg('a');
		f = stats();
		if(f < 0) {
			fprintf(stderr, "ar: %s cannot open\n", file);
			continue;
		}
		movefil(f);
	}
	install();
}

install()
{
	register i;

	if(af == NULL)
		if(!flg['c'-'a'])
			fprintf(stderr, "ar: creating %s\n", arnam);
	fclose(af);
	af = fopen(arnam, "w");
	if(af == NULL) {
		fprintf(stderr, "ar: cannot create %s\n", arnam);
		done(1);
	}
	if(tfnam) {
		fseek(tf, 0, ABS_BYTE);
		while((i = fread(buf, 1, BUFSIZ, tf)) > 0)
			if (fwrite(buf, i, 1, af) != 1)
				wrerr();
	}
	if(tf2nam) {
		fseek(tf2, 0, ABS_BYTE);
		while((i = fread(buf, 1, BUFSIZ, tf2)) > 0)
			if (fwrite(buf, i, 1, af) != 1)
				wrerr();
	}
	if(tf1nam) {
		fseek(tf1, 0, ABS_BYTE);
		while((i = fread(buf, 1, BUFSIZ, tf1)) > 0)
			if (fwrite(buf, i, 1, af) != 1)
				wrerr();
	}
}

/*
 * insert the file 'file'
 * into the temporary file
 */
movefil(f)
{
	char buf[sizeof(arbuf)+1];

	sprintf(buf, "%-16s%-12ld%-6u%-6u%-8o%-10ld%-2s",
	   trim(file),
	   TimeStamp(&stbuf),
	   UnixUid(&stbuf),
	   UnixGid(&stbuf),
	   UnixPerms(&stbuf),
	   FileSize(&stbuf),
	   ARFMAG);
	strncpy((char *)&arbuf, buf, sizeof(arbuf));
	larbuf.lar_size = FileSize(&stbuf);
	copyfil(f, tf, OODD+HEAD);
	fclose(f);
}

FILE *stats()
{
	register FILE *f;

	f = fopen(file, "r");
	if(f == NULL)
		return(f);
	if(ReadDescriptor(FileServer(f), FileId(f), &stbuf) != OK) {
		fclose(f);
		return(NULL);
	}
	return(f);
}

/*
 * copy next file
 * size given in arbuf
 */
copyfil(fi, fo, flag)
{
	register i, o;
	int pe;

	if(flag & HEAD) {
		for (i=sizeof(arbuf.ar_name)-1; i>=0; i--) {
			if (arbuf.ar_name[i]==' ')
				continue;
			else if (arbuf.ar_name[i]=='\0')
				arbuf.ar_name[i] = ' ';
			else
				break;
		}
		if (fwrite((char *)&arbuf, sizeof arbuf, 1, fo) != 1)
			wrerr();
	}
	pe = 0;
	while(larbuf.lar_size > 0) {
		i = o = BUFSIZ;
		if(larbuf.lar_size < i) {
			i = o = larbuf.lar_size;
			if(i&1) {
				buf[i] = '\n';
				if(flag & IODD)
					i++;
				if(flag & OODD)
					o++;
			}
		}
		if (fi == NULL || fread(buf, i, 1, fi) != 1)
			pe++;
		if((flag & SKIP) == 0)
			if (fwrite(buf, o, 1, fo) != 1)
				wrerr();
		larbuf.lar_size -= BUFSIZ;
	}
	if(pe)
		phserr();
}

getdir()
{
	register char *cp;
	register i;
	register FILE *swap;

	if (af == NULL)
		i = 0;
	else
		i = fread((char *)&arbuf, 1, sizeof arbuf, af);
	if(i != sizeof arbuf) {
		if(tf1nam) {
			swap = tf;
			tf = tf1;
			tf1 = swap;
		}
		return(1);
	}
	if (strncmp(arbuf.ar_fmag, ARFMAG, sizeof(arbuf.ar_fmag))) {
		fprintf(stderr, "ar: malformed archive (at %ld)\n", 
			BytePosition(af));
		done(1);
	}
	cp = arbuf.ar_name + sizeof(arbuf.ar_name);
	while (*--cp==' ')
		;
	*++cp = '\0';
	strncpy(name, arbuf.ar_name, sizeof(arbuf.ar_name));
	file = name;
	strncpy(larbuf.lar_name, name, sizeof(larbuf.lar_name));
	sscanf(arbuf.ar_date, "%ld", &larbuf.lar_date);
	sscanf(arbuf.ar_uid, "%hd", &larbuf.lar_uid);
	sscanf(arbuf.ar_gid, "%hd", &larbuf.lar_gid);
	sscanf(arbuf.ar_mode, "%ho", &larbuf.lar_mode);
	sscanf(arbuf.ar_size, "%ld", &larbuf.lar_size);
	return(0);
}

match()
{
	register i;

	for(i=0; i<namc; i++) {
		if(namv[i] == 0)
			continue;
		if(strcmp(trim(namv[i]), file) == 0) {
			file = namv[i];
			namv[i] = 0;
			return(1);
		}
	}
	return(0);
}

bamatch()
{
	register FILE *f;

	switch(bastate) {

	case 1:
		if(strcmp(file, ponam) != 0)
			return;
		bastate = 2;
		if(flg['a'-'a'])
			return;

	case 2:
		bastate = 0;
		tf1nam = mktemp(tmp1nam);
		f = fopen(tf1nam, "w+");
		if(f == NULL) {
			fprintf(stderr, "ar: cannot create second temp\n");
			return;
		}
		tf1 = tf;
		tf = f;
	}
}

phserr()
{

	fprintf(stderr, "ar: phase error on %s\n", file);
}

mesg(c)
{

	if(flg['v'-'a'])
		if(c != 'c' || flg['v'-'a'] > 1)
			printf("%c - %s\n", c, file);
}

char *
trim(s)
char *s;
{
	register char *p1, *p2;

	/* Strip trailing slashes */
	for(p1 = s; *p1; p1++)
		;
	while(p1 > s) {
		if(*--p1 != '/')
			break;
		*p1 = 0;
	}

	/* Find last component of path; do not zap the path */
	p2 = s;
	for(p1 = s; *p1; p1++)
		if(*p1 == '/')
			p2 = p1+1;

	/*
	 * Truncate name if too long, only if we are doing an 'add'
	 * type operation. We only allow 15 cause rest of ar
	 * isn't smart enough to deal with non-null terminated
	 * names.  Need an exit status convention...
	 * Need yet another new archive format...
	 */
	if (truncate && strlen(p2) > sizeof(arbuf.ar_name) - 1) {
		fprintf(stderr, "ar: filename %s truncated to ", p2);
		*(p2 + sizeof(arbuf.ar_name) - 1) = '\0';
		fprintf(stderr, "%s\n", p2);
	}
	return(p2);
}

#define	IFMT	060000
#define	ISARG	01000
#define	LARGE	010000
#define	SUID	04000
#define	SGID	02000
#define	ROWN	0400
#define	WOWN	0200
#define	XOWN	0100
#define	RGRP	040
#define	WGRP	020
#define	XGRP	010
#define	ROTH	04
#define	WOTH	02
#define	XOTH	01
#define	STXT	01000

longt()
{
	register char *cp;

	pmode();
	printf("%3d/%1d", larbuf.lar_uid, larbuf.lar_gid);
	printf("%7ld", larbuf.lar_size);
	cp = ctime(&larbuf.lar_date);
	printf(" %-12.12s %-4.4s ", cp+4, cp+20);
}

int	m1[] = { 1, ROWN, 'r', '-' };
int	m2[] = { 1, WOWN, 'w', '-' };
int	m3[] = { 2, SUID, 's', XOWN, 'x', '-' };
int	m4[] = { 1, RGRP, 'r', '-' };
int	m5[] = { 1, WGRP, 'w', '-' };
int	m6[] = { 2, SGID, 's', XGRP, 'x', '-' };
int	m7[] = { 1, ROTH, 'r', '-' };
int	m8[] = { 1, WOTH, 'w', '-' };
int	m9[] = { 2, STXT, 't', XOTH, 'x', '-' };

int	*m[] = { m1, m2, m3, m4, m5, m6, m7, m8, m9};

pmode()
{
	register int **mp;

	for (mp = &m[0]; mp < &m[9];)
		select(*mp++);
}

select(pairp)
int *pairp;
{
	register int n, *ap;

	ap = pairp;
	n = *ap++;
	while (--n>=0 && (larbuf.lar_mode&*ap++)==0)
		ap++;
	putchar(*ap);
}

wrerr()
{
	fprintf(stderr, "ar write error");
	done(1);
}

unsigned long TimeStamp(desc)
register ArbitraryDescriptor *desc;
{
    switch(desc->e.descriptortype)
      {
	case FILE_DESCRIPTOR:
	  return desc->f.timestamp;
	case UNIXFILE_DESCRIPTOR:
	  return desc->u.st_mtime;
	default:
	  fprintf(stderr, "Can't handle descriptor type %d",
		  desc->e.descriptortype);
	  return 0;
      }
}

unsigned long FileSize(desc)
register ArbitraryDescriptor *desc;
{
    switch(desc->e.descriptortype)
      {
	case FILE_DESCRIPTOR:
	  return desc->f.size;
	case UNIXFILE_DESCRIPTOR:
	  return desc->u.st_size;
	default:
	  fprintf(stderr, "Can't handle descriptor type %d",
		  desc->e.descriptortype);
	  return 0;
      }
}

#include <Vstorage.h>

unsigned long UnixPerms(desc)
register ArbitraryDescriptor *desc;
{
    unsigned long perms;

    switch(desc->e.descriptortype)
      {
	case FILE_DESCRIPTOR:
	  /* %%% Hold your nose...*/
	  perms = ((desc->f.perms >> 2)&0007) + 
	  	  ((desc->f.perms >> 4)&0070) +
	  	  ((desc->f.perms >> 6)&0700);
	  return perms;
	case UNIXFILE_DESCRIPTOR:
	  return desc->u.st_mode;
	default:
	  fprintf(stderr, "Can't handle descriptor type %d",
		  desc->e.descriptortype);
	  return 0;
      }
}

unsigned long UnixUid(desc)
register ArbitraryDescriptor *desc;
{
    switch(desc->e.descriptortype)
      {
	case FILE_DESCRIPTOR:
	  /* %%% Who knows? */
	  return 1;
	case UNIXFILE_DESCRIPTOR:
	  return desc->u.st_uid;
	default:
	  fprintf(stderr, "Can't handle descriptor type %d",
		  desc->e.descriptortype);
	  return 0;
      }
}

unsigned long UnixGid(desc)
register ArbitraryDescriptor *desc;
{
    switch(desc->e.descriptortype)
      {
	case FILE_DESCRIPTOR:
	  /* %%% Who knows? */
	  return 1;
	case UNIXFILE_DESCRIPTOR:
	  return desc->u.st_gid;
	default:
	  fprintf(stderr, "Can't handle descriptor type %d",
		  desc->e.descriptortype);
	  return 0;
      }
}

