/*
 * emulate weird vax instructions
 */

/* Instructions we are emulating. */

#define ADDP4 0x20
#define CMPC3 0x29
#define SCANC 0x2a
#define MOVP 0x34
#define EDITPC 0x38
#define LOCC 0x3A
#define SKPC 0x3B
#define ASHP 0xf8
#define CVTLP 0xf9

#define LOW(i) ((i)&1)
#define DEREFB(a, i) ((a)[(i)])
#define DEREFN(a, i) ((a)[(i>>1)])
#define READB(a, i) (DEREFB(a,i)&0xFF)
#define READN(a, i) ((LOW(i))? (DEREFN(a,i)&0x0F) : ((DEREFN(a,i)&0xF0)>>4))
#define STOREB(a,i,v) (DEREFB(a,i) = ((v)&0xFF))
#define STOREN(a,i,v) (DEREFN(a,i) = (LOW(i))? (DEREFN(a,i)&0xF0)|((v)&0xF) :\
		       (DEREFN(a,i)&0x0F)|(((v)&0xF)<<4))

#define PSL_CARRY 0x1
#define PSL_OVERFLOW 0x2
#define PSL_CONDMASK ~0xF
#define PSL_ZERO 0x4
#define PSL_NEG 0x8

struct emt_trapargs {
    unsigned int r0;
    unsigned int r1;
    unsigned int r2;
    unsigned int r3;
    unsigned int r4;
    unsigned int r5;
    unsigned int opcode;
    unsigned int oldpc;
    unsigned int a1;
    unsigned int a2;
    unsigned int a3;
    unsigned int a4;
    unsigned int a5;
    unsigned int a6;
    unsigned int a7;
    unsigned int a8;
    unsigned int newpc;
    unsigned int psl;
  };

void emt_handle(emt)
   struct emt_trapargs emt;
  {
    asm(".globl _emt_handler");
    asm("_emt_handler: pushr $0x3F");
    emt.psl &= PSL_CONDMASK;

    switch (emt.opcode)
      {
    case ADDP4:
      {
	register int sp, dp, soff, sum, sign, i;
#define SRC ((char *)emt.a2)
#define DST ((char *)emt.a4)
#define SRCLEN (emt.a1)
#define DSTLEN (emt.a3)

	emt.r1 = emt.a2;
	emt.r3 = emt.a4;
	emt.r0 = emt.r2 = 0;

	if (SRCLEN & 1)
	    sp = 0;
	else
	    sp = 1;

	if (DSTLEN & 1)
	    dp = 0;
	else
	  {
	    STOREN(DST, 0, 0);
	    dp = 1;
	  }

	emt.psl |= PSL_ZERO;

	if (READN(SRC, SRCLEN+sp) == 0xD)
	    sign = -1;
	else
	    sign = 1;

	if (READN(DST, DSTLEN+dp) == 0xD)
	    sign = -sign;

	if (sign < 0)
	    emt.psl |= PSL_NEG;

	for (sum = 0, i = DSTLEN-1; i >= 0; i--, sum /= 10)
	  {
	    sum += sign*((int)READN(DST, dp+i));
	    if ((soff = SRCLEN-DSTLEN+i) >= 0)
		sum += READN(SRC, sp+soff);
	    if ((emt.psl & PSL_ZERO) && (sum%10))
		emt.psl &= ~PSL_ZERO;
	    STOREN(DST, dp+i, sum%10);
	  }

	if ((sign < 0) && (emt.psl & PSL_ZERO))
	    emt.psl &= ~PSL_NEG;

	STOREN(DST, DSTLEN+dp, (emt.psl & PSL_NEG)?0xD:0xC);

#undef SRC
#undef DST
#undef SRCLEN
#undef DSTLEN
      }
        break;

    case CMPC3:
	for (emt.r0 = emt.a1, emt.r1 = emt.a2, emt.r3 = emt.a3;
	     (emt.r0 > 0) && (*((char *)(emt.r1)) == *((char *)(emt.r3)));
	     emt.r0--, emt.r1++, emt.r3++);
	if (emt.r0 == 0)
	    emt.psl |= PSL_ZERO;
	else if ((*(char *)(emt.r1)) < (*(char *)(emt.r3)))
	    emt.psl |= PSL_NEG;
	if ((*(unsigned char *)(emt.r1)) < (*(unsigned char *)(emt.r3)))
	    emt.psl |= PSL_CARRY;
	emt.r2 = emt.r0;
	break;

    case SCANC:
	for (emt.r0 = emt.a1, emt.r1 = emt.a2, emt.r3 = emt.a3;
	     (emt.r0 > 0) && (*((char *)(emt.r3 + emt.r1)) & (char)(emt.a4));
	     emt.r0--, emt.r1++);
	if (emt.r0 == 0)
	    emt.psl |= PSL_ZERO;
	emt.r2 = 0;
	break;

    case MOVP:
      {
	register int p, i;
#define SRC ((char *)emt.r1)
#define DST ((char *)emt.r3)
#define LEN (emt.a1)

	emt.r1 = emt.a2;
	emt.r3 = emt.a3;
	emt.r0 = emt.r2 = 0;

	if (LEN & 1)
	    p = 0;
	else
	  {
	    STOREN(DST, 0, 0);
	    p = 1;
	  }

	emt.psl |= PSL_ZERO;

	if (READN(SRC, LEN+p) == 0xD)
	    emt.psl |= PSL_NEG;

	for (i = LEN-1; i >= 0; i--)
	  {
	    if ((emt.psl & PSL_ZERO) && (READN(SRC, p+i) != 0))
		emt.psl &= ~PSL_ZERO;
	    STOREN(DST, p+i, READN(SRC, p+i));
	  }

	STOREN(DST, LEN+p, (emt.psl & PSL_NEG)?0xD:0xC);

#undef SRC
#undef DST
#undef LEN
      }
        break;

    case EDITPC:
      {
	register unsigned exit, sp, pp, dp;
	register int count, zcount, c;
	register char fill, sign;
#define SRC ((char *)emt.a2)
#define SRCLEN (emt.a1)
#define PAT ((char *)emt.a3)
#define DST ((char *)emt.a4)

	emt.r0 = emt.a1;
	emt.r1 = emt.a2;
	emt.r2 = emt.r4 = 0;
	emt.r3 = emt.a3;
	emt.r5 = emt.a4;

	emt.psl |= PSL_ZERO;

	pp = dp = 0;

	zcount = 0;

	fill = ' ';

	sp = (SRCLEN & 1)?0:1;

	if (READN(SRC, SRCLEN+sp) == 0xD)
	  {
	    emt.psl |= PSL_NEG;
	    sign = '-';
	  }
	else
	    sign = ' ';

	for (exit = 0; !exit; pp++)
	  {
	    switch (READB(PAT, pp))
	      {
	    case 0x0:		/* EO$END */
		exit = 1;
		break;
	    case 0x1:		/* EO$END_FLOAT */
		if (!(emt.psl & PSL_CARRY))
		  {
		    STOREB(DST, dp, sign);
		    emt.psl |= PSL_CARRY;
		    dp++;
		  }
		break;
	    case 0x2:		/* EO$CLEAR_SIGNIF */
		emt.psl &= ~PSL_CARRY;
		break;
	    case 0x3:		/* EO$SET_SIGNIF */
		emt.psl |= PSL_CARRY;
		break;
	    case 0x4:		/* EO$STORE_SIGN */
		STOREB(DST, dp, sign);
		dp++;
		break;
	    case 0x40:		/* EO$LOAD_FILL */
		pp++;
		fill = READB(PAT, pp);
		break;
	    case 0x41:		/* EO$LOAD_SIGN */
		pp++;
		sign = READB(PAT, pp);
		break;
	    case 0x42:		/* EO$LOAD_PLUS */
		if (!(emt.psl & PSL_NEG))
		  {
		    pp++;
		    sign = READB(PAT, pp);
		  }
		break;
	    case 0x43:		/* EO$LOAD_MINUS */
		if (emt.psl & PSL_NEG)
		  {
		    pp++;
		    sign = READB(PAT, pp);
		  }
		break;
	    case 0x44:		/* EO$INSERT */
		pp++;
		STOREB(DST, dp, DEREFN(PAT, pp));
		dp++;
		break;
	    case 0x45:		/* EO$BLANK_ZERO */
		pp++;
		count = READB(PAT, pp) << 4;
		if (emt.psl & PSL_ZERO)
		    for (; count > 0; count--)
		      {
			STOREB(DST, dp-count, fill);
			dp++;
		      }
		break;
	    case 0x46:		/* EO$REPLACE_SIGN */
		pp++;
		count = READB(PAT, pp);
		if (emt.psl & PSL_ZERO)
		  {
		    STOREB(DST, dp, fill);
		    dp++;
		  }
		break;
	    case 0x47:		/* EO$ADJUST_INPUT */
		pp++;
		count = SRCLEN - READB(PAT, pp);
		if (count < 0)
		    zcount = -count;
		else
		    for (; count > 0; count--, sp++)
			if (!(emt.psl & PSL_OVERFLOW) && READN(SRC, sp) != 0)
			  {
			    emt.psl &= ~PSL_ZERO;
			    emt.psl |= PSL_CARRY | PSL_OVERFLOW;
			  }
		break;
	    default:
		switch  (READB(PAT, pp) & 0xF0)
		  {
		case 0x80:	/* EO$FILL */
		    for (count = READB(PAT, pp) & 0x0F;
			 count > 0; count--, dp++)
			STOREB(DST, dp, fill);
		    break;
		case 0x90:	/* EO$MOVE */
		    for (count = READB(PAT, pp) & 0x0F;
			 count > 0; count--, dp++, sp++)
		      {
			if (zcount)
			  {
			    c = 0;
			    zcount--;
			  }
			else
			    c = READN(SRC, sp);
			if (!(emt.psl & PSL_CARRY) && c != 0)
			  {
			    emt.psl &= ~PSL_ZERO;
			    emt.psl |= PSL_CARRY;
			  }
			if (emt.psl & PSL_CARRY)
			    STOREB(DST, dp, '0'+c);
			else
			    STOREB(DST, dp, fill);
		      }
		    break;
		case 0xA0:	/* EO$FLOAT */
		    for (count = READB(PAT, pp) & 0x0F;
			 count > 0; count--, dp++, sp++)
		      {
			if (zcount)
			  {
			    c = 0;
			    zcount--;
			  }
			else
			    c = READN(SRC, sp);
			if (!(emt.psl & PSL_CARRY) && c != 0)
			  {
			    emt.psl &= ~PSL_ZERO;
			    emt.psl |= PSL_CARRY;
			    STOREB(DST, dp, sign);
			    dp++;
			  }
			if (emt.psl & PSL_CARRY)
			    STOREB(DST, dp, '0'+c);
			else
			    STOREB(DST, dp, fill);
		      }
		    break;
		  }
		break;
	      }
	  }

	emt.r3 += pp;
	emt.r5 += dp;

#undef SRC
#undef SRCLEN
#undef PAT
#undef DST
      }
        break;

    case LOCC:
        for (emt.r0 = emt.a2, emt.r1 = emt.a3;
	     (emt.r0 > 0) && (*((char *)(emt.r1)) != (char)(emt.a1));
	     emt.r0--, emt.r1++)
	    if (emt.r0 == 0)
		emt.psl |= PSL_ZERO;
	break;

    case SKPC:
        for (emt.r0 = emt.a2, emt.r1 = emt.a3;
	     (emt.r0 > 0) && (*((char *)(emt.r1)) == (char)(emt.a1));
	     emt.r0--, emt.r1++)
	    if (emt.r0 == 0)
		emt.psl |= PSL_ZERO;
	break;

    case ASHP:
      {
	register int sum, sp, dp, p1, p2, i;
#define SRC ((char *)emt.a3)
#define DST ((char *)emt.a6)
#define SRCLEN ((int)emt.a2)
#define DSTLEN ((int)emt.a5)
#define CNT ((int)emt.a1)
#define RND (emt.a4)

	emt.r1 = emt.a3;
	emt.r3 = emt.a6;
	emt.r0 = emt.r2 = 0;

	if (SRCLEN & 1)
	    sp = 0;
	else
	    sp = 1;

	if (DSTLEN & 1)
	    dp = 0;
	else
	  {
	    STOREN(DST, 0, 0);
	    dp = 1;
	  }

	emt.psl |= PSL_ZERO;

	if (READN(SRC, SRCLEN+sp) == 0xD)
	    emt.psl |= PSL_NEG;

	if (CNT & 0x80)
	    emt.a1 = CNT - 0x100;
	else
	    emt.a1 = CNT;

	if (CNT < 0)
	  {
	    p1 = DSTLEN-SRCLEN-CNT;
	    if (p1 > DSTLEN)
		p1 = DSTLEN;

	    for (i = 0; i < p1; i++)
		STOREN(DST, dp+i, 0);

	    if (SRCLEN+CNT > 0)
		sum = ((int)(READN(SRC, sp+SRCLEN+CNT-1) + RND)) / 10;
	    else
		sum = 0;
	    for (i = DSTLEN-1; i >= p1; i--, sum /= 10)
	      {
		sum += READN(SRC, sp+i-p1);
		if ((emt.psl & PSL_ZERO) && (sum%10 != 0))
		    emt.psl &= ~PSL_ZERO;
		STOREN(DST, dp+i, sum%10);
	      }
	  }
	else
	  {
	    p1 = DSTLEN-SRCLEN-CNT;
	    p2 = DSTLEN-CNT;

	    if (p1 < 0)
	      {
		emt.psl |= PSL_OVERFLOW;
		p1 = 0;
		if (p2 < 0)
		    p2 = 0;
	      }
	    else
		for (i = 0; i < p1; i++)
		    STOREN(DST, dp+i, 0);

	    for (i = p1; i < p2; i++)
	      {
		if ((emt.psl & PSL_ZERO) &&
		    (READN(SRC, sp+SRCLEN-p2+i) != 0))
		    emt.psl &= ~PSL_ZERO;
		STOREN(DST, dp+i, READN(SRC, sp+SRCLEN-p2+i));
	      }

	    for (i = p2; i < DSTLEN; i++)
		STOREN(DST, dp+i, 0);
	  }

	if (emt.psl & PSL_ZERO)
	    emt.psl &= ~PSL_NEG;
	STOREN(DST, DSTLEN+dp, (emt.psl & PSL_NEG)?0xD:0xC);

#undef SRC
#undef DST
#undef SRCLEN
#undef DSTLEN
#undef CNT
#undef RND
      }
        break;

    case CVTLP:
      {
	register int l, dp, i, x;
#define SRC ((int)emt.a1)
#define DST ((char*)emt.a3)
#define DSTLEN ((int)emt.a2)

	emt.r0 = emt.r1 = emt.r2 = 0;
	emt.r3 = emt.a3;

	if (DSTLEN & 1)
	    dp = 0;
	else
	  {
	    STOREN(DST, 0, 0);
	    dp = 1;
	  }

	if ((l = SRC) < 0)
	  {
	    l = -l;
	    STOREN(DST, DSTLEN+dp, 0xD);
	    emt.psl |= PSL_NEG;
	  }
	else
	  {
	    STOREN(DST, DSTLEN+dp, 0xC);
	    if (l == 0)
		emt.psl |= PSL_ZERO;
	  }

	for (i = DSTLEN-1, x = 10;
	     i >= 0 && l > 0;
	     i--, l -= l%x, x *= 10)
	    STOREN(DST, dp+i, (l%x)/(x/10));

	for (;i >= 0; i--)
	    STOREN(DST, dp+i, 0);

	if (l > 0)
	    emt.psl |= PSL_OVERFLOW;

#undef SRC
#undef DST
#undef DSTLEN
      }
	break;

    default:
      asm("halt");
      }
    ; asm("popr $0x3F");
    asm("addl2 $(18-2)*4, sp");
    asm("rei");
  }
