/*
 * Distributed V Kernel - Copyright (c) 1982 by Stanford University
 *
 * $Revision: 1.5.1.3 $
 * $Locker:  $
 * $State: Exp $
 */


/* This routine db_stackdump()  is intended to give me a look at the stack.
I don't expect it to be much use outside that...

Tony Mason
7 Aug 1987

*/
#include "process.h"
#include "memory.h"
#include "debugger.h"
#include "externals.h"
#include "asmdefs.h"

typedef struct frame {
int cond_handlr;		/* 0 */
int zero:5;				/* 4 */
int psw:10;
int zero1:1;
int mask:12;
int zero2:1;
int s:1;
int	spa:2;
int *ap;				/* 8 */
struct frame	*fp;	/* 12 */
int	pc;					/* 16 */
int r0;
int	r1;
int	r2;
int	r3;
int	r4;
int	r5;
int	r6;
int	r7;
int	r8;
int	r9;
int	r10;
int	r11;
} frame;

typedef struct calls {
	char calls_op;	/* the calls opcode */
	char mode;		/* access mode */
	char offset_mode;/* the displacement mode */
	char	 offset[4]; 	/* displacement offset to the routine */
} calls;

/* calls instruction is 7 bytes long */



static	frame	*frameptr;
long	*argptr;
static  calls	*call;
long called_from;
long called_addr;

void
db_stack_dump(testarg)
int testarg;
{
	int	index;
	int offset;
	int	mask;
	extern long *db_pcb_ptr;
	int	argcnt;

	asm("	movl	fp,_frameptr");
	mask = frameptr->mask;
/* 	for(;db_fp_ok(frameptr);frameptr=frameptr->fp) */
	{
		printx("frameptr = %x\n",frameptr);
		/* if(!KernelCanRead(frameptr,0x17)) continue; */
		printx("Raw stack dump:\n");
	
/* print out called from info */
	/* find address relative mode */
		call = (calls *)(frameptr->pc - 7);
		printx("sizeof(calls) = %x\n",sizeof(calls));
		printx("call->calls_op = %x\n", 0xff & call->calls_op);
		bcopy(call->offset, (char *)&offset,sizeof(offset));
		printx("call->offset = %x\n",offset);
		if(KernelCanRead((unsigned)call,sizeof(call)))
		{
			printx("%x(",frameptr->pc + offset);
		}
		else
		{
			printx("?");
		}

/* print out argument list */
	
		argcnt = (int)(call->mode & ~0xc0);
		for(index = 0; index < argcnt; index++)
		{
			int	*argval_ptr = frameptr->ap + index;
			printx("argval_ptr = %x\n",argval_ptr);
			printx("frameptr->ap = %x\n",frameptr->ap);
			if(KernelCanRead((unsigned)argval_ptr,0x04))
				printx(" 0x%x%c",*argval_ptr,index == (argcnt - 1)?' ':',');
			else
				printx("?,");
		}
		printx(") called from %x\n",call);
	
		if(frameptr->fp == frameptr) 
		{
			printx("end of stack dump\n");
			/* break; */
		}
		
	} /* end for */
	K_getchar();
	printx("now for the other one\n");
	StackDump();
}

ProcessorRec	*db_proc_rec;


db_fp_ok(fp) /* check to see if the frame pointer is OK */
int *fp;
{
	asm("	mfpr	$esp,_db_proc_rec");
	if(!KernelCanRead((unsigned)fp,0x14)) return 0; /* false */
	if(((char *)fp > db_proc_rec->md.istack && 
	   (char *)fp < &db_proc_rec->md.kstack[STACK_SIZE]) ||
	   (unsigned)fp < (unsigned)SYS_SEG_START)
		return 1; /* OK */
	else return 0; /* Blech */
}

		/* printx("   cond_handlr = %8x",frameptr->cond_handlr);
		printx("           psw = %8x",frameptr->psw);
		printx("          mask = %8x\n",frameptr->mask);
		printx("             s = %8x",frameptr->s);
		printx("           spa = %8x",frameptr->spa);
		printx("            ap = %8x\n",frameptr->ap);
		printx("            pc = %8x",frameptr->pc);
		if(mask & 0x1) printx("            r0 = %8x",frameptr->r0);
		else		   printx("                           ");
		if(mask & 0x2) printx("            r1 = %8x\n",frameptr->r1);
		else		   printx("                           ");
		if(mask & 0x4) printx("            r2 = %8x",frameptr->r2);
		else		   printx("                           ");
		if(mask & 0x8) printx("            r3 = %8x",frameptr->r3);
		else		   printx("                           ");
		if(mask & 0x10) printx("            r4 = %8x\n",frameptr->r4);
		else		   printx("                            ");
		if(mask & 0x20) printx("            r5 = %8x",frameptr->r5);
		else		   printx("                            ");
		if(mask & 0x40) printx("            r6 = %8x",frameptr->r6);
		else		   printx("                            ");
		if(mask & 0x80) printx("            r7 = %8x\n",frameptr->r7);
		else		   printx("                            ");
		if(mask & 0x100) printx("            r8 = %8x",frameptr->r8);
		else		   printx("                            ");
		if(mask & 0x200) printx("            r9 = %8x",frameptr->r9);
		else		   printx("                            ");
		if(mask & 0x400) printx("           r10 = %8x\n",frameptr->r10);
		else		   printx("                            ");
		if(mask & 0x800) printx("           r11 = %8x\n",frameptr->r11);
		else		   printx("                            ");
		printx("end stack dump (one frame)\n");
		*/

