/*
 * V Kernel - Copyright (c) 1981 by David Cheriton
 * (Transliterated from Zed and Verex Kernel)
 * Copyright (c) 1982 Stanford University, all rights reserved.
 *
 * Exception handling for Vaxen
 *
 * $Revision: 1.48.1.26 $
 * $Locker:  $
 * $State: Exp $
 */

unsigned saved_em_segment;

int	trap8debug	= 0;

#include <Venviron.h>
#include <Vexceptionprotocol.h>
#include <Vprocessprotocol.h>	/* EXCEPTION_REQUEST */
#include <Vgroupids.h>
#include <Vquerykernel.h>
#include "process.h"
#include <Vprocessor.h>

#include "config.h"
#include "externals.h"
#include "vm.h"
#include "memory.h"
#include "uvaxmemory.h"
#include "interrupt.h"
#include "asmdefs.h"
#include "processor.h"
#include "meminstance.h"
#include "deqnalocal.h"

#ifdef FIREFLY
#include "firefly.h"
#endif FIREFLY

extern unsigned NProcessors;
static int KStopCount = 0;



_BEGIN_EXTERN_C
       void MachineChk(), KernStackInval(), PwrFail(), ResPrivInstrn(),
       XFC(), OperandReserved(), AddrModeReserved(),
       HandleAccessCntlViol(), HandleXlationInval(),
       TracePending(), BreakPoint(), Compatibility(),
       Arithmetic(), HandleCHMK(), CHME(), CHMS(), CHMU(), SBI_SILO(),
       CorrMemRead(), SBI_Alert(), SBI_Fault(), BusTimeout(),
       Trap1(), Trap2(), Trap3(), Trap4(), Trap5(), Trap6(), Trap7(),
       Trap8(), Trap9(), TrapA(), TrapB(), TrapC(), TrapD(), TrapE(),
       TrapF(),
       IntervalTimer(), UndoneEMT(), DoneEMT(), RxConsStor(),
       TxConsStor(), RxConsole(), TxConsole(),
       UnknownTrap(), UnknownInterrupt();
_END_EXTERN_C

/* Forward */
void KabortQuit _TAKES(( Process *, ExceptionRequest *, char *));
void KabortHelp _TAKES(());
void KStop _TAKES(( char *, int, char *));
void KabortHelp _TAKES(());
int print_pc _TAKES(( unsigned char *));
void DumpProcState _TAKES((unsigned));

/* 
 * The usual assumptions about register allocation for register variables.
 * Assumes:     1. Declaration of  ProcessorRec *r11.
 * 		2. r11 is the only register used.
 * Side effects: leaves original r11 on the stack and ProcessorRec* in r11.
 */
#define StoreExceptionType(vecnum) 					\
   {									\
     asm("	movl	r11,-(sp)");					\
     AsmGetProcessorRecord(r11);					\
     r11->md.exceptionType = vecnum;					\
   }
/*
*  Definitions of routines to vector to on exceptions and interrupts.
*  exvecn means pop n parameters off the stack before doing a svpctx.
*/
#define exvec0(vecname,vecnum) 					\
asm("	.align	2");						\
asm("vecname:");						\
	ExceptionKLock();					\
	StoreExceptionType(vecnum); 				\
asm("	movl	(sp)+,r11");					\
asm("	jmp	callException");

#define exvec1(vecname,vecnum) 					\
asm("	.align	2");						\
asm("vecname:");						\
	ExceptionKLock();					\
	StoreExceptionType(vecnum); 				\
asm("	movl	4(sp), _PR_FRAME(r11)");				\
asm("	movl	(sp),r11");					\
asm("   addl2 	$8, sp");					\
asm("	jmp	callException");

#define exvec2(vecname,vecnum) 					\
asm("	.align	2");						\
asm("vecname:");						\
	ExceptionKLock();					\
	StoreExceptionType(vecnum); 				\
asm("	movq	4(sp), _PR_FRAME(r11)");				\
asm("	movl	(sp),r11");					\
asm("   addl2 	$12, sp");					\
asm("	jmp	callException");

#define exvec4(vecname,vecnum)					\
asm("	.align	2");						\
asm("vecname:");						\
	ExceptionKLock();					\
	StoreExceptionType(vecnum); 				\
asm("	movq	4(sp), _PR_FRAME(r11)");				\
asm("	movq	12(sp), _PR_FRAME+8(r11)");			\
asm("	movl	(sp),r11");					\
asm("   addl2 	$20, sp");					\
asm("	jmp	callException");

#define exvec10(vecname,vecnum)					\
asm("	.align	2");						\
asm("vecname:");						\
	ExceptionKLock();					\
	StoreExceptionType(vecnum); 				\
asm("	movq	4(sp), _PR_FRAME(r11)");				\
asm("	movq	12(sp), _PR_FRAME+8(r11)");			\
asm("	movq	20(sp), _PR_FRAME+16(r11)");			\
asm("	movq	28(sp), _PR_FRAME+24(r11)");			\
asm("	movq	36(sp), _PR_FRAME+32(r11)");			\
asm("	movl	(sp),r11");					\
asm("   addl2 	$44, sp");					\
asm("	jmp	callException");

extern int	bp_is_set;	/* kernel debugger code */

DummyExceptionHandler()
  {
    register ProcessorRec *r11;
    /* Message register traps */

   /*
    * Establish the routines for each exception to vector to.
    */
    exvec0(_UnknownTrap, 0);
    exvec4(_MachineChk,VecMachineChk);
    exvec0(_KernStackInval,VecKernStackInval);
    exvec0(_PwrFail,VecPwrFail);
    exvec0(_ResPrivInstrn,VecResPrivInstrn);
    exvec0(_XFC,VecXFC);
    exvec0(_OperandReserved,VecOperandReserved);
    exvec0(_AddrModeReserved,VecAddrModeReserved);
    /*  special handlers for AccessCntlViol & XlationInval, see below */
    exvec0(_TracePending,VecTracePending);
#if 0
	asm("	.align 2");
	asm("_TracePending:");
	ExceptionType = VecTracePending;
	asm("	jmp	callException");
/*	asm("	jmp	_db_tp_hndlr"); */
#endif 0
exvec0(_BreakPoint,VecBreakPoint);
#if 0
	asm("	.align 2");
	asm("_BreakPoint:");
	ExceptionType = VecBreakPoint;
/*	asm("	jmp callException"); */
	asm("	jmp _db_bp_hndlr");
#endif 0
    exvec1(_Compatibility,VecCompatibility);
    exvec1(_Arithmetic,VecArithmetic);
    /*  we have our own handler for CHMK, see below */ 
    exvec1(_CHME,VecCHME);	/* Since these stacks are invalid, these */
    exvec1(_CHMS,VecCHMS);	/* traps will generate Access Violations */
    exvec1(_CHMU,VecCHMU);
    exvec0(_SBI_SILO,VecSBI_SILO);
    exvec0(_CorrMemRead,VecCorrMemRead);
    exvec0(_SBI_Alert,VecSBI_Alert);
    exvec0(_SBI_Fault,VecSBI_Fault);
    exvec0(_BusTimeout,VecBusTimeout);
    exvec0(_Trap1,VecTrap1);
    exvec0(_Trap2,VecTrap2);
    exvec0(_Trap3,VecTrap3);
    exvec0(_Trap4,VecTrap4);
    exvec0(_Trap5,VecTrap5);
    exvec0(_Trap6,VecTrap6);
    exvec0(_Trap7,VecTrap7);
    exvec0(_Trap8,VecTrap8);
    exvec0(_Trap9,VecTrap9);
    exvec0(_TrapA,VecTrapA);
    exvec0(_TrapB,VecTrapB);
    exvec0(_TrapC,VecTrapC);
    exvec0(_TrapD,VecTrapD);
    exvec0(_TrapE,VecTrapE);
    exvec0(_TrapF,VecTrapF);
    exvec0(_IntervalTimer,VecIntervalTimer);
    exvec10(_UndoneEMT,VecUndoneEMT);
    exvec0(_DoneEMT,VecDoneEMT);
    exvec0(_RxConsStor,VecRxConsStor);
    exvec0(_TxConsStor,VecTxConsStor);
    exvec0(_RxConsole,VecRxConsole);
    exvec0(_TxConsole,VecTxConsole);
    exvec0(_UnknownInterrupt,VecInterrupt);

    /* the CHMK handler */
    asm("	.align	2");
    asm("_HandleCHMK:");
    disable;
    Kdisable;	
    KLock();
    /* 
     * If localPid field of active process = INVALID_PROCESS indicating that the
     * calling process has been destroyed, reschedule immediately.
     */


     asm("	movl	r1, -(sp)");
     AsmGetProcessorRecord(r1);
     asm("	movl	_PR_ACTIVE(r1),r1");
     asm("	cmpl	_LOCALPID(r1),$_INVALID_PROCESS");
     asm("	bneq	0f");
     asm("	jmp	ActivateReadyqHead");	
     asm("0:");
		StoreExceptionType(VecCHMK);
     asm("	movl	(sp)+, r11");		/* Used by StoreExceptionType */
     /* If we've got an emulator, jump to it */
     /* r0 points to the active process here */
     asm("	cmpl	_EMULATOR_SEGMENT(r1), 8(sp)");	/* was he outside the*/
     asm("	blequ	9f");	/* emulator? If no emltr, whole team is emltr*/

    asm("	.globl callEmulator; callEmulator:");
    asm("	movl	r0, -(sp)");		/* save r0 */

    /* Copy the exception frame to the user's area. Replace the epc on
     * the kernel stack with the emulator start address, and rei to it.
     */
    asm("	movl	_EMULATOR_DATA(r1), r0");
    asm("	movq	12(sp), -(r0)");	/* copy psl,pc to emul stack */
    asm("	movl	8(sp), -(r0)");		/* copy opcode to emul stack */
    asm("	movl	$_VecCHMK, -(r0)");	/* store exception type */
    asm("	mfpr    $usp, -(r0)");
    asm("	moval	-8(r0), r0");		/* space for mask, ap */
    asm("	movq	r2, -(r0)");		/* r2, r3 */
    asm("	movq	(sp)+, -(r0)");		/* r0, r1 */
    asm("	mtpr	r0, $usp");		/* update user stack */

/*    asm("	clrl	_in_kernel");		/* fault not allowed */
    /* we 'return' to the emulator, who will jump back to the instruction
     * after the trap when done. */
    asm("	moval	8(sp), sp");		/* pop opcode, pc */
    asm("	movl	_EMULATOR_SEGMENT(r1), -(sp)");

    KUnlock();
    asm("	rei");

    asm("9: ");
    AsmGetProcessorRecord(r1);
    asm("	movl	4(sp), _PR_FRAME(r1)");		/* code */
    asm(" 	movl	(sp)+,r1");
    asm("	casel	(sp)+, $7, $0xB-7");
    asm("SwitchBase:");
    asm("	.word	Trap7-SwitchBase");
    asm("	.word	Trap8-SwitchBase");
    asm("	.word	callException-SwitchBase");
    asm("	.word	callException-SwitchBase");
    asm("	.word	TrapB-SwitchBase");

    asm("	jmp	callException");
  
    /* jump to the message register trap */
    asm("TrapB:	jmp	Asm_Invoke_trap");

    /* This is for setting hard breakpoints in programs we can't debug */
    asm("Trap7: halt");
asm("movq	r0, -(sp)");
AsmGetProcessorRecord(r0);
asm("movl	_PR_ACTIVE(r0), -(sp)");
Kabort("CMK $7");
asm("tstl	(sp)+");
asm("movq	(sp)+, r0");
KUnlock();
    asm("	rei");

    /* Another debugging trap; toggles trap8debug, which might turn on
     * some debugging output.
     */
    asm("Trap8: xorl2 $1, _trap8debug");
    asm("movl   _trap8debug, -(sp)");
printx("   debug %x ");
    asm("tstl	(sp)+");
KUnlock();
    asm("	rei");
  }

void
dummyHandleXlationInval()
  {
    /*
     * Special junk which mainly implements an "accessed" bit.  Can we do
     *   without it?  (Certainly, we aren't really doing anything with
     *   accessed bits at present, but then the page scavenger isn't written).
     */

    register PageTableEntry	*pte;	/* same as r11 */
    register int		address;/* same as r10 */
    register unsigned		tbllen; /* same as r9  */
    register ProcessorRec *r8;

    /* handler for XlationInval: */
    asm("	.align	2");
    asm("_HandleXlationInval:");
    disable;		/* do we really need to? */
    ExceptionKLock();
    /* 
     * If localPid field of active process = INVALID_PROCESS and exception
     * did not occur in kernel mode, reschedule immediately. An exception in
     * kernel mode is handled using the existing mechanism.
     */

     ;asm("	movl	r0, -(sp)");		
     AsmGetProcessorRecord(r0);
     asm("	movl	_PR_ACTIVE(r0),r0");
     asm("	cmpl	_LOCALPID(r0),$_INVALID_PROCESS");
     asm("	bneq	0f");				
     asm("	bitl	$_PSL_CURMOD,16(sp)");
     asm("      beql	0f");
     asm("	jmp	ActivateReadyqHead");	
     asm("0:    ");
     asm("      movl	(sp)+,r0");

     asm("	movl	r8, -(sp)");  
     AsmGetProcessorRecord(r8);
     r8->md.exceptionType = VecXlationInval;					
     asm("	movl	(sp)+,r8"); 

     asm("	jmp commonMemoryFault");
  }

void
dummyAccessCntlViol()
  {
    register int r11;
    register int r10;
    register ProcessorRec *r9;

    /* On the stack:
     *		psl at time of fault.
     *		pc of faulting instruction
     *		virtual address in faulting page
     *	sp->	0|modify intent:1|PTE reference:1|length viol:1
     */
    asm("	.align	2");
    asm("_HandleAccessCntlViol:");
    disable;			/* Again, is this really necessary? */
    ExceptionKLock();

    /* 
     * If localPid field of active process = INVALID_PROCESS and exception
     * did not occur in kernel mode, reschedule immediately. An exception in
     * kernel mode is handled using the existing mechanism.
     */
     asm("	movl	r0, -(sp)");
     AsmGetProcessorRecord(r0);
     asm("	movl	_PR_ACTIVE(r0),r0");
     asm("	cmpl	_LOCALPID(r0),$_INVALID_PROCESS");
     asm("	bneq	0f");
     asm("	bitl	$_PSL_CURMOD,16(sp)");
     asm("      beql	0f");			/* 0 is kernel */
     asm("	jmp	ActivateReadyqHead");
     asm("0:    movl	(sp)+,r0");

    /*
     * The access may have been valid and we just didn't have the right value
     *   in the P0 length register.  Determine whether this is the case and,
     *   if so, fix P0 and resume.
     */
asm("	bitb	$0x01,		(sp)");	/* Is it a length violation? */
asm("	beql	4f"		     ); /*   No.		     */
asm("	movq	r10,		-(sp)");/* Yes; so check p0lr.	     */

AsmGetProcessorRecord(r11);
asm("	movl	_PR_ACTIVE(r11),r11");	/* r11 = active		    */

asm("	movl	_TEAM(r11),	r11");	/*	->team		    */
asm("	movl	_TD_P0LEN(r11),	r11");	/*	->team_space.p0len; */
asm("	mfpr	$p0lr,		r10");
asm("	cmpl	r10,		r11");
asm("	blss	0f");

/*
 * The following code covers a race condition which is possible but unlikely.
 * The scenario is as follows:
 *
 * 1. The size of a team T is extended. Processor j runs a member of T which
 *    has an out of date p0lr.
 *
 * 2. Processor j makes a reference which is valid but causes a length
 *    violation exception because its p0lr is not up to date.
 *
 * 3. Before the length violation is processed, processor j handles an interrupt
 *    which includes a SetAddressableProcess. On the Firefly the most likely 
 *    situation is that the primary processor is waiting for the kernel lock and
 *    a secondary processor sends it a device service request which involves
 *    a change of addressable process. SetAddressableProcess updates the p0lr
 *    to reflect the up to date size of the address space.
 * 
 * 4. The length violation is handled but the p0lr has already been corrected. 
 *    If we do not check the virtual address which caused the fault against
 *    the correct value of the p0lr, we think we have a genuine length 
 *    violation.
 *
 */

asm("	movl	12(sp),	r11");	/* r11 = faulting virtual address */
asm("	ashl	$-9,r11,r11");	/* shift right by 9 bits to get page number */
asm("	cmpl	r11,		r10"); /* compare with p0lr */
asm("	bgequ	3f");
asm("	mfpr	$p0lr,		r11");
/* Don't bother branching over the next instruction */


asm("0:	");
asm("	mtpr	r11,		$p0lr");/* p0lr was too small */
asm("	movq	(sp)+,		r10");
asm("	addl2	$8,		sp");	/* remove parameters from stack */

#ifdef FIREFLY

/* If exception occurred in user mode, release the lock */
asm("	bitl	$_PSL_CURMOD,4(sp)");  /* Mode was kernel (==0) ? */
asm("   bneq	0f");
asm("	rei");
asm("0:	");
KUnlock();
asm("	rei");
#else !FIREFLY
asm("	rei");
#endif FIREFLY
asm("3:	movq	(sp)+,		r10");
asm("4:"			    );

    asm("commonMemoryFault:");
    asm("	movl	r0,-(sp)");
    AsmGetProcessorRecord(r0);

    asm("	movl	r9,-(sp)");
    AsmGetProcessorRecord(r9);	
    r9->md.exceptionType = VecAccessCntlViol;
    asm("	movl   (sp)+,r9");

    asm("	movq 	4(sp), _PR_FRAME(r0)");
#ifdef VM
    asm("	movq 12(sp), _PR_FRAME+8(r0)");		/* DEBUG */
#endif VM
    asm("	movl	(sp),r0");
    asm("	addl2 	$12, sp");
#ifdef VM
/*
 * See if "access control" or "translation invalid" exception refers to
 * a region which is bound.  If so, handlepagefault will return success
 * so we return immediately.  If region not bound, treat as exception.
 *
 * This is first because we want to handle page faults as quickly as possible.
 */


    asm("	bitl	$_PSL_CURMOD, 4(sp)");	/* Mode was kernel (==0) ? */
    asm("	jeql	kernelException");
/*
 * Exception in user mode.  Save state, handle, and reschedule
 */
    SaveProcessContext();

    asm("1:");
    AsmGetProcessorRecord(r11);
    asm("	pushl	_PR_FRAME+8(r11)");	/* DEBUG. PC of faulting address */
    asm("	clrl	-(sp)");		/* 0 means user, not kernel */
    asm("	extzv	$2, $1, _PR_FRAME(r11), -(sp)");/* 0 if read, 1 if write    */
    asm("	pushl	_PR_FRAME+4(r11)");		/* Fault virtual address    */
    AsmGetProcessorRecord(r11);
    asm("	pushl	_PR_ACTIVE(r11)");
    asm("	calls	$5, _HandlePageFault");	/* frame = HandlePageFault */
    asm("	tstl	r0");			/* if frame != NULL */
    asm("	bneq	1f");			/*	AddReady and return */

    AsmGetProcessorRecord(r0);
    asm("	movl	_PR_ACTIVE(r0),r0");
    asm("	cmpb	_STATE(r0),$_READY");
    asm("	bneq	2f");			/* READY only if error */
    asm("	calls	$0, _HandleException");
    asm("	jbr	2f");	/* Frame is coming in.  We're on another queue,
				 * waiting, so activate whoever is on the
				 * Readyq.
				 */
    asm("1:	pushl	_PR_ACTIVE(r11)");	/* Frame was in-core */
    asm("	calls	$1, _Addready");	/* Restart us, with a chance
						 * to reschedule. */
    asm("2:	jmp	ActivateReadyqHead");
/*
 * Exception in kernel mode.  Should be a page fault on user data segment.
 * If not, HandleException will call Kabort.  After handling, then return to
 * caller of subroutine which caused exception by hacking the return pc.  The
 * process finishup routine will return retry flags to the user.
 */
    asm("kernelException:");
    asm("	pushr	$0x003f");		/* save R0-R5 */
    AsmGetProcessorRecord(r0);
    asm("	pushl	_PR_FRAME+8(r0)");	/* DEBUG. PC of faulting address */
    asm("	pushl	$1");			/* 1 means kernel */
    asm("	extzv	$2, $1, _PR_FRAME(r0), -(sp)");/* modify intent bit */
    asm("	pushl	_PR_FRAME+4(r0)");		/* vaddr */
    asm("	pushl	_PR_ACTIVE(r0)");	/* pd */
    asm("	calls	$5, _HandlePageFault");
    asm("	tstl	r0");
#ifdef RIGHT
    asm("	bneq	2f");			/* frame was in-core */
#else
    asm("	bneq	1f");			/* frame was in-core */
#endif
    AsmGetProcessorRecord(r0);
    asm("	movl	_PR_ACTIVE(r0),r0");
    asm("	cmpb	_STATE(r0),$_READY");	/* READY only if error */
    asm("	beql	3f");			/* A genuine memory screw-up */
/*
 * Otherwise, we're waiting for something to finish, so...
 */
/*
 * Return to the caller of the routine that got the exception.  Note
 * that this forces CheckSegWhatever to be a macro, and we return to
 * whoever called KSend.
 */
    asm("0:	popr	$0x003f");		/* restore R0-R5 */
    asm("	moval	unwindException, (sp)");
    asm("	rei");
    asm("unwindException:");
    asm("	ret");

#ifndef RIGHT
    asm("1:");
    AsmGetProcessorRecord(r0);
    asm("	pushl	_PR_ACTIVE(r0)");
    asm("	calls	$1, _Addready");
    asm("	jbr	0b");
#endif

#ifdef RIGHT
/*
 * If the frame was in-core, HandlePageFault returned a pointer to it.
 * Just restore the registers and do a rei.
 *
 * For some reason this hangs; it looks like the process isn't getting
 * back on the ready queue.  So for now, even if the frame can just be
 * re-attached, return RETRY_PAGEIN.
 */
    asm("2:	popr	$0x003f");		/* restore R0-R5 */
    asm("	rei");
#endif
/*
 * If there was an error...
 */
    asm("3:	popr	$0x003f");		/* restore R0-R5 */
#endif VM
    asm("	jmp	callException");	/* default in non-VM */
  }

void
dummyCallException()
    /*
     * Asm routine to call the HandleException() function
     *  Registers are saved and the stack is cleaned up
     *  so that the process state record will
     *  be accurate as of the time of the exception.
     *
     * Note that if the trap was caused by a Machine check, Memory Management,
     *  CHMK, CHMU, CHMS, CHME, CorrMemRead (not mVAX), BusTimeout (not mVAX),
     *  or EMT, we need to pop the parameters off the stack
     *  and into the variable Frame before the jump to callException; this
     * is done by the exvecn macros.
     *
     *
     */
  {
    register ProcessorRec *r11;
    register unsigned psl;

    asm("	.globl callException");
    asm("callException:");
    disable;
    SaveProcessContext();

   /* 
    * If localPid field of active process = INVALID_PROCESS and exception
    * did not occur in kernel mode, reschedule immediately. An exception in
    * kernel mode is handled using the existing mechanism.
    */

    asm("1:");
    AsmGetProcessorRecord(r11);

    psl = (unsigned) r11->active->status;
    if ( r11->active->localPid == INVALID_PROCESS
	&& (psl & PSL_CURMOD) != PSL_CURKERNEL )
      {
        ;asm("	jmp	ActivateReadyqHead");
      }

    ;asm("	calls	$0, _HandleException");
    asm("	jmp	ActivateReadyqHead");
  }


void
InitException()

/*
 * Function to initialize exception vectors and kernel traps
 *
 * The VAX doesn't put the vector number on the stack, so we have a
 *  separate routine for each exception to vector to, which loads the
 *  vector number into a global variable and jumps to the common routine
 */


  {
    register int r11;
    register ProcessorRec *r10;

    for (r11 = 0; r11 < NumExceptions; r11++)
        setexvec(UnknownTrap, r11);

    for (r11 = VecIntStart; r11 < VecInterrupt; r11++)
        setexvec(UnknownInterrupt, r11);

    setexvec(MachineChk, VecMachineChk);
    setexvec(KernStackInval, VecKernStackInval);
    setexvec(PwrFail, VecPwrFail);
    setexvec(ResPrivInstrn, VecResPrivInstrn);
    setexvec(XFC, VecXFC);
    setexvec(OperandReserved, VecOperandReserved);
    setexvec(AddrModeReserved, VecAddrModeReserved);
    setexvec(HandleAccessCntlViol, VecAccessCntlViol);
    setexvec(HandleXlationInval, VecXlationInval);
    setexvec(TracePending, VecTracePending);
    setexvec(BreakPoint, VecBreakPoint);
    setexvec(Compatibility, VecCompatibility);
    setexvec(Arithmetic, VecArithmetic);
    setexvec(HandleCHMK, VecCHMK);
    setexvec(CHME, VecCHME);
    setexvec(CHMS, VecCHMS);
    setexvec(CHMU, VecCHMU);
    setexvec(SBI_SILO, VecSBI_SILO);
    setexvec(CorrMemRead, VecCorrMemRead);
    setexvec(SBI_Alert, VecSBI_Alert);
    setexvec(SBI_Fault, VecSBI_Fault);
    setexvec(BusTimeout, VecBusTimeout);
    setexvec(Trap1, VecTrap1);
    setexvec(Trap2, VecTrap2);
    setexvec(Trap3, VecTrap3);
    setexvec(Trap4, VecTrap4);
    setexvec(Trap5, VecTrap5);
    setexvec(Trap6, VecTrap6);
    setexvec(Trap7, VecTrap7);
    setexvec(Trap8, VecTrap8);
    setexvec(Trap9, VecTrap9);
    setexvec(TrapA, VecTrapA);
    setexvec(TrapB, VecTrapB);
    setexvec(TrapC, VecTrapC);
    setexvec(TrapD, VecTrapD);
    setexvec(TrapE, VecTrapE);
    setexvec(TrapF, VecTrapF);
    setexvec(IntervalTimer, VecIntervalTimer);
    setexvec(UndoneEMT, VecUndoneEMT);
    setexvec(DoneEMT, VecDoneEMT);
    setexvec(RxConsStor, VecRxConsStor);
    setexvec(TxConsStor, VecTxConsStor);
    setexvec(RxConsole, VecRxConsole);
    setexvec(TxConsole, VecTxConsole);
  }

static int HandleExceptionCount = 0;	

void
HandleException()
/*
 * Kernel exception handler.  Packages up the information
 *  about the exception and causes the offending process to send
 *  a message off to the exception handler process, if one is
 *  registered.  Otherwise, the process sends the message to itself.
 */

  {
    register Process *active;
    register ProcessorRec *r10;
    register ExceptionRequest *req;

    short save_ExceptionType;
    ExceptionStackFrame save_Frame;
    ExceptionStackFrame *frame;
    

    /*
     * We don't actually use these for anything.  Since they're globals which
     *   will be overwritten by the next exception, we save them before we do
     *   do anything which might provoke another exception.  If things go badly
     *   wrong and HandleException() or the things it calls provoke another
     *   exception, then at least this info is preserved somewhere on the
     *   stack where we can look at it.
     */
    AsmGetProcessorRecord(r10);
    save_ExceptionType = r10->md.exceptionType;
    save_Frame = r10->md.frame;
    frame = &r10->md.frame;

    switch (HandleExceptionCount++)
      {
	case 0:
	    break;
	case 1:
	    printx(
	    "** Detected recursion in HandleException routine - Quit **\n");
	    /* fall into ... */
	case 2:
	    KabortQuit(NULL, NULL, NULL);
	case 3:
	    asm("halt");
	default:
	    while (1) ;	/* Can't even do a VAX HALT properly; just hang. */
      }

    AsmGetProcessorRecord(r10);
    active = r10->active;
    req = (ExceptionRequest *) &(active->msg);

    /* Build msg to send to exception handler */
    req->requestcode = EXCEPTION_REQUEST;
    req->type = r10->md.exceptionType;
    req->errpc = (unsigned)active->PC;
    req->status =(unsigned)active->status;
    req->instruction = req->accaddr = req->code = req->subtype = 0;

    switch (req->type)
      {
	case VecMachineChk:
	  req->subtype = (unsigned short )frame->MCheck.type;
	  req->accaddr = frame->MCheck.par1;
	  req->code    = MachineCheckMagic();
	  break;

	case VecAccessCntlViol:
	case VecXlationInval:
	  req->accaddr = frame->MM.virtaddr;
	  req->code = frame->MM.acctype;
	  break;

	case VecCompatibility:
	case VecArithmetic:
	case VecCHMK:
	case VecCHME:
	case VecCHMS:
	case VecCHMU:
	  req->subtype = frame->one_param.type;
	  break;

	case VecUndoneEMT:
	  req->instruction = frame->EMT.ir;
	  req->errpc = frame->EMT.oldpc;
	  break;
      }

    if ( ( req->status & PSL_CURMOD ) == PSL_CURKERNEL )
      /* If in kernel */
      {
	KStop(__FILE__, __LINE__, "Exception in kernel" );
      }

    SendException(active);

    HandleExceptionCount--;
  }

#if defined(VM) || 1
void
FakeMemoryException(pd, vaddr, writep)
   Process	*pd;
   unsigned vaddr;
   unsigned writep;
    /*
     * Take pd, and pretend that it has gotten an access control violation
     * or something.  This is used by the virtual memory stuff if something
     * goes wrong in the process of paging something in.
     */
  {
    ExceptionRequest *req = (ExceptionRequest *) &(pd->msg);

   
    /* Build msg to send to exception handler */
    req->requestcode = EXCEPTION_REQUEST;
    req->type = VecAccessCntlViol;
    req->errpc = (unsigned)pd->PC;
    req->status = (unsigned)pd->status;
    req->instruction = 0;    
    req->accaddr = vaddr;
    req->code = writep ? 0x4 : 0;
    req->subtype = 0;
   
    SendException(pd);
  }
#endif VM

static char	*Uvax1MachChk[] = {
			"Memory Controller died accessing 0x%x",
			"Read, Parity, or ECC error at 0x%x",
			"Nonexistent Memory at 0x%x",
			"Unaligned I/O Access at 0x%x",
			"Can't read page table at 0x%x",
			"Can't write page table at 0x%x",
			"GAK! Control Store parity error",
			"Tora Tora Tora, Invalid Micromachine state",
			"Can't read interrupt vector from Q22 bus",
			"Unexpected stack write error at Vaddr 0x%x"
			};
#define 	 MinUvax1MachChk 0
#define		 MaxUvax1MachChk (sizeof(Uvax1MachChk) / sizeof(char *))

static char	*Uvax2MachChk[] = {
			"Impossible microcode state (FSD)",
			"Impossible microcode state (SSD)",
			"Undefined FPU error code 0",
			"Undefined FPU error code 7",
			"Undefined memory management status (TB miss)",
			"Undefined memory management status (M = 0)",
			"Process PTE address in P0 space",
			"Process PTE address in P1 space",
			"Undefined interrupt ID code"
			};
#define		 MinUvax2MachChk 1
#define		 MaxUvax2MachChk (sizeof(Uvax2MachChk) / sizeof(char *))

static char	*BogusMachChk =
			" code = 0x%x (!?), first param = 0x%x";

static char	*ArithError[] = {
			"Integer Overflow (trap)",
			"Integer Divide by Zero (trap)",
			"Floating Overflow (trap)", 
			"Floating or Decimal String Divide by Zero (trap)", 
			"Floating Underflow (trap)", 
			"Decimal String Overflow (trap)", 
			"Subscript Range (trap)",
			"Floating Overflow (fault)",
			"Floating Divide by Zero (fault)",
			"Floating Underflow (fault)"
			};
#define		 MinArithError 1
#define		 MaxArithError (sizeof(ArithError) / sizeof(char *))

void
KPrintException(req, pid)
    register ExceptionRequest *req;
    ProcessId pid;
  {
    switch( req->type )
      {

        case VecMachineChk:
	  printx(" Machine Check: ");
	  {
	    switch (MachineConfig.processor)
	      {
		case PROC_UVAX1:
		  if ( req->subtype >= MinUvax1MachChk &&
		       req->subtype <= MaxUvax1MachChk )
		    {
		      printx(Uvax1MachChk[ req->subtype - MinUvax1MachChk ],
			     req->accaddr);
		    }
		  else
		    {
		      printx(BogusMachChk, req->subtype, req->accaddr);
		    }
		  break;

		case PROC_UVAX2:
		  if ( req->subtype >= MinUvax2MachChk &&
		       req->subtype <= MaxUvax2MachChk )
		    {
		      printx("%s, VAP = 0x%x", 
				Uvax2MachChk[ req->subtype - MinUvax2MachChk ],
				req->accaddr);
		    }
		  else if ( req->subtype >= 0x80 && req->subtype <= 0x83 )
		    {
		      printx("%s bus error, %s address = 0x%x",
			       (req->subtype & 2) ? "write" : "read",
			       (req->subtype & 1) ? "physical" : "virtual",
				req->accaddr );
		    }
		  else
		    {
		      printx(BogusMachChk, req->subtype, req->accaddr);
		    }
		  break;

	        default:
		  printx("code = 0x%x, first param = 0x%x",
			    req->subtype, req->accaddr);
		  break;
	      }
	  }
	  break;

        case VecKernStackInval:
	  printx(" Kernel Stack Invalid");
	  break;

        case VecPwrFail:
	  printx(" Power Fail");
	  break;

        case VecResPrivInstrn:
	  printx(" Reserved/Privileged Instruction");
	  break;

        case VecXFC:
	  printx(" Extended Function Call");
	  break;

        case VecOperandReserved:
	  printx(" Reserved Operand");
	  break;

        case VecAddrModeReserved:
	  printx(" Reserved Addressing Mode");
	  break;

        case VecAccessCntlViol:
        case VecXlationInval:
          if (req->type == VecAccessCntlViol)
	    printx(" Access Control Violation");
	  else
	    printx(" Translation Not Valid");
	  printx(" at Vaddr 0x%x, mode %s", req->accaddr,
		(req->code & MM_Write) ? "write" : "read");
	  if (req->code & MM_Length)
		printx(", length violation");
	  if (req->code & MM_ProcessPT)
		printx(", while accessing Process Page Table");
	  break;

        case VecTracePending:
	  printx(" Trace Pending");
	  break;
        case VecBreakPoint:
	  printx(" Breakpoint Instruction");
	  break;

        case VecCompatibility:
	  printx(" Compatibility mode fault number 0x%x", req->subtype);
	  break;

        case VecArithmetic:
	  if ( req->subtype >= MinArithError &&
	       req->subtype <= MaxArithError )
	    {
	      printx("%s", ArithError[ req->subtype - MinArithError ]);
	    }
	  else
	    {
	      printx("Arithmetic error, code = 0x%x (!?)", req->subtype);
	    }
	  break;

        case VecCHMK:
	  printx(" CHMK 0x%x Fault", req->subtype);
	  break;

        case VecCHME:
	  printx(" CHME 0x%x Fault", req->subtype);
	  break;

        case VecCHMS:
	  printx(" CHMS 0x%x Fault", req->subtype);
	  break;

        case VecCHMU:
	  printx(" CHMU 0x%x Fault", req->subtype);
	  break;

        case VecSBI_SILO:
	  printx(" SBI SILO Fault");
	  break;

        case VecCorrMemRead:
	  printx(" Corrected Memory Read Fault");
	  break;

        case VecSBI_Alert:
	  printx(" SBI Alert");
	  break;

        case VecSBI_Fault:
	  printx(" SBI Fault");
	  break;

        case VecBusTimeout:
	  printx(" Memory Write Timeout");
	  break;

        case VecTrap1: case VecTrap2: case VecTrap3: case VecTrap4:
        case VecTrap5: case VecTrap6: case VecTrap7: case VecTrap8:
        case VecTrap9: case VecTrapA: case VecTrapB: case VecTrapC:
        case VecTrapD: case VecTrapE: case VecTrapF:
	  printx(" Unexpected level %d AST", req->type - VecTrap1 + 1);
	  break;

        case VecIntervalTimer:
	  printx(" Timer Interrupt");
	  break;

        case VecUndoneEMT:
	  printx(" Undone EMT");
	  break;

        case VecDoneEMT:
	  printx(" Done EMT");
	  break;

        case VecRxConsStor:
	  printx(" Console Storage Rx");
	  break;

        case VecTxConsStor:
	  printx(" Console Storage Tx");
	  break;

        case VecRxConsole:
	  printx(" Console Rx Interrupt");
	  break;

        case VecTxConsole:
	  printx(" Console Tx Interrupt");
	  break;

        case VecInterrupt: 
	  printx( " Unknown interrupt" );
	  break;

        default: 
	  printx( " Unknown exception(0x%x)", req->type);
Kabort("and die");
	  break;
      }

    printx( " in process %x\r\n",pid );
    if( req->instruction != 0 ) 
        printx( "Instruction: %x  ", req->instruction );
    printx( "Program counter: %08x  Status register: %08x\r\n",
		req->errpc, req->status );
  }

void
KNonFatal( pd, req )
    register Process *pd;
    register ExceptionRequest *req;

  {
    register ProcessorRec *r9;
	    
    printx("%s %s\n", versionstr, versiondstr);
    if ((req->status & PSL_CURMOD) == PSL_CURKERNEL) {

	StackDump();
        AsmGetProcessorRecord(r9);
	printx( " Last kernel trap invoked from address %x\r\n", 
		r9->active->PC);

    }
    KPrintException(req, pd->pid);
    
#ifdef NOTDEF
    {
      unsigned		stackSize;

      if (pd->perProcess != NULL)
	{
	  /* Check for user stack overflow */
	  stackSize = ((PerProcessArea *) pd->perProcess)->stackSize;

	  if ((unsigned)pd->userStackPtr <=
	  			(unsigned)pd->perProcess ||
	      (unsigned) pd->userStackPtr >
	      			(unsigned) pd->perProcess + stackSize)
	      printx( " Probable stack overflow\r\n");
	}
    }
#endif NOTDEF
  }



/*
 * Primitive stack dump package, will trace back into user space also.
 */
void
StackDump()
  {
    unsigned	*Fp;
    unsigned	*Ap;
    unsigned	Pc;
    unsigned	numArgs;
    int		offset;
    register int r11;
    register ProcessorRec *r10;
    Process	*savePd;


#define	ReadablePointer(p) \
    (( ( (char *)(p) > r10->md.istack && \
             (char *)(p) < &r10->md.kstack[STACK_SIZE] ) ||	\
	      (unsigned)(p) < (unsigned)SYS_SEG_START			\
	    ) && KernelCanRead((unsigned)(p), 0x14))
    /*
     * If we trace down into user (P0/P1) space, then we have to ensure that the
     * addresses we see on the stack are in the currently addressable team. If 
     * something in the kernel did a SetAddressableProcess(), this is probably 
     * false, so we  SetAddressableProcess((per-processor) active->team).  Will
     * this always get us the right address space?
     * We must restore the addressable team when we exit.
     */

    AsmGetProcessorRecord(r10);
    savePd = GetAddressableProcess();
    SetAddressableProcess(r10->active);

    printx("StackDump:\n");
    asm("	movl	ap, r11");
    Ap = (unsigned *)r11;
    asm("	movl	fp, r11");
    Fp = (unsigned *)r11;

    /*
     * We make the assumption here that the two stacks are allocated
     * sequentially.
     */
    if (! ReadablePointer(Fp))
      {
	printx("Invalid frame pointer (0x%x).\n", Fp);
	goto cleanup;
      }

    while ( ReadablePointer(Fp) )
      {
	Pc = Fp[4];
	offset = print_pc((unsigned char *)Pc);
	printx("(");
	if (KernelCanRead((unsigned)Ap,0x4) && KernelCanRead((unsigned)&Ap[1],4*Ap[0]))
	  {
	    for (numArgs = 1; numArgs <= Ap[0] && numArgs <= 10; numArgs++)
		printx("0x%x%s", Ap[numArgs], 
			(numArgs < Ap[0] && numArgs < 10) ? ", " : "" );
	    if (Ap[0] > 10)
		printx("..(0x%x args altogether)..", Ap[0]);
	  }
	else
	    printx(" Invalid argument pointer (0x%x) ", Ap);

	printx(") Called from 0x%x%s\n", Pc+offset, 
			(offset >= 0) ? "-?" : "" );
	if ((Pc < (unsigned)SYS_SEG_START) && (Pc > TEAM_LIMIT+P0_SEG_START))
	  {
	    printx("That last program counter looks bogus\n");
	    goto cleanup;
	  }
	Ap = (unsigned *)Fp[2];
	if ((unsigned)Fp == Fp[3])
	  {
	    printx("Next stack frame at same address (0x%x) - pretty bogus\n",
			Fp);
	    goto cleanup;
	  }
	Fp = (unsigned *)Fp[3];
      }
  cleanup:
    SetAddressableProcess(savePd);
  }


int
print_pc(Pc)
    unsigned char *Pc;
{
    int offset;     /* Offset to subroutine call instruction from pc */

    /*
     * This assumes the standard calling sequence generated by
     * the C compiler: a calls instruction with a literal argument
     * count and longword relative addressing.  That means the opcode
     * is at pc-7, and argument count at pc-6, the address mode at pc-5,
     * and the displacement at pc-4 through pc-1.
     *
     * If pc-7 does not contain the opcode for calls or if pc-6
     * does not specify literal mode or if pc-5  does not
     * specify longword displacement off the pc, then we
     * don't really know what address was called.  This routine
     * could be modified to look for other modes if necessary.
     *
     * We assume that Pc is a valid address in the team space.
     */

    offset = 0;     /* In case we don't know adr of calling instruction */
    if (KernelCanRead((unsigned)(Pc-7),7) /* bomb-proofing */ &&
	    (Pc[-7] & 0xFF) == 0xFB /* calls */ &&
	    (Pc[-6] & 0xC0) == 0    /* Literal mode */ &&
	    (Pc[-5] & 0xFF) == 0xEF /* Longword relative mode */)
    {
	printx("%x", Pc + *(long *)(&Pc[-4]));
	offset = -7;    /* calls instruction is at pc-7 */
    }
    else
    {
	printx("?");    /* Don't know what address was called */
    }
    return offset;
}

int KabortReturn;

void
KabortMessage()
  {
    unsigned i;

#ifdef FIREFLY
    PrintHaltMessages();
    for ( i=0; i < NProcessors; i++)
      {
        if ( KErrorInfo[i].errstring != NULL)
          {
            printx("  Kernel abort: %s\n", KErrorInfo[i].errstring);
            return;
          }
      }
#endif FIREFLY
  }

void
KabortVersion()
  {
    printx("  %s %s\n", versionstr, versiondstr);
  }

void
KabortStackDump(pno)
  unsigned pno;
  {
    StackDump();
  }

void
KabortProcState(pno)
  unsigned pno;
  {
    DumpProcState(pno);
  }

#ifdef VM
void
KabortDumpBRs(pno)
  unsigned pno;
  {
    Process *pd;
    Team *td;

    pd = ProcessorArray[pno].active;
    td = pd->team;

    printx("Processor %d: (active process state from process descriptor, not current registers)\n", pno);
    printx("localPid: %08x    ", pd->localPid);
    printx("alienPid: %08x\n", pd->alienPid);
    printx("RealBRs:");
    DumpBRs(td->brs,1);
    printx("\nDCBRs:");
    DumpBRs((BoundRegion *)td->dcbrs,1);
    printx("\n");
  }
#endif VM

void
KabortExceptionPrint()
  {
    unsigned i;
    ExceptionRequest *req;

    for ( i=0; i < NProcessors; i++)
      {
        req = (ExceptionRequest *) &(ProcessorArray[i].active->msg);
        if ( req->requestcode == EXCEPTION_REQUEST &&  
             ( req->status & PSL_CURMOD) == PSL_CURKERNEL )
          {
            printx("Processor %d exception:  ");
	    KPrintException(req, ProcessorArray[i].active->pid);
          }
      }
    printx("  can't - this kernel abort wasn't reporting an exception\n");
  }

void
KabortQuit(pd, req, str)
    Process	     *pd;
    ExceptionRequest *req;
    char	     *str;
  {
    asm("halt");/* Works on a MicroVAX II; what about other models?    */
		/* If someone decides to continue after the halt, this */
		/* will probably do the right thing.		       */
  }

void
KabortDebugger()
  {
    printx("Debugger not yet supported\n");
  }

struct KabC {
    char name;
    PV func;
    char *help;
  } KabortCmds[] = {
#ifdef VM
  { 'b', (PV)KabortDumpBRs,		"Dump Bound Region Descriptors"		    },
#endif VM
  { 'd', (PV)KabortDebugger,	"Call Kernel Debugger" 			    },
  { 'e', (PV)KabortExceptionPrint,	"Exception (if this was an exception)"	    },
  { 'm', (PV)KabortMessage,		"Redisplay the Kabort/halt  Message"	    },
  { 'p', (PV)KabortProcState,	"Process state, optional pno argument" 	    },
  { 'q', (PV)KabortQuit,		"Quit - do HALT, drop into MicroVAX monitor"},
  { 's', (PV)KabortStackDump,	"Stack dump, optional pno argument"         },
  { 'v', (PV)KabortVersion,		"Kernel Version, date"			    },
  { 'x', (PV)KabortDeqna,		"DEQNA driver status (not very mnemonic)"   },
  { '?', (PV)KabortHelp,		"To get this help message"   		    },
  {  0 , NULL,			NULL					    }
  };

void
KabortHelp()
  {
    struct KabC *p;
    for (p=KabortCmds; p->func != NULL; p++)
      printx("  %c : %s\n", p->name, p->help);
    printx("\nOptional arguments default to processor 0\n");
  }

void
PrimaryAutopsy()
  {
    if (FramebufferEnableVideo != 0)
	(*FramebufferEnableVideo)();
    KabortHelp();
    while (1) 
      {
	struct KabC *p;
	int c;
        int cmd;
        int arg;
        
        cmd = arg = 0;
	printx("Command [");
	for (p=KabortCmds; p->func != NULL; p++)
	    KernelPutChar(p->name);
	printx("] > ");
        do
          {
            c = KernelGetChar();
            KernelPutChar(c);
            if ( c != ' ' && c != '\t' && c != '\n' )
              {
                if ( !cmd ) cmd = c; else arg = c;
              }
          }
        while ( c != '\n');
	if (cmd >= 'A' && cmd <= 'Z')
	    cmd += ('a' - 'A');
        if ( (cmd == 'b' || cmd == 'p' || cmd == 's') && ( arg == 0 ) )
          arg = '0';
	for (p=KabortCmds; p->func != NULL && p->name != cmd; p++);
        switch (cmd)
          {
            /* Commands without an argument */
            case 'd':
            case 'e':
            case 'm':
            case 'q':
            case 'v':
            case 'x':
            case '?':
              if ( arg == 0)
	        (*(p->func))();
              else
                printx("Bad command\n");
              break;
            /* Commands with processor number argument */
#ifdef VM
	    case 'b':
#endif VM
            case 'p':
            case 's':
              arg -= '0';
              if ( arg >= 0 && arg < NProcessors )
	        (*( (void (*) _TAKES((unsigned))) (p->func)))(arg);
              else
                printx("Bad command\n");
              break;
          }
      }
  }

void
KStop(file, line, str )
   char * file;
   int line;
   char *str;
  {
    register ProcessorRec *r11;
    register unsigned pno;
     
    DisableAllInterrupts;
    printx("Kernel abort at line %d of %s:%s\n", line, file, str);
#ifdef FIREFLY
    AsmGetProcessorRecord(r11);
    pno = GetProcessorNo(r11);
    ProcessorStopped |= ( 1 << pno );
    if (KStopCount)
      {
        printx("Multiple aborts in kernel\n");
        if ( pno == 0 )
          {
            ;asm("  halt");
          }
        /* Let secondary processors hang */
        while (1);
      }
#endif FIREFLY
#ifdef FIREFLY
    KStopCount++;
    KErrorInfo[pno].errstring = str;
    if ( pno != 0 )
      {
        while(1);
      }
    else
      {
        PrimaryStopProcessors();
        PrimaryAutopsy();
      }
#else
        PrimaryAutopsy();
#endif FIREFLY
  }

void
KForceStop()
  {
    register ProcessorRec *r11;
    register unsigned pno;

    DisableAllInterrupts;
    /*
     * Put 2 dummy longwords on stack so that can invoke SaveProcessContext
     * which pops psl and pc from stack 
     */
    asm("	subl2 $8,sp");
    SaveProcessContext();
    /* Now save pc and psl */

    AsmGetProcessorRecord(r11);
#ifdef FIREFLY
    pno = GetProcessorNo(r11);
    ProcessorStopped |= ( 1 << pno );
    if ( pno == 0)
      {
        PrintHaltMessages();
        PrimaryStopProcessors();
        PrimaryAutopsy();
      }
    else
      {
        while(1);
      }
#endif FIREFLY
  }

/*
 * DumpProcState:
 */

void DumpProcState(pno)
   unsigned pno;
  {
    Process * pd;
    ProcessContext * pcontext;

    pd = ProcessorArray[pno].active;
    pcontext = &pd->pcontext;

    printx("Processor %d: (active process state from process descriptor, not current registers)\n", pno);
    printx("localPid: %08x    ", pd->localPid);
    printx("alienPid: %08x    ", pd->alienPid);
    printx("perProcess: %08x\n", pd->perProcess);
    printx("  r0: %08x    ", pcontext->regs[0]);
    printx("  r1: %08x    ", pcontext->regs[1]);
    printx("  r2: %08x    ", pcontext->regs[2]);
    printx("  r3: %08x\n",   pcontext->regs[3]);
    printx("  r4: %08x    ", pcontext->regs[4]);
    printx("  r5: %08x    ", pcontext->regs[5]);
    printx("  r6: %08x    ", pcontext->regs[6]);
    printx("  r7: %08x\n",   pcontext->regs[7]);
    printx("  r8: %08x    ", pcontext->regs[8]);
    printx("  r9: %08x    ", pcontext->regs[9]);
    printx(" r10: %08x    ", pcontext->regs[10]);
    printx(" r11: %08x\n",   pcontext->regs[11]);
    printx("  ap: %08x    ", pcontext->regs[12]);
    printx("  fp: %08x    ", pcontext->regs[13]);
    printx(" ssp: %08x\n",   pcontext->supervisorStackPtr);
    printx("  pc: %08x    ", pd->PC);
    printx(" psl: %08x    ", pd->status);
    printx(" usp: %08x\n",   pd->userStackPtr);
  }

#ifdef FIREFLY

PrimaryStopProcessors()
  {
    unsigned i,j;

    /*
     * Assumes that we are in virtual memory and that all processors have
     * been booted
     */
    for ( i = 1; i < NProcessors; i++, j = 0)
      {
         if ( !(ProcessorStopped & (1 << i) ) )
           /* if i bit in ProcessorStopped is not set */
           {
             IPCR(i) = FF_INTERRUPT | FF_SET;
             while ( !( ProcessorStopped & (1 << i) ) && j++ <= 100000);
             if ( !(ProcessorStopped & (1 << i) ) )
               printx("Processor %d did not respond to stop request\n",i);
           }
      }
  }

PrintHaltMessages()
  {
    unsigned i;
    KErrorInfoType *ei;
    Process *active;
    for (i = 1; i < NProcessors; i++)
      {
        ei = &KErrorInfo[i];
        if ( ei->haltcode ) 
          {
            active = ProcessorArray[i].active;
            printx("Processor %d halted\n", i);
            printx("PC = 0x%x", active->PC);
            printx("   PSL = 0x%x", active->status);
            printx("   ISP = 0x%x", ei->oldisp);
            printx(" Map enable bit = %d\n",((ei->haltcode & 0x80) >> 7 ));
            printx("Error Code:  %d :	",(ei->haltcode & 0x7f) );
            switch ( ei->haltcode & 0x7f)
              {
                case EXT_HALT:
                  printx ("Assertion of external halt\n");
                  break;
                case ISP_ERR:
                  printx ("Interrupt stack not valid during exception\n");
                  break;
                case DBL_ERR:
                  printx ("Machine check during machine check or ksp invalid exception\n");
                  break;
                case HLT_INST:
                  printx ("HALT instruction executed in kernel mode\n");
                  break;
                case SCB_ERR3:
                  printx ("SCB vector bits<1:0> = 11\n");
                  break;
                case SCB_ERR2:
                  printx ("SCB vector bits<1:0> = 10\n");
                  break;
                case CHM_FR_ISTK:
                  printx ("CHMx executed while on interrupt stack\n");
                  break;
                case MCHK_AV:
                  printx ("ACV or TNV during machine check exception\n");
                  break;
                case KSP_AV:
                  printx ("ACV or TNV during ksp invalid exception\n");
                  break;
              } 
          }
      }
  }

static int Kabort2Count = 0;	/* Used by Kabort2 to trap the case where   */
				/* something that Kabort2 does causes a	    */
				/* further exception.  This assumes that we */
				/* won't be interrupted (and maybe generate */
				/* another exception) while we're in	    */
				/* in Kabort2.  Also requires that any	    */
				/* successful exits from Kabort decrement   */
				/* the counter.				    */
void
Kabort2( pd, req, file, line, str )
   Process	     *pd;
   ExceptionRequest *req;
   char * file;
   int line;
   char	     *str;
  {
    disable;			/* Ensure that Kabort2 can't be recursively
				   called from an interrupt routine. */
    switch (Kabort2Count++)
      {
	case 0:
	    break;
	case 1:
	    printx(
	    "** Detected recursion in Kabort2 routine - Quit **\n");
	    /* fall into ... */
	case 2:
	    KabortQuit(pd, req, str);
	case 3:
	    asm("halt");
	default:
	    while (1) ;	/* Can't even do a VAX HALT properly; just hang. */
      }
    if (FramebufferEnableVideo != 0)
	(*FramebufferEnableVideo)();
    printx("Kernel abort at line %d of %s:%s\n", line, file, str);
    while (1) 
      {
	struct KabC *p;
	char c;

	printx("Command [");
	for (p=KabortCmds; p->func != NULL; p++)
	    KernelPutChar(p->name);
	printx("] or ? for help> ");
	c = K_getchar();
	printx("%c\n", c);
	if (c >= 'A' && c <= 'Z')
	    c += ('a' - 'A');
	for (p=KabortCmds; p->func != NULL && p->name != c; p++)
	    ;
	if (p->func != NULL)
	  {
	    KabortReturn = 0;	/* See KabortContinue() above */
	    (*(p->func))(pd, req, str);
	    if (KabortReturn)
		break;
	  }
	else if (c == '?')
	  {
	    for (p=KabortCmds; p->func != NULL; p++)
		printx("  %c : %s\n", p->name, p->help);
	  }
	/* else stonily ignore whatever they typed */
      }
    Kabort2Count--;
  }
#endif FIREFLY

void
kabort(file, line, str )
   char * file;
   int line;
   char *str;
  {
    asm("	tstl _KStopCount");
    asm("	bneq 0f");

    /* Save registers if KStopCount == 0 */

    /*
     * Put 2 dummy longwords on stack so that can do invoke SaveProcessContext 
     * which pops psl and pc from stack 
     */
    asm("	subl2 $8,sp");
    SaveProcessContext();
    /* Now save pc and psl */

    asm("0:");
    KStop(file,line,str);
  }

void
LockSCB()
  {
    ChangeSysPagesProtection((unsigned)SysControlBlock,
		 NumExceptions * sizeof SysControlBlock[0], VM_R___);
  }

asm("	.globl	Panic");

void
DummyPanic()
  {
    asm("  Panic:");
    printx("*** Panic ****\n");
    while (1);
  }

