/*
 * V Kernel - Copyright (c) 1985 by Stanford University, All rights reserved.
 *
 * Debugger display routines
 *
 * $Revision: 1.4.1.2 $
 * $Locker:  $
 * $State: Exp $
 */

#include "debugger.h"

/* Forward */
static void di_string _TAKES((unsigned long));
static void di_int _TAKES((unsigned long));
static void di_long _TAKES((unsigned long));
static void di_short _TAKES((unsigned long));
static void di_char _TAKES((unsigned long));
static void di_uint _TAKES((unsigned long));
static void di_ulong _TAKES((unsigned long));
static void di_ushort _TAKES((unsigned long));
static void di_uchar _TAKES((unsigned long));


void
display(address,format)
unsigned long address;
char *format;
{
	switch(*format)
	{
		case 's': /* string */
			di_string(address);
			break;
		case 'l': /* long */
			di_long(address);
			break;
		case 'i': /* int */
			di_int(address);
			break;
		case 'h': /* short */
			di_short(address);
			break;
		case 'c': /* char */
			di_char(address);
			break;
		case 'u': /* unsigned something */
			++format;
			switch(*format)
			{
				case 'l': /* long */
					di_ulong(address);
					break;
				case 'i': /* int */	
					di_uint(address);
					break;
				case 'h': /* short */
					di_ushort(address);
					break;
				case 'c': /* char */
					di_uchar(address);
					break;
				default: /* int */
					di_uint(address);
					break;
			}
		default: /* int */
			di_int(address);
			break;
	}
}

static void di_string(address)
unsigned long address;
{
}

static void di_int(address)
unsigned long address;
{
#ifdef VAX
di_long(address); /* same diff */
#endif /* VAX */
}

static void di_long(address)
unsigned long address;
{
}

static void di_char(address)
unsigned long address;
{
}

static void di_short(address)
unsigned long address;
{
}

static void di_uint(address)
unsigned long address;
{
#ifdef VAX
di_ulong(address);
#endif /* VAX */
}

static void di_ulong(address)
unsigned long address;
{
}

static void di_uchar(address)
unsigned long address;
{
}

static void di_ushort(address)
unsigned long address;
{
}

