
struct intpoint {int x,y};
struct bline {short int acc, sdx, sdy, adx, ady, x, y};

#define stepbline(l) {\
l.y += l.sdy;\
l.acc += l.adx;\
while (l.acc >= 0) {\
    l.acc -= l.ady;\
    l.x += l.sdx;\
    }\
}

#define quicktrap(left, right, twicelen) for (d = twicelen; d > 0; d -= 2) {\
    fillin(left.y, left.x, right.x);\
    stepbline(left);\
    stepbline(right);\
    }

triangle(a, b, c)
struct intpoint *a, *b, *c;
{
struct bline cb, ba, ca;
int s, d;
#ifdef debugtriangles
printf("triangle(%d,%d %d,%d %d,%d)\n",
    a->x, a->y, b->x, b->y, c->x, c->y);
#endif
if (a->y < b->y) swapintpoints(&a, &b);
if (b->y < c->y) {
    if (a->y < c->y) swapintpoints(&a, &c);
    swapintpoints(&b, &c);
    }
if (a->y == c->y) return;
initbline(&ca, c->y, c->x, a->y, a->x);
initbline(&cb, c->y, c->x, b->y, b->x);
initbline(&ba, b->y, b->x, a->y, a->x);
s = (b->x - a->x)*(c->y - a->y) - (b->y - a->y)*(c->x - a->x);
if (s < 0 /* ba right of ca */) {
    quicktrap(ca, cb, cb.ady);
    quicktrap(ca, ba, ba.ady);
    }
else if (s > 0) {
    quicktrap(cb, ca, cb.ady);
    quicktrap(ba, ca, ba.ady);
    }
}

swapintpoints(a, b)
struct intpoint **a, **b;
{
struct intpoint *c;
c = *a; *a = *b; *b = c;
}

trapezoid(fromy, toy, leftfromx, lefttox, rightfromx, righttox)
int fromy, toy, leftfromx, lefttox, rightfromx, righttox;
{
struct bline left, right;
int d;
#ifdef debugtriangles
printf("trapping %d, %d, %d, %d, %d, %d\n",
    fromy, toy, leftfromx, lefttox, rightfromx, righttox);
#endif
initbline(&left , fromy,  leftfromx, toy,  lefttox);
initbline(&right, fromy, rightfromx, toy, righttox);
for (d = left.ady; d > 0; d -= 2) {
    fillin(left.y, left.x, right.x);
    stepbline(left);
    stepbline(right);
    }
}

initbline(l, fromy, fromx, toy, tox)
struct bline *l;
int fromy, fromx, toy, tox;
{
int dx, dy;
dx = tox - fromx;
dy = toy - fromy;
l->adx = 2*abs(dx);
l->ady = 2*abs(dy);
l->sdx = sgn(dx);
l->sdy = sgn(dy);
l->acc = (-abs(dy)) + abs(dx);
l->x = fromx;
l->y = (l->sdy > 0)?fromy:(fromy-1);
if (l->ady > 0) while (l->acc >= 0) {
    l->acc -= l->ady;
    l->x += l->sdx;
    }
#ifdef debugblines
printf("initbline(fromy=%d, fromx=%d, toy=%d, tox=%d) gives\n\
adx=%d, ady=%d, sdx=%d, sdy=%d, acc=%d, x=%d, y=%d\n",
    fromy, fromx, toy, tox, l->adx, l->ady, l->sdx, l->sdy,
    l->acc, l->x, l->y);
#endif
}

int sgn(n)
int n;
{return (n<0)?(-1):((n>0)?1:0);}

