# include <framebuf.h>
# include <rasterops.h>

/*
 * A reasonable interface to the RasterOp package
 * Bill Nowicki May 15, 1982
 */

extern int GXBase;



ReasonableCopy( xsrc, ysrc, h, w, xdst, ydst, funct)
    register short	h,w;	/* d7, d6 */
    short		xdst,xsrc,ydst,ysrc,funct;
{
  struct fb_raster source, destination;
  
  source.x = xsrc;
  source.y = ysrc;
  source.height = h;
  source.width = w;
  destination.x = xdst;
  destination.y = ydst;
  GXfunction = funct;
  RasterCopy( &destination, &source);
}

ReasonableGet( x, y, h, w, buf, funct)
  short x, y, h, w, funct;
  short *buf;
{
  struct fb_raster source;
  struct mem_raster destination;
  
  source.x = x;
  source.y = y;
  source.height = h;
  source.width = w;
  destination.start = buf;
  GXfunction = funct;
  RasterGet( &destination, &source);
}


ReasonablePut( x, y, h, w, buf, funct)
  short x, y, h, w, funct;
  short *buf;
{
  struct mem_raster source;
  struct fb_raster destination;
  
  source.start = buf;
  destination.x = x;
  destination.y = y;
  destination.height = h;
  destination.width = w;
  GXfunction = funct;
  RasterPut( &destination, &source);
}

rasterop1 (w, h, x, y)
    register short	x,y,h,w;	/* d7, d6, d5, d4 */
{
  struct fb_raster temp;
  temp.height = h;
  temp.width = w;
  temp.x = x;
  temp.y = y;
  RasterFill( &temp );
}
