/*
	program to convert .pix format to .sun format
*/

#include "stdio.h"
#include "pix.h"

#define SET(row,col) Mem [row] [col>>4] |= Mask [col &0xF]

int Mem [1024] [128];
int row, col, height, width, i;
int Mask [] = {	0x8000, 0x4000, 0x2000, 0x1000,
		0x800, 0x400, 0x200, 0x100,
		0x80, 0x40, 0x20, 0x10,
		0x8, 0x4, 0x2, 0x1};
int i, maxgray, cutoff;
int height, width, row, col;

main ()
{
	ReadPicHeader ("pixsun", 1, maxgray, height, width);

	if ((height > 1024) || (width > 1024)) {
		fprintf (stderr, "pixsun: picture too big\n");
		exit (1);
		}

	cutoff = maxgray >> 1;

	for (row = 0; row < height; row++) {
		/* read one line */
		for (col = 0; col < width; col++) {
			if ( (i=getchar ()) == EOF) {
				fprintf (stderr, "pixsun: premature end of file\n");
				exit (1);
				}
			if (i > cutoff)
				SET (row, col);
			}
		}

	fprintf (stderr, "%d rows by %d columns\n", height, width);

	WritePicHeader (3, 1, height, width);

	i = 0;
	for (col = width; col > 0; col -= 16) {
		for (row = 0; row < height; row++ ) {
			putchar (Mem[row][i] >> 8);
			putchar (Mem[row][i] & 0xFF);
			}
		i++;
		}

	fprintf (stderr, "done\n");		
}
