/*
	program to expand a .pic file by an integral factor
*/

#include "stdio.h"
#include "pix.h"

#define SIZE 10240

int MaxGray, height, width;
int row, col;
char buf [SIZE];
int i, j, repeat;

main (argc, argv)
int argc;
char **argv;
{
	if (argc != 2) {
		fprintf (stderr, "expand: must be called with one argument\n");
		exit (1);
		}
	if (sscanf (argv[1], "%d", &repeat) != 1) {
		fprintf (stderr, "expand: bad argument\n");
		exit (1);
		}

	ReadPicHeader ("expand", 1, MaxGray, height, width);

	WritePicHeader (1, MaxGray, height*repeat, width*repeat);

	if (width > SIZE) {
		fprintf (stderr, "expand: picture too big\n");
		exit (1);
		}

	for (row = 0; row < height; row ++) {

		/* do one row */

		for (col = 0; col < width; col++)
			if ( (buf [col] = getchar ()) == EOF) {
				fprintf ("expand: premature end of file\n");
				exit (1);
				}

		for (i = repeat; i; i--)
			for (col = 0; col < width; col++)
				for (j = repeat; j; j--)
					putchar (buf [col]);
		}
}
