/*
	Read a pix file, and convert it to a strictly binary image (0 or 255)
	using the average error minimization techniques.
*/

#include "stdio.h"
#include "pix.h"

int height, width, maxgray, cutoff;
int row, col;
int desired, correction, cr, cd, cdiag;
int buf1 [1026] = {0};
int buf2 [1026] = {0};
int *current, *next, *t;
int i;


main ()
{
	ReadPicHeader ("avgerror", 1, maxgray, height, width);

	if ((height > 1024) || (width > 1024)) {
		fprintf (stderr, "avgerror: picture too big\n");
		exit (1);
		}

	WritePicHeader (1, 255, height, width);

	cutoff = maxgray >> 1;

	current = buf1 + 1;
	next = buf2 + 1;
	for (row = 0; row < height; row++) {

		/* do one row */

		for (col = 0; col < width; col++) {

			/* do one pixel */

			if ( (i = getchar()) == EOF) {
				fprintf (stderr, "avgerror: premature end of file\n");
				exit (1);
				}
			desired = *current + i;
			if (desired > cutoff) {
				/* turn this pixel on */
				putchar (255);
				correction = desired - 255;
				}
			else	{
				/* turn this pixel off */
				putchar (0);
				correction = desired;
				}
			cdiag = 3 *(correction >> 4);	/* 3/16 of error diagonally */
			correction -= cdiag << 1;	/* what's left over */
			cr = correction >> 1;		/* 1/2 of remainder right */
			cd = correction - cr;		/* the rest goes down */
			*current++ = 0;
			*current += cr;
			*(next-1) += cdiag;
			*next++ += cd;
			*next += cdiag;
			}
		/* now swap buffers */
		t = current;
		current = next - width;
		next = t - width;
		}
}
