/* 
 * mogul.c - a bunch of graphics hacks by Jeff Mogul
 *
 * Containerized by Bill Nowicki March 1982
 */

# include "td.h"

/*
 * kal.c
 *
 * Sun Kaleidoscope by Jeffrey Mogul
 *
 * stolen from:
// Kal.bcpl -- Alto Kaleidoscope by (in order of appearance):
//	Martin Newell
//	Joe Maleson
//	Dana Scott
//	David Boggs
// Copyright Xerox Corporation 1979
// Last modified June 11, 1979  1:41 PM by Boggs

// Kal uses three-parameter (a, b, c) sequence generators to
//   create and erase points with 8 or 12 way symmetry.  Two
//   other parameters, (period and persistence) are global
//   to all sequence generators.  On each cycle, each generator
//   does a _ G(a, b) and the 'a's are used to create 8 or 12 new points
//   and erase 8 or 12 old ones.  Every 'period' cycles each generator
//   does b _ G(b, c).  Generators come in pairs - one to create
//   points and the other to erase them.  The erasing generator
//   runs 'persistence' cycles behind the creating one.  Thus
//   'persistence' determines the life of each point, and hence
//   the number of points on the screen at any one time.
//
 */

/*
 * Updated for version one frame buffer June 14, 1981 by Bill Nowicki
 * Cleaned up:	July 1, 1981 by Jeffrey Mogul
 */
 
#define HLFSCRN 256
#define SCRNMAX 511

struct GenParam {	/* generator parameter block */
	unsigned short	Xa;
	unsigned short	Xb;
	unsigned short	Xc;
	unsigned short	Ya;
	unsigned short	Yb;
	unsigned short	Yc;
	unsigned short	period;
	unsigned short	count;	/* initialized to period and decremented to 0 */
	unsigned short	symmetry;
	};

struct GenParam Show;	/* one param block for showing generator */
struct GenParam Erase;	/* one param block for erasing generator */
struct GenParam Init = {	/* initial value param block */
	3, 10, 10,
	5, 3, 10,
	496, 0, 12};

unsigned short	persistance = 800;


/*
 * CENTERPOINT(x,y) sets the given point to whatever the prevailing
 * function is, with x, y from the middle of the screen.
 */

#define	CENTERPOINT(x,y) {\
    GXsetX((x)+XCENTER);\
    *(short*)(GXBase|GXupdate|GXsource|GXselectY|(((y)+YCENTER)<<1))=\
    						0xFFFF;\
    }

nkal()
  {
	register unsigned short i;
      
	Init.count = Init.period;	/* initialize count */
	ScreenClear();
	Inquire(&Init);

	copy(&Show,&Init, sizeof Init);	 /* initialize Show generator */
	copy(&Erase,&Init, sizeof Init); /* initialize Erase generator */
	ScreenClear();
	GXwidth = 1;

	for (i = 0; i < persistance; i++) {
		/* start Show generator first by persistance cycles */
		Generate(&Show, GXset);
		}
	
	while (!keyhit()) {	/* generate next point in both sequences */
		Generate(&Show, GXset);
		Generate(&Erase, GXclear);
		}
}	

copy(dst,src,size)
char	*dst;
char	*src;
unsigned short	size;
  {
	for (; size ; size--) *dst++ = *src++;
  }

Generate(gp,mode)
struct GenParam *gp;	/* pointer to generator parameter block */
unsigned short	mode;		/* either GXset or GXclear */
  {	/* */
	register short	x0,y0,x1,y1;

	GXfunction = mode;

	gp->Xa = (gp->Xa + gp->Xb) ^ gp->Xb;
	gp->Ya = (gp->Ya + gp->Yb) ^ gp->Yb; 
	if (--gp->count == 0) {
	   gp->Xb = (gp->Xb + gp->Xc) ^ gp->Xc;
	   gp->Yb = (gp->Yb + gp->Yc) ^ gp->Yc;
	   gp->count = gp->period;
	   }

	if (gp->symmetry == 8) {
      		x0 = gp->Xa >> 8;
		y0 = gp->Ya >> 8;

		if (x0 <= y0) {
	        	x1 = (SCRNMAX)-x0;
	        	y1 = (SCRNMAX)-y0;

	        	CENTERPOINT(x0, y0);
			CENTERPOINT(x0, y1);
	        	CENTERPOINT(y0, x0);
			CENTERPOINT(y0, x1);
	        	CENTERPOINT(x1, y0);
			CENTERPOINT(x1, y1);
	        	CENTERPOINT(y1, x1);
			CENTERPOINT(y1, x0);
			}
		}
	else {	/* symmetry == 12 */
	      x0 = gp->Xa >> 9;
	      y0 = gp->Ya >> 9;

	      if (x0 <= y0) {
		         x1 = x0 << 1;
		         y1 = y0 << 1;

			 /* we might want to double scan lines here? */

		         CENTERPOINT((HLFSCRN)+x0+y0, (HLFSCRN)-x1+y1);
			 CENTERPOINT((HLFSCRN)+x0+y0, (HLFSCRN)+x1-y1);
		         CENTERPOINT((HLFSCRN)-x0-y0, (HLFSCRN)-x1+y1);
			 CENTERPOINT((HLFSCRN)-x0-y0, (HLFSCRN)+x1-y1);
		         CENTERPOINT((HLFSCRN)+x0-y1, (HLFSCRN)-x1);
			 CENTERPOINT((HLFSCRN)+x0-y1, (HLFSCRN)+x1);
		         CENTERPOINT((HLFSCRN)-x0+y1, (HLFSCRN)-x1);
			 CENTERPOINT((HLFSCRN)-x0+y1, (HLFSCRN)+x1);
		         CENTERPOINT((HLFSCRN)+x1-y0, (HLFSCRN)-y1);
			 CENTERPOINT((HLFSCRN)+x1-y0, (HLFSCRN)+y1);
		         CENTERPOINT((HLFSCRN)-x1+y0, (HLFSCRN)-y1);
			 CENTERPOINT((HLFSCRN)-x1+y0, (HLFSCRN)+y1);
			 }
		}
}

char	response[100];

Inquire(gp)
struct GenParam *gp;
{
	unsigned int stemp;

	printf("Kal - Sun Kaleidescope\n");
	printf("Enter parameters; <cr> means: use default\n");
	getparam(&(gp->Xa),"Xa");
	getparam(&(gp->Xb),"Xb");
	getparam(&(gp->Xc),"Xc");
	getparam(&(gp->Ya),"Ya");
	getparam(&(gp->Yb),"Yb");
	getparam(&(gp->Yc),"Yc");
	getparam(&(gp->period),"Period");

	getparam(&persistance,"Persistance");

retry_sym:
	printf("Symmetry [8 or 12] (%u) => ",gp->symmetry);
	gets(response);
	if (*response) {
	    sscanf(response,"%u",&stemp);
	    if ((stemp == 8) || (stemp == 12))
	    	gp->symmetry = stemp;
	    else {
		printf("response '%s'\n",response);
		printf("%u is not a possible symmetry\n",stemp);
		goto retry_sym;
	    }
	}

#ifdef DEBUG
	printgp(gp);	    
#endif DEBUG
}

getparam(param,name)
unsigned short *param;
char *name;
{
	int stemp;

	printf("%s (%u) => ",name,*param);
	gets(response);
	if (*response) {
	    sscanf(response,"%u",&stemp);
	    *param = stemp;
	}
}

#ifdef DEBUG
printgp(g)
struct GenParam *g;
{

	printf("Xa %u b %u c %u Ya %u b %u c %u\n",
		g->Xa,g->Xb,g->Xc,g->Ya,g->Yb,g->Yc);
	printf("period %u symmetry %u\n",g->period,g->symmetry);
}
#endif DEBUG

/*
 * rotor.c
 *
 * Rotating Sun Spiral by Jeffrey Mogul
 *
 */


char response[100];

rotor()
{
	int x1,y1;
	int x2,y2;
	int delay;
	register int r;
	int count;

/*	printf("Enter r ");
	gets(response);
	r = atoi(response);

	printf("Enter delay ");
	gets(response);
	delay = atoi(response);
	
	***/
	
	r = -2; delay = 300;

	printf("r = %d, delay = %d\n",r,delay);

	ScreenClear();
	GXwidth = 1;

	x1 = 100;
	y1 = 0;

	x2 = x1;
	y2 = y1;

	if (r < 0) {
	    r = -r;
	    for (count = 0; count < delay;count++) {
		spiralclp(x1,y1,r,384,512,GXset,512);
		step(&x1,&y1,r);
	    }
	    while (!keyhit()) {
		spiralclp(x1,y1,r,384,512,GXset,512);
		step(&x1,&y1,r);
		spiralclp(x2,y2,r,384,512,GXclear,512);
		step(&x2,&y2,r);
	    }
	}
	else {
	    for (count = 0; count < delay;count++) {
		spiral(x1,y1,r,384,512,GXset,350);
		step(&x1,&y1,r);
	    }
	    while (!keyhit()) {
		spiral(x1,y1,r,384,512,GXset,350);
		step(&x1,&y1,r);
		spiral(x2,y2,r,384,512,GXclear,350);
		step(&x2,&y2,r);
	    }
	}
}

step(x,y,r)
register int *x;
register int *y;
register int r;
{
	*x += (*y>>r);
	*y -= (*x>>r);
}

/*
 * cyl.c
 *
 * Sun Cylinders by Jeffrey Mogul
 *
 */

ncyl()
{
	register unsigned int i;
	int xinit, rad;
	int delay;
	register int x,x1;

	ScreenClear();
	GXwidth = 1;
	rad = 100;

	x = 150;
	x1 = x-10;

	while (!keyhit()) {
		x++; x1++;
		if (x>650) x = 150;
		if (x1>650) x1 = 150;
		circ(rad,4,x,x,GXset);
		circ(rad,4,x1,x1,GXclear);
		circ(rad,4,x,(800-x),GXset);
		circ(rad,4,x1,(800-x1),GXclear);
		circ(rad,4,(800-x),x,GXset);
		circ(rad,4,(800-x1),x1,GXclear);
		circ(rad,4,(800-x),(800-x),GXset);
		circ(rad,4,(800-x1),(800-x1),GXclear);
	}
}

/*
 * burst.c
 *
 * Sun Burst by Jeffrey Mogul
 *
 */

burst() {
	register unsigned int i;
	int xinit, rad;
	int delay;
	register int x,x1;

	ScreenClear();
	GXwidth = 1;

	while (!keyhit()) 
	  {
	    for (rad = 50; rad < 350; rad++) 
		circ(rad,4,384,384,GXset);
	    
	    if ( keyhit() ) break;

	    for (; rad > 50 ; rad--) 
		circ(rad,4,384,384,GXclear);
	   
	    if ( keyhit() ) break;

	    for (rad = 50; rad < 350; rad++) 
		circ(rad,4,384,384,GXset);
	    
	    if ( keyhit() ) break;

	    for (rad = 50; rad < 350; rad++) 
		circ(rad,4,384,384,GXclear);
	    
	    if ( keyhit() ) break;

	    for (; rad > 50 ; rad--) 
		circ(rad,4,384,384,GXset);

    	    if ( keyhit() ) break;

	    for (rad = 50; rad < 350; rad++) 
		circ(rad,4,384,384,GXclear);
	    
	    if ( keyhit() ) break;

	    for (; rad > 50 ; rad--) 
		circ(rad,4,384,384,GXset);

	    if ( keyhit() ) break;	    

	    for (rad = 350; rad > 50; rad--)
		circ(rad,4,384,384,GXclear);
	}
}

/*
 * circ.c
 *
 * Sun Circles by Jeffrey Mogul
 *
 * stolen from:
 * Hackmem Minksy?
 */

/*
 * draw a circle of radius "radius" centered at cx, cy
 * mode is either GXset or GXclear
 * r should be something like 4
 */


circ(radius,r,cx,cy,mode)
int radius;
register int r,cx,cy;
unsigned int mode;
{ /*	*/
	register int x,y;
	register int i;
	register int ilast;

	GXfunction = mode;

	x = radius;
	y = 0;

	ilast = (radius<<(r-3));

	for (i = 0; i < ilast; i++) {
		GXsetX(cx+x);
		*(short *)(GXBase|GXupdate|GXsource|GXselectY|( (cy+y)<<1) ) = i;
		x += (y>>r);
		y -= (x>>r);
		}

}


/*
 * rect.c - a simple frame buffer demo program
 *
 * Original author: Who knows? Andy or Vaughan??
 *
 * Updated by Bill Nowicki April 27, 1981
 *	- Used include file
 *	- set map on SUN1
 * Updated by Jeffrey Mogul @ Stanford		2 July 1981
 *	- for version 1 sun board
 */

frect() 
 {
	register int x1, x2, y1, y2, y;
	int x;
	register int ffff = 0xffff;
	register short *ystartp;
	register short *yendp;
	register short *xstartp;
	register short *xendp;
	short pass, rand;

	pass = 0;

	/* erase display */
	ScreenClear();

	/* create overlaping rectangles */

	GXwidth = 16;

	while (!keyhit()) {
	    rand = rand*4 + rand + 17623;
	    x1 = rand & 0x3F0;
	    rand = rand*4 + rand + 17624;
	    x2 = rand & 0x3F0;
	    x = (x1 > x2) ? x2 : x1;
	    x2 = (x1 > x2) ? x1 : x2;
	    rand = rand*4 + rand + 17623;
	    y1 = rand & 1023;
	    rand = rand*4 + rand + 17623;
	    y2 = rand & 1023;
	    y = (y1 > y2) ? y2 : y1;	/* sort so that y1 <= y2 */
	    y2 = (y1 > y2) ? y1 : y2;

	    pass++;

	    if ((pass&7) == 0)
	    	GXfunction = GXset;
	    else
	    	GXfunction = GXinvert;

	    xstartp = (short *)(GXBase|GXselectX|(x1<<1));
	    xendp = (short *)(GXBase|GXselectX|(x2<<1));
	    
	    y <<= 1;
	    y2 <<= 1;

	    while (xstartp < xendp) {
		*xstartp = 1;
		xstartp += 16;

		ystartp = 
		  (short *)(GXBase|GXupdate|GXsource|GXselectY|y);
		yendp = 
		  (short *)(GXBase|GXupdate|GXsource|GXselectY|y2);

#ifdef SLOWER
		while (ystartp <= yendp) {
		   *ystartp++ = ffff;
		}
#else
#ifdef SLOW
		/* y1 <= y2 by "sort" above, so this is faster */
	loop:	*ystartp++ = ffff;
		if (ystartp <= yendp) goto loop;
#else
	loop:	asm(" moveml #/ffff,a4@-");
		if (ystartp <= yendp) goto loop;		
#endif SLOW
#endif SLOWER
	    }

	}
}

