/* SubRaster
 * Per Bothner, March 1983	Latest update: 1983/Sept/16 PB
 */
#include <bitmaps.h>
#include <rasterops.h>
#include <framebuf.h>

#define RasterDeltaY(sub,super) ((sub->start - super->start) % sub->stride)
#define RasterDeltaX(sub,super) ((((sub->start - super->start) / sub->stride) << 4)\
	+ sub->bitOffset - super->bitOffset)
#define max(a,b) ((a) > (b) ? (a) : (b))

MemRaster *
SubRaster(out,in,dx,dy,h,w)
/* return the subraster of 'in' starting at (dx,dy) and size (h,w)
 * dx and dy may be negative, and the output size may be greater than the input size.
 * Then, if 'in' is a LinkedRaster, the HeadRaster will be found, and if needed,
 * a larger raster will be allocated.
 */
  register MemRaster *out, *in;
  int dx,dy,h,w;
  {
    if (!out) out = (MemRaster *)(malloc(sizeof(MemRaster)));
    if (!in || in->height == 0)
      {
	out->width = w;
	out->height = out->stride = h;
	out->bitOffset = 0;
	out->where = IsHeadRaster;
	out->start = (short *)(malloc((h*(w+15)>>4) << 2));
	out->next = out;
	RasterOp(out, 0, !in || !(in->where&InverseRaster) ? GXclear : GXset);
	return(out);
      }
    out->where = in->where;
    if (in->where & MemoryRaster) out->where &= ~HeadRaster;
    if (in->where & LinkedRaster && out != in)
      {out->next = in->next; in->next = out;}
    if (dx < 0 || dy < 0 || dx + w > in->width || dy + h > in->height)
      { register MemRaster *r = (MemRaster *)(GetHeadRaster(in));
        if (!r)
	  {
	    dx = max(dx,0); if (w > in->width) w = in->width;
	    dy = max(dy,0); if (h > in->height) h = in->height;
	  }
	else
	  {
	    dx += RasterDeltaX(in,r);
	    dy += RasterDeltaY(in,r);
	    if (dx < 0 || dy < 0 || dx + w > in->width || dy + h > in->height)
	      { /* drastic measures are indicated. A new, larger raster is
		 * allocated, and all rasters in the list are set to point to it.
		 */
	        MemRaster tempRaster; register MemRaster *big;
		register deltaX, deltaY, i;
		short *headStart = r->start; int headStride = r->stride;
		r->where ^= (-1 & HeadRaster);
		big = (MemRaster *)(malloc(sizeof(MemRaster)));
		big->where = HiddenHeadRaster;
		big->bitOffset = 0;
		big->next = r->next; r->next = big;
		if (dy > 0)
		  { i = dy + h; if (i < r->height) i = r->height; deltaY=0;}
		else
		  { i = r->height - dy; if (i < h) i = h; deltaY = -dy;}
		big->stride = i; big->height = i;
		if (dx > 0)
		  { i = dx + w; if (i < r->width) i = r->width; deltaX = 0;}
		else
		  { i = r->width - dx; if (i < w) i = w; deltaX = -dx;}
		big->width = i;
		big->start = (short *)
		    (malloc(big->height * ((big->width + 15) >> 4) << 2));
		RasterOp(big, 0, GXclear);
		SubRaster(&tempRaster, big, deltaX, deltaY, r->height, r->width);
		RasterOp(&tempRaster, r, GXcopy);
		FreeRaster(&tempRaster);
		/* if 'r' used to be HiddenHeadRaster, free it: */
		if (r->where & SpecialRaster) {FreeRaster(r); free(r);}
		free(headStart);
		/* fixup all the old rasters to be subrasters of 'big' */
		for (r = out; r != big; r = r->next)
		  {
		    r->stride = big->stride;
	            r->bitOffset = (r->bitOffset + deltaX) & 15;
		    i = ((char*)r->start - (char*)headStart) << 1;
		    r->start = big->start + deltaY
		        + i % headStride
			+ (i / headStride) * big->stride;
		  }
		in = r; dx += deltaX; dy += deltaY;
	      }
	  }
      }
    if (in->where & MemoryRaster)
      {
        out->bitOffset = (in->bitOffset + dx) & 15;
	out->stride = in->stride;
	out->height = h;
	out->width = w;
	out->start = in->start + ((dx + in->bitOffset) >> 4)*in->stride + dy;
      }
    else if ((in->where & 0x7F) == IsFbRaster)
      {
	out->height = h;
	out->width = w;
	GenToFbRaster(out)->x = GenToFbRaster(in)->x + dx;
	GenToFbRaster(out)->y = GenToFbRaster(in)->y + dy;
      }
    return(out);
  }
