/*
 * screen.c - A bunch of SUN framebufer general routines
 *
 * ScreenInit()	Initialize the screen by setting video enable, 
 *		and possibly other initialization in the future.
 *
 * ScreenClear()	Clear screen to all black
 *
 * ScreenSet()		Set screen to all white (green)
 *
 * ScreenFlash()	Invert the screen (white <--> black)
 *
 * Written by Bill Nowicki July 1982
 *
 * Copyright Stanford University
 */

# include <framebuf.h>
# include <rasterops.h>

int GXBase;

ScreenInit()
  {
  	/*
	 * Initialize. Note GXBase must be set already!
	 */
     GXcontrol = GXvideoEnable;
  }

static struct fb_raster screen = {1024, 1024, 0, 0};

ScreenClear()
  {
  	/*
	 * Clear the screen to all zeros, black
	 */
     GXfunction = GXclear;
     RasterFill( &screen );
     ScreenInit();
  }


ScreenSet()
  {
  	/*
	 * Clear the screen to all zeros, black
	 */
     GXfunction = GXset;
     RasterFill( &screen );
     ScreenInit();
  }

ScreenFlash()
  {
  	/*
	 * Flash the screen, i.e. invert it
	 */
     GXfunction = GXinvert;
     RasterFill( &screen );
     ScreenInit();
  }

