/*
 *     This is a package of macros that provide a user interface to the 
 * rasterop package.  
 *
 * Original: David Brown Stanford University, 1982
 *
 * Simplified by Bill Nowicki June 1982
 *
 * Most routines have at least two names; one consisting of "Raster"
 * followed by an English word suggesting its action, and the other
 * constructed out of letters and underscores.  Macros are provided
 * so you can use which ever you prefer.
 */

typedef short	*MASK;		/* pointer to 16 shorts	*/

struct mem_raster
  {
    short	height;
    short	width;
    short	*start;		/* start address of the raster in memory */
  };

struct fb_raster
  {
    short	height;
    short	width;
    short	x;		/* x coordinate of upper left corner	*/
    short	y;		/* y coordinate of upper left corner	*/
  };

extern int GXBase;

# define ROP_DS_FF(destination,source) 	RasterCopy(destination,source)
# define ROP_DS_MF(memory,source) 	RasterGet(memory,source)
# define ROP_DS_FM(destination,memory) 	RasterPut(destination,memory)
# define ROP_DM_FM(destination,mask) 	RasterPattern(destination,mask)
# define ROP_D_F(destination)		RasterFill(destination)
/*  None defined 			RasterRoll(raster,upBy) */
