/*
 * put.c - RasterPut SUN graphics primitive
 *
 *  This is the function to put a raster from memory into the framebuffer 
 *
 *  It is up to the user to set the Function which will take effect during the 
 *  blt, in advance of the call to Rasterput().  That is, Rasterput, invokes the
 *  pre-established function on the source raster (in memory) and destination
 *  raster (in the framebuffer).
 */

#include <rasterops.h>
#include <framebuf.h>

RasterPut(dst, src)
    struct fb_raster	*dst;
    struct mem_raster	*src;
{
    register short	h = dst->height,		/* d7, d6 */
			w = dst->width;

    register short	*Mem = src->start;		/* a5 */

    register short					/* a4, a3 */
    	*Y_Address =
	    (short *)(GXBase|GXsource|GXupdate|GXselectY+((dst->y)<<1)),
	*X_Address =
	    (short *)(GXBase|GXselectX+((dst->x)<<1));

    register		i,j;				/* d5, d4 */


	/* Precompute iteration for both the x and y loops	*/
	/* First perform the full-width loop			*/

	GXwidth = 16;
	for (i=w>>4 ; i>0 ; i--){
	    *X_Address = 1;		/* setup x address in framebuf */
	    for (j=h ; j>0 ; j--) *Y_Address++ = *Mem++;
	    Y_Address -= h;
	    X_Address += 16;
	}

	/* if there was any leftover width perform one special iteration */
	if (w &= 0xF){
	    GXwidth = w;		/* set a narrower width */
	    *X_Address = 1;
	    for (h ; h>0 ; h--) *Y_Address++ = *Mem++;
	}
}
