#include <framebuf.h>

/*----------------------------------------------------------------------------
==============================================================================

    This is a Bresenham Algorithm to draw vectors in the frame buffer

    The user specifies the width of the line, and the contents of the SRC,
and MSK registers, as well as the FUNCTION to be used in drawing the line.
This allows a certain flexibility (although limited) on the part of the 
user.  He/she may draw lines of wider than one pixel and of a particular
pattern.  He/she may also use any pixel combination function in the drawing
of the line thus allowing 'ORing', 'XORing', and the like.
    This external setting of FUNCTION and FB Registers is in keeping with the
general methodology of the rasterops package.

==============================================================================
----------------------------------------------------------------------------*/

extern int GXBase;

LineDJB(x,y,dx,dy)
    int	x,y,dx,dy;
{
    register short	*Address1 = (short *)(GXBase|GXupdate),
			*Address2 = (short *)(GXBase);
    register	lgdelta,smdelta,error,i,quadrant;
    int		sgn();

/*----------------------------------------------------------------------
	GXwidth = 1;
	GXfunction = ((display==DRAW) ? GXset : GXclear); 
----------------------------------------------------------------------*/

	quadrant = 2 * sgn(dy) + sgn(dx);
/*	printf("quadrant is %d\n",quadrant);	/* debug */
	if(dy<0) dy *= -1;	/* make dx and dy magnitudes (positive) */
	if(dx<0) dx *= -1;
	if (dy>dx){
	    lgdelta = dy;
	    smdelta = dx;
	    Address1 = (short *)((int)Address1 | GXselectY + (y<<1));
	    Address2 = (short *)((int)Address2 + (x<<1));
            if(quadrant == 1) quadrant = 2;
            else if(quadrant == 2) quadrant = 1;
	}
	else{
	    lgdelta = dx;
	    smdelta = dy;
	    Address1 = (short *)((int)Address1 + (x<<1));
	    Address2 = (short *)((int)Address2 | GXselectY + (y<<1));
	}

/*============================================================================
------------------------------------------------------------------------------

    Now commence the actual drawing of the vector in the frame buffer

------------------------------------------------------------------------------
============================================================================*/


	i = lgdelta;
	error = 2*smdelta - lgdelta;
	*Address2 = 1;

	switch( quadrant ){
	case 0:				/* both deltas positive */
	    do{
	        *Address1++ = 1;
		if(error > 0){
		    *Address2++ = 1;
		    error += 2*(smdelta-lgdelta);
		}
		else
		    error += 2*smdelta;
/* debug
                printf("present lgd, smd are %d %d\t"
                   ,((int)Address1&0x7ff)>>1, ((int)Address2&0x7ff)>>1);
                printf("i:%d e:%d\n",i,error);
 end debug */
	    } while( --i > 0);
	    break;

	case 2:				/* small delta negative */
	    do{
		*Address1++ = 1;
		if(error > 0){
		    *Address2-- = 1;
		    error += 2*(smdelta-lgdelta);
		}
		else
		    error += 2*smdelta;
/* debug
                printf("Quad 1:present lgd, smd are %d %d\t"
                   ,((int)Address1&0x7ff)>>1, ((int)Address2&0x7ff)>>1);
                printf("i:%d e:%d\n",i,error);
 end debug */
	    } while( --i > 0);
	    break;

	case 1:				/* large delta negative */
	    do{
		*Address1-- = 1;
		if(error > 0){
		    *Address2++ = 1;
		    error += 2*(smdelta-lgdelta);
		}
		else
		    error += 2*smdelta;
/* debug
                printf("Quad 2:present lgd, smd are %d %d\t"
                   ,((int)Address1&0x7ff)>>1, ((int)Address2&0x7ff)>>1);
                printf("i:%d e:%d\n",i,error);
 end debug */
	    } while( --i > 0);
	    break;

	case 3:				/* both deltas negative */
	    do{
		*Address1-- = 1;
		if(error > 0){
		    *Address2-- = 1;
		    error += 2*(smdelta-lgdelta);
		}
		else
		    error += 2*smdelta;
/* debug
                printf("Quad 3:present lgd, smd are %d %d\t"
                   ,((int)Address1&0x7ff)>>1, ((int)Address2&0x7ff)>>1);
                printf("i:%d e:%d\n",i,error);
 end debug */
	    } while( --i > 0);
	    break;

	} /* end of switch */
}

sgn(x)
    int	x;
{
	return( x<0 );
}
