/*
 * get.c - RasterGet SUN graphics primitive
 *
 * This is the function to get a raster from the framebuffer into memory
 *
 * Written by David J. Brown 1981
 *
 * Fixed (well almost) by Bill Nowicki May 1982
 *	- removed debug definition
 *	- added GXsource in Y_Address during readback
 *	- Fixed bug in pipeline setup
 * 
 * Carried through the fix for pipelining (changed from
 * use of i, to j
 *
 */

#include <rasterops.h>
#include <framebuf.h>

RasterGet(dst, src)
    struct mem_raster	*dst;
    struct fb_raster	*src;
{
    register short	h = src->height,		/* d7, d6 */
			w = src->width;

    register short	*Mem = dst->start;		/* a5 */

    register short					/* a4, a3 */
	*Y_Address =
	    (short *)(GXBase|GXsource|GXselectY+((src->y)<<1)),
	*X_Address =
	    (short *)(GXBase|GXselectX+((src->x)<<1));

    register		i,j;		/* d5, d4 */

	/* Precompute iteration for both the x and y loops */
	GXwidth = 16;
	for (i=w>>4 ; i>0 ; i--)
	  {
#ifdef debug
	printf(" about to do inner loop x = %d, y = %d\n",
		(int)(X_Address)>>1&0x3ff, (int)(Y_Address)>>1&0x3ff);
#endif
	    *X_Address = j;		/* setup x address in framebuf */
	    j = *Y_Address++;		/* and start the pipe with one read */

	    for (j=h ; j>0 ; j--) *Mem++ = *Y_Address++;
	    Y_Address -= h+1;
	    X_Address += 16;
	  }

	/* if there was any leftover width perform one special iteration */
	if (w &= 0xF){
	    GXwidth = w;		/* set a narrower width */
	    *X_Address = j;		/* set the X address in FB */
	    j = *Y_Address++;		/* and start pipe with one read */
	    for (j=h ; j>0 ; j--) *Mem++ = *Y_Address++;
	}
}
