/*
 * graphics/demo.c - A short demonstration of the SUN graphics library.
 *
 * Written by Bill Nowicki July 1982
 */

# include <framebuf.h>
# include <rasterops.h>
# include <lines.h>

struct fb_raster Screen = {1024, 1024, 0, 0},
                 Square = {200, 200, 800, 800 },
                 Place  = {200, 200, 0, 0 };

int GXProbe(), GXBase;

int Coord()
  {
        /*
         * Return a random number between 800 and 1000.
         */
    return( (rand() % 200) + 800 );
  }

main()
  {
     int i;

     GXBase = GXProbe();
     if (GXBase==0) 
       {
         printf("No frame buffer found!\n");
         exit();
       }
      while (1)
        {
                /*
                 * First we clear the screen, then scribble on the
                 * framebuffer out of the visible area.
                 */
          GXfunction = GXclear;
          RasterFill( &Screen );
          GXwidth = 1;
          GXfunction = GXset;
          movea( Coord(), Coord() );
          for (i=0; i<10; i++) 
                  drawa( Coord(), Coord() );

          for (i=0; i<1000; i++)
            {
                /*
                 * Here the pattern is replicated in random places
                 * on the main part of the screen.
                 */
              GXfunction = GXcopy;
              Place.x = rand() % 600;
              Place.y = rand() % 600;
              RasterCopy( &Place, &Square );
            }
        }
  }
