/* LINTLIBRARY */
/*
 * mlookup.c	FOURTH VERSION
 *
 * this is a revision of jks's elookup function that does not
 * use global variables.  When given a numeric name, it merely
 * converts the (assumed) octal host number (Note: NOT "n#h#",
 * just the "h" format is allowed - this is a flaw.)
 * One concession to "globality": the variable PupErrMsg is used
 * for "Human readable error messages".
 *
 * Jeffrey Mogul	22-June-1980	12-Jan-81
 */

#include <puplib.h>
#include <pupstatus.h>
#include <pupconstants.h>
#include <ctype.h>

mlookup (name,RetPort)
char	*name;			/* string name to look up */
struct	Port	*RetPort;	/* Host/Net/Socket returned */
{	/* */
	struct	Port lookport;
	char	swapbuf[MAXPUPDATALEN];		/* used for byteswapping name */
	char	buf[100];			/* for returned data */
	int	buflen;
	int dummy;

#ifdef VAX
	if (isdigit(name[0])) {		/* name is numeric, convert directly */
		RetPort->net = 0;
		sscanf (name, "%o", &RetPort->host);
		RetPort->socket = 0;
		return (OK);
	} else
#endif VAX
		 {			/* let misc-services do it */


		/*
		 * set up destination port for lookup request.
		 */
		lookport.host = 0;
		lookport.net = 0;
		lookport.socket = MISCSERVICES;

		movestring(name, swapbuf, strlen(name)+1);

		switch ( dummy=(int) mscsrvreq(&lookport, swapbuf, strlen(name),
					buf, &buflen, NAMEREQ, 10))
			{

		case NAMERESP:
			PortUnpack((struct packedPort*)buf,RetPort);
/*			RetPort->net = *((Net *) &buf[1]);
			RetPort->host = *((Host *) &buf[0]);
			RetPort->socket = getlong(*((Socket *) &buf[2])); */
			return (OK);

		case LOOKUPERR:
			movestring(buf,PupErrMsg,buflen);
			PupErrMsg[buflen] = 0;	/* null-terminate string */
			return (NOTFOUND);

		case NOCHAN:
			return(NOCHAN);
		
		case TIMEOUT:
		default:	/* something rotten */
			return (TIMEOUT);
		}
	}
}
