/*
 * vprint.c - decode and print a V kernel packet
 *
 * Bill Nowicki September 1982
 *
 * Copyright (c) 1982 Stanford University
 *
 * This source code can be copied ONLY if all changes and improvements
 * are promptly sent to the Author.
 */

# include <Venviron.h>

# define ENET3MEG 1

# include <Vikc.h>

	/*
	 * The !$^&%#@ include files are incompatible!
	 */
# undef EOF
# undef FILE
# undef getc
# undef putc
# undef getchar
# undef putchar
# define fopen foo
# define freopen bar

# include <stdio.h>

extern int PrintData;

char *Pid(p)
  {
  	/*
	 * returns a readable version of the pid
	 */
    static char temp[256];
    int host = (p >> 24) & 0xFF;
    int generation = (p >> 16) & 0xFF;
    int smallPid = p & 0xFFFF;
    
    if (p==0) return("(none)");
    
    if (host || generation)
      sprintf( temp, "0%o-%02x-", host, generation);
    else
      strcpy( temp, "" );

    switch (smallPid)
      {
	case ACTIVE_PROCESS:	strcat(temp,"Active process"); break;
	case EXCEPTION_SERVER:	strcat(temp,"Exception server"); break;
	case DEVICE_SERVER:	strcat(temp,"Device server"); break;
	case INTERNET_SERVER:	strcat(temp,"Internet server"); break;
	case STORAGE_SERVER:	strcat(temp,"Storage server"); break;
	case UNIX_SERVER:	strcat(temp,"Unix server"); break;
	case TIME_SERVER:	strcat(temp,"Time server"); break;
	case PRINT_SERVER:	strcat(temp,"Print server"); break;
	case VGT_SERVER:	strcat(temp,"Vgt server"); break;
	case NAME_SERVER:	strcat(temp,"Name server"); break;
	case CONTEXT_SERVER:	strcat(temp,"Context server"); break;
	case TEAM_SERVER:	strcat(temp,"Team server"); break;
	case PIPE_SERVER:	strcat(temp,"Pipe server"); break;
	case KERNEL_PROCESS:	strcat(temp,"Kernel process"); break;
	case HOST_SERVER:	strcat(temp,"Host server"); break;
	default:		sprintf( temp, "%s%04x", temp, smallPid  );
      }
    return(temp);
  }

VPrint( buf, out, count)
  short *buf;
  FILE *out;
  int count;
  {
    register kPacketWithSegment *p = (kPacketWithSegment *)buf;
    char *PrintVType();
    register int i;

    fprintf( out, "V kernel Packet: %s\n", 
    	PrintVType(p->packetType) );
    fprintf( out, 
        "Source Pid %s, ",
    	Pid(p->srcPid) );
    fprintf( out, 
        "Destination Pid %s\n",
    	    Pid(p->dstPid) );
    fprintf( out, 
        "Forwarder Pid %s, Sequence Number %d\n",
    	    Pid(p->forwarder), p->sequenceNo );
    fprintf( out, 
        "User Number %d, ", p->userNumber );
   
    fprintf( out, "Length %d, Local Addr. 0x%x, Remote Addr. 0x%x\n",
    	p->length, p->localaddress, p->remoteaddress );
    if ((p->packetType >= remoteSend) && (p->packetType <= remoteForward))
      fprintf( out, "Msg: %x %x %x %x %x %x %x %x (%s)\n",
        p->msg[0], p->msg[1], p->msg[2], p->msg[3],
        p->msg[4], p->msg[5], p->msg[6], p->msg[7],
	ErrorString( p->msg[0]>>16 ) );

    count *= 2;
    if (count<64) 
      fprintf(out,"** Packet too small, only %d bytes **\n", count);
    count -= 64;
    if (count>0) 
      fprintf(out,"%d bytes of data\n", count);
    if (((p->packetType == remoteMoveFromReply) ||
         (p->packetType == remoteMoveToReq)) && PrintData) 
      {
        fprintf( out, "Data :\n");
        for(i=0;i<p->length;i++) 
	  {
            if ((i%16) == 15) fprintf( out,"\n");
            fprintf( out, " %02x", p->data[i] & 0xFF );
	  }
      }
  }


static char *PrintVType(kind)
  {
    static char temp[256];
    
    switch (kind)
      {
	case remoteSend:		return( "Send");
	case remoteReply:		return( "Reply");
	case remoteForward:		return( "Forward");
	case remoteReceiveSpecific:	return( "Receive Specific");
	case breathOfLife:		return( "Breath Of Life");
	case remoteGetPid:		return( "GetPid");
	case remoteGetPidReply:		return( "GetPid Reply");
	case remoteMoveFromReq:		return( "Move From Request");
	case remoteMoveFromReply:	return( "Move From Reply");
	case remoteMoveToReq:		return( "Move To Request");
	case remoteMoveToReply:		return( "Move To Reply");
	case nAck:			return( "nAck");
      }
    sprintf( temp, "Unknown Type (0%o)", kind&0xFFFF);
  }
