/*
 * ipwatch.c - record data on Internet Datagrams
 *
 * Bill Nowicki September 1983
 *
 * Copyright (c) 1983 Stanford University
 *
 * This source code can be copied ONLY if all changes and improvements
 * are promptly sent back to the Author.
 *
 * This is the 10Mbit version, which can be linked to
 * any of the available drivers, such as ExceLan or 3Com.
 */

# define fopen foo
# define freopen bar
# define ENET10MEG

# include <Venviron.h>
# include "ip.h"
# include "ikc.h"
# include "xns.h"

# undef getc
# undef putc
# undef getchar
# undef putchar
# undef FILE
# undef ETHERNET
# undef EOF
# undef fopen
# undef freopen
# undef stdin
# undef stdout
# undef stderr

# include <stdio.h>
# include <puplib.h>
# include <pupconstants.h>

# define MaxBuffers 128		/* number of Network buffers */
# define BufferSize 1024	/* size in bytes of each buffer */

char FileName[256];		/* name of file to write */

char Buffers[MaxBuffers] [BufferSize];

/*
 * Within each buffer, things are organized as follows:
 *
 * Shorts 0, 1		Time in ms. from start
 * Short 2		Status word
 * Short 3		Length in bytes
 * Shorts 4-6		Ethernet Source
 * Shorts 7-9		Ethernet Destination
 * Short 10		Ethernet packet type
 * Short 11-end		Rest of packet
 */

int FirstBuffer = 0;		/* index of firrst buffer */
int LastBuffer = 0;		/* index of next usable buffer */

int TickFlag = 1;		/* print exclamation on each packet */
int PupFlag = 1;		/* listen to PUPs */
int IPFlag = 1;			/* listen to IPs */
int VFlag = 1;			/* listen to V kernel packets */
int XNSFlag = 1;		/* listen to XNS packets */
int OtherFlag = 0;		/* listen to other random types */
int OrFlag = 0;			/* OR source and dest filters instead of AND */
int PrintData = 0;		/* do not print data in packets */
int StartTime = 0;		/* emt_ticks when we started */
int HitFlag;			/* a key was hit */

unsigned char SourceFilter[256];/* software source filter */
unsigned char DestFilter[256];	/* hardware destination filter */

char *PrintAddress();

ReadPacket()
  {
    /*
     * Read a packet into the next buffer.
     * returns true if we one matched the filter.
     */
     
    register short *buf = (short *)Buffers[LastBuffer];
    register short count;
    short *end = (short *)(Buffers[LastBuffer+1]);
    short blackHole;

    while (!EtherReady())
        if (KeyHit()) return(0);

    buf = (short *)Buffers[LastBuffer];
    *(int *)buf = emt_ticks() - StartTime;
    buf += 2;

    EtherRead( buf );
      	/*
	 * check that the sending host is in our software filter
	 * (some day)
	 */
    buf += 8;
      /*
       * now we have read the packet, throw away Ethernet types
       * that we do not want.
       */
    switch (*buf)
      {
        case PUP:	if (!PupFlag)	return(0);	break;
        case IP:	if (!IPFlag)	return(0);	break;
        case XNS:	if (!XNSFlag)	return(0);	break;
        case PupToNS:	if (!PupFlag)	return(0);	break;
	case KERNEL_PACKET:
	case NEW_KERNEL_PACKET:
			if (!VFlag)	return(0);	break;
	default:	if (!OtherFlag)	return(0);
      }

    LastBuffer++;
    if (LastBuffer>=MaxBuffers) LastBuffer %= MaxBuffers;
    if (LastBuffer==FirstBuffer) 
      {
        FirstBuffer++;
	FirstBuffer %= MaxBuffers;
      }
    if (TickFlag) printf("!");
    return(1);
  }


WriteToFile(name)
 char *name;
  {
    /*
     * write the accumulated buffers to the indicated file name
     */
    FILE *out;
    out = fopen( name, "w" );
    if (out==NULL)
      {
        printf( "Unable to open %s for output\n", name );
        return;
      }
    while (FirstBuffer!=LastBuffer)
      {
        PrintBuffer( Buffers[FirstBuffer], out );
	printf(".");
        FirstBuffer++;
	FirstBuffer %= MaxBuffers;
      }
    fclose(out);
  }


PrintBuffer( buf, out )
 register short *buf;
  {
    /*
     * Decode and print the buffer indicated on the
     * given file.
     */
    short rxStatus;
    short *source, *dest;
    int count;
    
    fprintf( out, "\n%d.%02d ",
    	(*(int *)buf)/1000, ( (*(int *)buf)/10)%100 );
    buf += 2;
    rxStatus = *buf++;
    count = *buf++ / 2;
    dest = buf;
    buf += 3;
    count -= 3;
    source = buf;
    buf += 3;
    count -= 3;

    fprintf( out, "[%s --> ", PrintAddress(source));
    fprintf( out, "%s] ", PrintAddress(dest) );

    if ( EtherBadStatus(rxStatus) )
    	fprintf( out, "Ethernet Status: %s", PrintEtherStatus(rxStatus) );

    if   (*buf != PUP && *buf != IP && *buf != XNS && *buf != PupToNS &&
	  *buf != KERNEL_PACKET && *buf != NEW_KERNEL_PACKET ) 
      {
	int i = 0;

	if (!PrintData && count > 16) count = 16;
	while (++i < count)
	    {
	      if (i % 16 == 0) fprintf( out, "\n");
	      fprintf( out, " %04x", *buf++ & 0xFFFF );
	    }
	fprintf( out, "\n");
	return;
      }

    if (*buf == PUP) 			PupPrint( ++buf, out, count);
    if (*buf == XNS) 			XNSPrint( ++buf, out, count);
    if (*buf == PupToNS) 		PupToNSPrint( ++buf, out, count);
    if (*buf == IP)  			IPPrint(  ++buf, out, count);
    if (*buf == KERNEL_PACKET)  	VPrint(  ++buf, out, count);
    if (*buf == NEW_KERNEL_PACKET)  	xVPrint(  ++buf, out, count);
   }


HostSpecify()
  {
	/*
	 * specify hosts to watch
	 */
    register short host;
    int inputHost;

    while (1)
      {
        printf("\n Host specification\n");
	if (OrFlag)
	      printf("c - Conjuctive mode - Currently OR (Disjuctive mode)\n");
	 else
	      printf("o - OR (Disjuctive) mode - Currently AND (Conjuctive mode)\n");
	printf("e - Look at Everybody\n");
	printf("2 - Look at two hosts\n");
	printf("n - Look at nobody\n");
	printf("a - Add host to filter\n");
	printf("d - Delete host from filter\n");
	printf("p - Print out filters\n");
	printf("Return or space goes back to main menu\n");
	
	printf("Enter suboption: ");
	switch(getchar())
	  {
	    case 'e':
	        printf("\nSelecting EVERYbody\n");
    		for (host=0; host<256; host++)
		  {
        	    SourceFilter[host] = 1;
		    DestFilter[host] = 1;
		  }
		break;
		
	    case 'n':
	        printf("\nSelecting Nobody\n");
    		for (host=0; host<256; host++)
		  {
        	    SourceFilter[host] = 0;
		    DestFilter[host] = 0;
		  }
		break;
		
		
	    case 'a':
	        printf("\nAdd host (octal):");
		scanf( "%o", &inputHost );
        	SourceFilter[inputHost] = 1;
		DestFilter[inputHost] = 1;
		break;		
		

	    case 'o':
	        printf("\nOR mode, or disjuctive,  source OR dest\n");
		OrFlag = 1;
		break;
		

	    case 'c':
	        printf("\nAND mode, or conjuctive, source AND dest\n");
		OrFlag = 0;
		break;

	    case 'd':
	        printf("\nDelete host (octal):");
	        fflush(stdin);
		scanf( "%o", &inputHost );
        	SourceFilter[inputHost] = 0;
		DestFilter[inputHost] = 0;
		break;		
		
	    case '2':
	        printf("\nSelecting Two hosts (and nobody else!)\n");
    		for (host=0; host<256; host++)
		  {
        	    SourceFilter[host] = 0;
		    DestFilter[host] = 0;
		  }
	        printf("First host (octal):");
		scanf( "%o", &inputHost );
        	SourceFilter[inputHost] = 1;
		DestFilter[inputHost] = 1;
	        printf("Second host (octal):");
		scanf( "%o", &inputHost );
        	SourceFilter[inputHost] = 1;
		DestFilter[inputHost] = 1;
		break;		
		
	    case 'p':
	        printf("\nReceiving packets from: ");
    		for (host=0; host<256; host++)
        	    if (SourceFilter[host]) printf("0%o ", host);
		printf("\n %s to: ", OrFlag ? "OR" : "AND");
    		for (host=0; host<256; host++)
        	    if (DestFilter[host]) printf("0%o ", host);
		printf("\n");
		break;
	    
	    case ' ':
	    case '\n':
	    case '\r':
	        printf( "\nBack to main menu\n");
	    	return;

    
	    default:
	        printf("\nUnknown option!\n");
		break;
	  }
      }
    
  }

main()
  {
    register short host;
    extern int sp;		/* stack pointer */
    short myAddress[3];

    sp = emt_getmemsize()-4;
    for (host=0; host<256; host++)
      {
        SourceFilter[host] = 1;
	DestFilter[host] = 1;
      }
    EtherInit(myAddress);
    putchar('\f');
    while (1)
      {
	 printf("\n%s Watch Version 2.0 (local Ethernet address is %s)\n",
		EtherKind(), PrintAddress(myAddress) );
	
if (PupFlag)	printf("p - Ignore PUP packets (currently printing)\n");
else		printf("p - Print PUP packets (currently ignoring)\n");
if (IPFlag)	printf("i - Ignore IP packets (currently printing)\n");
else		printf("i - Print IP packets (currently ignoring)\n");
if (VFlag)	printf("v - Ignore Vkernel packets (currently printing)\n");
else		printf("v - Print Vkernel packets (currently ignoring)\n");
if (XNSFlag)	printf("x - Ignore XNS packets (currently printing)\n");
else		printf("x - Print XNS packets (currently ignoring)\n");
if (OtherFlag)	printf("o - Ignore other packets (currently printing)\n");
else		printf("o - Print other packets (currently ignoring)\n");
if (PrintData)  printf("d - Do not print packet data (currently printing)\n");
else		printf("d - Print packet all data (curently sumarizing)\n");
if (TickFlag) 	printf("r - No report on packet received (currently on)\n");
else		printf("r - Report ! on packet received (currently silent)\n");

	printf("t - Type out packets on terminal\n");
	printf("h - host specification\n");
	printf("w - write a file\n");
	printf("q - quit the program\n");
        printf("return or space starts reading\n");
	printf("Enter option: ");
	switch (getchar() )
	 {
	  case 'p':
	    if (PupFlag)	printf("\nIgnore PUP packets\n");
	    else		printf("\nPrint PUP packets\n");
	    PupFlag = !PupFlag;
	    break;

	  case 'i':
	    if (IPFlag) 	printf("\nIgnore IP packets\n");
	    else		printf("\nPrint IP packets\n");
	    IPFlag = !IPFlag;
	    break;

	  case 'v':
	    if (VFlag) 	printf("\nIgnore Vkernel packets\n");
	    else		printf("\nPrint Vkernel packets\n");
	    VFlag = !VFlag;
	    break;

	  case 'd':
	    PrintData = !PrintData;
	    break;

	  case 'r':
	    TickFlag = !TickFlag;
	    break;

	  case 'o':
	    if (OtherFlag)	printf("\nIgnore other packets\n");
	    else		printf("\nPrint other packets\n");
	    OtherFlag = !OtherFlag;
	    break;
	    
	  case 'h':
	    HostSpecify();
	    break;

	  case 'q':
	    printf("\nQuit the program\n");
	    exit();

	  case 'w':
	    fflush(stdin);
	    strcpy( FileName, "");
	    if (FirstBuffer==LastBuffer)
	      {
	        printf("\nBuffer is empty -- you must read something first\n");
		continue;
	      }
	    for (; strlen(FileName)==0;)
	      {
	        printf("\nWrite to file:");
	        if (gets(FileName)==NULL) continue;
	      }
	    WriteToFile(FileName);
	    break;

	  case ' ':
	  case '\n':
	  case '\r':
	    EnetSetFilter();
	    printf("\nStarting to read...\n");
	    StartTime = emt_ticks();
	    HitFlag = 0;
            while (!KeyHit()) ReadPacket();
	    EnetNormalFilter();
	    HitFlag = 0;
	    printf("\n");
	    break;

	  case 't':
	    EnetSetFilter();
	    printf("\nStarting to read in immediate mode...\n");
	    StartTime = emt_ticks();
	    HitFlag = 0;
            while (!KeyHit()) 
	      if (ReadPacket() )
		{
	          PrintBuffer( Buffers[FirstBuffer], stdout );
	          FirstBuffer++;
		  FirstBuffer %= MaxBuffers;
		}  
	    EnetNormalFilter();
	    HitFlag=0;
	    printf("\n");
	    break;

	  default:
	    printf( "\nIllegal option!\n");
	    continue;
	 }
      }
    
  }

