/******** Spline stuff ********
 * Intended to be used with the Vgts.
 * David Kaelbling, Per Bothner. April 1983.
 */

enum Pattern    
  {
    PatWhite,
    PatBlack,
    PatGray,
    PatStripeLeft,
    PatBigStripeLeft,
    PatStripeRight,
    PatBigStripeRight,
    PatCrossHatch,
    PatBigCrossHatch,
    PatChainLink,
    PatDots,
    PatCheckers,
    PatSquareDots,
    PatPinwheels,
    PatRoses,
    PatMath,
    PatRug,
    PatDeskTop,
    PatCubes,
    PatWicker,
    PatHerringbone,
    PatTangle,
    PatWeb,
    PatWeave,
    PatTrees,
    PatColumns,
    PatRows,
    PatMatrix,
    PatEnd	/* Not an actual valid pattern */
  };

enum Nib
  {
    NibSquare0,
    NibSquare1,
    NibSquare2,
    NibSquare3,
    NibCircle0,
    NibCircle1,
    NibCircle2,
    NibCircle3,
    NibDash0,
    NibDash1,
    NibDash2,
    NibDash3,
    NibBar0,
    NibBar1,
    NibBar2,
    NibBar3,
    NibEnd	/* Not an actual valid nib */
  };
    
    /* Typical linked list for a data point */
typedef struct
  {
    short x, y;
  } POINT;
 
/* Generic Object Descriptor Block for Splines */
typedef struct
  {
    unsigned short	order;	/* Order of the spline			*/
    unsigned short	numvert;/* Number of vertices present.		*/
    enum Nib		nib;	/* Nib to be used for drawing.		*/
    unsigned short	border;	/* Is the border visible?		*/
    unsigned short	closed;	/* Is this object closed or open?	*/
    unsigned short	filled;	/* Is this object filled?		*/
    unsigned short	opaque;	/* Is the filling opaque (solid)?	*/
    enum Pattern	pat;	/* Fill (stipple) pattern.		*/
    POINT		head;	/* Head of the list of vertices		*/
  } SPLINE;

