/*  Signetics 2651 Programmable Communications Interface Bit Definitions  */

/* Mode register #1 bit definitions */

#define sync1xrate	0
#define async1xrate	1		/* Asynchronous rate factor only  */
#define async16xrate	2		/* applies with external clocks as*/
#define async64xrate	3		/* set in mode register #2.       */

#define dbits5		0
#define dbits6		4
#define dbits7		8
#define dbits8		12

#define prtyoff		0
#define prtyon		16

#define prtyodd		0		/* Only applies when parity is on */
#define prtyeven	32

#define sbits1		64
#define sbits15		(unsigned char)128
#define sbits2		(unsigned char)192


/* Mode register #2 bit definitions */

#define baud50		0		/* Note, internal baud is for both */
#define baud75		1		/* receiver and transmitter.       */
#define baud110		2
#define baud134		3
#define baud150		4
#define baud300		5
#define baud600		6
#define baud1200	7
#define baud1800	8
#define baud2000	9
#define baud2400	10
#define baud3600	11
#define baud4800	12
#define baud7200	13
#define baud9600	14
#define baud19200	15

#define extrxclk	0
#define intrxclk	16
#define exttxclk	0
#define inttxclk	32


/* Command register bit definitions */

#define txdisable	0
#define txenable	1

#define DTRhigh		0
#define DTRlow		2

#define rxenable	4
#define rxdisable	0

#define breakoff	0
#define breakon		8

#define rsterroff	0
#define rsterron	16

#define RTShigh		0
#define RTSlow		32

#define modenormal	0
#define modeecho	64
#define modelocalloop	(unsigned char)128
#define moderemoteloop	(unsigned char)192


/* Status register bit definitions */

#define txready		(unsigned char)1
#define rxready		(unsigned char)2
#define txempty		(unsigned char)4
#define prtyerror	(unsigned char)8
#define ovrrnerror	(unsigned char)16
#define frmerror	(unsigned char)32
#define DCDstatus	(unsigned char)64
#define DSRstatus	(unsigned char)128




/*  The Signetics 2651 programable communications interface (PCI) is used
in the CDC Octal Serial Boards.  The PCIs are designed to be used in the
asynchronous mode with internal baud rate generation.  For most applications
the CTS' and RTS' RS232C lines are not used and the boards set for internal
generation of these signals.  Thus to program the 2651 to be compatible with
the 68000 design module ACIAs and terminals:

	Mode Register 1 = async16xrate + dbits8 + prtyoff + sbit1
	Mode Register 2 = inttxclk + intrxclk + baud9600
	Command Register = txenable + rxenable + RTSlow + DTRlow

*/
