/*
 * m68enet.h
 *
 * header file for MC68000 Ethernet Interface 
 *
 *	Sun board version
 *
 * Jeffrey Mogul @ Stanford	17 March 1981
 *
 * stolen from code written by Mike Nielsen
 * updated by Bill Nowicki March 5, 1981
 * 	   by Jeff Mogul 21 April 1981
 */

#include <pcmap.h>

 /*
  * Addresses of the Ethernet Interface registers on the Multibus 
  */

/* These are in the "standard" multibus I/O space, which
 * starts at 0x1F0000; they are defined non-symbolically for
 * efficiency
 */
#define EIUnitOBase	(IOLOWADR+0x100)

/*#define EIData0	*(short*)(EIUnit0Base) */
#define EIData0		*(short*)0x1F0100
/*#define EIData1	*(short*)(EIUnit0Base+2) */
#define EIData1		*(short*)0x1F0102
/*#define EIStatus	*(short*)(EIUnit0Base+4) */
#define EIStatus	*(short*)0x1F0104
/*#define EIAddress	*(short*)(EIUnit0Base+6) */
#define EIAddress	*(short*)0x1F0106

 /*
  * Write Status word bits
  * these bits are WRITTEN into EIStatus
  */
#define Init0		0
#define Init1		(128*256)
#define Loopback0	0
#define Loopback1	(64*256)
#define FilterData0	(32*256)
#define FilterData1	0
#define RxIntEnable0	(8*256)
#define RxIntEnable1	0
#define TrIntEnable0	(16*256)
#define TrIntEnable1	0
#define IntEnable0	(24*256)
#define IntEnable1	0
#define IntLevel0	(7*256)
#define IntLevel1	(6*256)
#define IntLevel2	(5*256)


/*
 * Receiver status word fields 
 * these bits are READ from EIdata0
 * note that you must keep reading until the QueueEmpty bit is off.
 */
#define QueueEmptyBit  	0x8000	
#define OverflowBit	0x4000
#define CollisionBit	0x2000
#define CRCerrorBit	0x1000
#define CountMask	0x0FFF

 /* 
  * Transmitter status word bit assignments
  * these bits are READ from EIStatus
  */
#define TSent		0x8000
#define TimeoutBit	0x4000
#define RxRcvd		0x2000	/* means: queue is not empty */
#define EIDone		0x1000	/* means: TSent|RxRcvd */

