/*
 * Useful definitions for the M6840 timer module
 * on the design module
 *
 * based on a similar file by Vaughan Pratt
 * Bill Nowicki March 5, 1981
 *
 */

#define M6840

 /*
  * The following bits are located in control register 2,
  * PTMStatus
  */
#define CR3Sel		0
#define CR1Sel		1

 /*
  * The following bits apply to all timers,
  * i.e. written into PTM13Control or PTMStatus
  */
#define ExtClock	0
#define IntClock	2

#define DualByte	4

#define PTMInterruptEnable 64

 /*
  * Following is for timer #1 only (PTM13Control)
  */
#define Freeze		1

 /*
  * Following is for timer #3 only (PTM13Control)
  */
#define T3Div8		1

 
