/* Definitions needed to use the W window package */

#ifndef WENVIRON
#define WENVIRON

typedef unsigned Window;
typedef unsigned Font;
typedef unsigned Raster;
typedef unsigned Pattern;
typedef unsigned Item;
typedef unsigned short WCode;

typedef struct _WMsg {
	WCode code;
	unsigned short options;
	Window windowId;
	union {
	    long l[6];
	    short s[12];
	} param;
} WMsg;

/* The information you get back when you query a window */

typedef struct _WindowInfo {
	short height, width, x, y;
	short contents_type;
	short mapped;
	ProcessId owner, user;
	Window parent;
	short numLines, lineLength;	/* If appropriate */
	Font font;			/* Also if appropriate */
	short numChildren;
	Window child[1];		/* May actually be many more */
} WindowInfo;

/* Define the window modes */

#define W_EmptyMode	0
#define W_DumbMode	1
#define W_PadMode	2
#define W_TransMode	3
#define W_GraphicsMode	4

/* And now, a review of the meanings of the first 9 bits of a message:
 *	0 (8--)	0 if request, 1 if reply
 *	1 (4--)	0; these are not standard system calls
 *	2 (2--)	1 if idempotent
 *	3 (1--)	1 if request specifies a segment
 *	4 (-8-)	1 if read access allowed to segment
 *	5 (-4-)	1 if write access allowed to segment
 *	6 (-2-)	1 if the request must be done by the owner of the window
 *	7 (-1-)	1 if the request must be done by the user of the window
 *	8 (--8)	1 iff the windowId must be NULL
 */

/* These are the request codes that apply to all types of windows */

#define W_OpenWindow		0x0101
#define W_MapWindow		0x0202
#define W_UnmapWindow		0x0203
#define W_MoveWindow		0x2204
#define W_ChangeWindow		0x2205
#define W_DestroyWindow		0x0206
#define W_StoreWindow		0x0207
#define W_RecoverWindow		0x0208
#define W_ZoomWindow		0x0209
#define W_QueryWindow		0x340A
#define W_RaiseWindow		0x220B
#define W_LowerWindow		0x220C
#define W_CircWindow		0x010D
#define W_ChangeUser		0x220E
#define W_Redraw		0x000F

/* Request codes dealing with the mouse */

#define W_RegisterMouse 	0x0140
#define W_UnregisterMouse	0x0141
#define W_QueryMouse		0x0142
#define W_GetMouseEvent		0x0143

/* Mouse Event Codes */

#define NoEvent		0x00
#define LeftButton	0x01
#define RightButton	0x02
#define MiddleButton	0x04
#define EnterWindow	0x08
#define LeaveWindow	0x10

/* Event detail codes */

#define ButtonPressed		0x01	/* Mutually exclusive with Release */
#define ButtonReleased		0x02	/* Mutually exclusive with Press */
#define ControlIsDown		0x04	/* Only for button events */
#define ShiftIsDown		0x08	/* Only for button events */
#define IntoOrFromSubwindow	0x10	/* Only for enter/leave events */

typedef struct _MouseEvent {
	short x, y, eventType, eventDetails;
	unsigned long timeStamp;
	Window subWindow;
} MouseEvent;

/* These are the reply codes */

#define W_OK			0x8000
#define W_NoSuchWindow		0x8001
#define W_NullWindow		0x8002
#define W_NotYourWindow		0x8003
#define W_UnknownOption		0x8004
#define W_UnmappedWindow	0x8005
#define W_MappedWindow		0x8006
#define W_ParameterError	0x8007
#define W_NoStorage		0x8008
#define W_Unimplemented		0x8009
#define W_UnknownRequest	0x800A
#define W_FontError		0x800B
#define W_CantOpenFont		0x800C
#define W_BadFont		0x800D
#define W_WrongType		0x800E
#define W_StringTooLong		0x800F
#define W_UnmappedParent	0x8010
#define W_CantDoThatNow		0x8011
#define W_NotAnItem		0x8012
#define W_Error			0x8013
#define W_MouseError		0x8014
#define W_Timeout		0x8015
#define W_NoEvents		0x8016
#define W_CursorError		0x8017

/* Now define the more specific request types */

/* Codes for getting fonts, patterns, etc.  These are the only codes for
 * which a windowId of NULL is valid.  The 0x0080 bit must be on.
 */

#define W_SetUp			0x0080
#define W_GetFont		0x3881
#define W_StoreRaster		0x1882
#define W_StorePattern		0x1883
#define W_FreeRasterOrPattern	0x1884

/* For Dumb tty windows: */

#define W_PutChar		0x0120
#define W_PutString		0x1921
#define W_PutShortString	0x0122

/* For Transparent graphics windows */

#define W_Clear			0x0130
#define W_RasterFill		0x0131
#define W_RasterPut		0x0132
#define W_RasterPattern		0x0133
#define W_Line			0x0134
#define W_ShortText		0x0135
#define W_Text			0x1936
#define W_Undo			0x0137
#define W_Redo			0x0138

#endif
