/*
 * Distributed V Kernel - Copyright (c) 1982 by David Cheriton, Willy Zwaenepoel
 *
 *  Manifests and constants relating to V Interkernel Protocol.
 */

#ifndef VIKCDEF
#define VIKCDEF

#include <Venviron.h>

/* Random constants */

#define MAX_RETRANSMISSIONS	3

#ifndef KERNEL_PACKET /* Default kernel packet type for Ethernet */
#define KERNEL_PACKET		V_KERNEL_PACKET		/* Use V version */
#define V_KERNEL_PACKET		0320			/* V version */
#define XV_KERNEL_PACKET	0323			/* xV version */
#endif KERNEL_PACKET

/* V kernel Packet types */

#define remoteSend		1
#define remoteReply		2
#define remoteForward		3
#define remoteReceiveSpecific	4
#define breathOfLife		5
#define remoteGetPid		6
#define remoteGetPidReply	7
#define remoteMoveFromReq	8
#define remoteMoveFromReply	9
#define remoteMoveToReq		10
#define remoteMoveToReply	11
#define nAck			12


/* Packet definition */

typedef struct
  {
    unsigned short	packetType;
    unsigned short	sequenceNo;
    Process_id		srcPid;
    Process_id		dstPid;
    Process_id		forwarder;
    unsigned 		userNumber;
    unsigned		length;
    Unspec		*localaddress;	/* local always refers to the sender */
    Unspec		*remoteaddress;
    Message		msg;
    unsigned char	data[MAX_APPENDED_SEGMENT]; /* data for movefrom moveto */
  } kPacketWithSegment;


typedef struct
  {
    unsigned short	packetType;
    unsigned short	sequenceNo;
    Process_id		srcPid;
    Process_id		dstPid;
    Process_id		forwarder;
    unsigned		userNumber;
    unsigned		length;
    Unspec		*localaddress;	/* local always refers to the sender */
    Unspec		*remoteaddress;
    Message		msg;
  } kPacket;

#endif
