/********************************************************/
/*							*/
/*	  Virtual Graphics Terminal Server		*/
/*							*/
/*		(C) COPYRIGHT 1982			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*							*/
/********************************************************/

/*
 * FILE: Vgts.h
 *
 * This file contains all the public definitions which pertain to the 
 * SUN Virtual Graphics Terminal Service package.
 */


/*
 * General definitions
 */

typedef unsigned char BOOLEAN;
#define TRUE 1
#define FALSE 0

#define ERROR -1
#define NIL 0

#ifndef NULL
#define NULL	0
#endif  NULL

#define max(A,B) ((A) > (B) ? (A) : (B))
#define min(A,B) ((A) < (B) ? (A) : (B))

/*
 * Types of items in the sdf
 */

#define SDF_SYMBOL_CALL 1
#define SDF_SYMBOL_DEF 2
#define SDF_FILLED_RECTANGLE 3
#define SDF_HORIZONTAL_LINE 4
#define SDF_VERTICAL_LINE 5
#define SDF_POINT 6
#define SDF_SIMPLE_TEXT 7
#define SDF_GENERAL_LINE 8
#define SDF_OUTLINE 9		
#define SDF_HORIZONTAL_REF 10	
#define SDF_VERTICAL_REF 11	
#define SDF_SEL_HORIZ_REF 12	
#define SDF_SEL_VERT_REF 13
#define SDF_TEXT 14
#define SDF_RASTER 15
#define SDF_SPLINE 16

  /*
   * Maximum Coordinate value for SDF Items
   */

#define MaxCoord 32767	

/*
 * This bits go into type data field for Outline items
 */

#define LeftEdge 1
#define RightEdge 2
#define TopEdge 4
#define BottomEdge 8

#define AllEdges (LeftEdge+RightEdge+TopEdge+BottomEdge)


/*
 * values of type data field for Filled Rectangles
 */
#define NM 0	/* Metal */
#define NP 1	/* PolySilicon */
#define ND 2	/* Diffusion */
#define NI 3	/* Ion Implant */
#define NC 4	/* contact cut */
#define NB 5	/* Burried contact */
#define NG 6	/* OverGlass cut */
#define NDP 7	/* What are these??? - WIN */
#define NMP 8
#define NDM 9
#define ZZ 10
#define BLACK 11	/* solid black */
#define GRAY 12		/* half-tone gray */
#define HILIGHT 13	/* unselectable highlights */

/*
 * bits for graphics input buttons
 */

#define LeftButton 1
#define MiddleButton 4
#define RightButton 2

/* VGT usage-type bits */

#define UNUSED 0		/* initial value */
#define GRAPHICS 1		/* normal graphics display */
#define TTY 2			/* allow pad operations */
#define ZOOMABLE 4		/* Allow users to zoom it */

typedef struct
	/* Descriptor for a popup menu display entry. */
    {
    char *string;		/* String to display. */
    unsigned char menuNumber;	/* Number returned if entry selected. */
    } PopUpEntry;


/***** mouse stuff ********/

typedef struct MinElement
  {
    short		      item;	/* an sdf item name */
    short		      edgeset;	/* for rectangles only -- TRD */
    struct MinElement        *next;
  } MINREC, *MINPTR;

typedef struct ListInfo
  {
    MINPTR            Header;
    short             NumOfElements;
  } LISTTYPE;

/********** Search Types ***************/

#define All         0
#define AllLines    1
#define JustHoriz   2
#define JustVerts   3
#define JustRects   4
#define JustSymbols 5
#define JustText    6
#define JustRefPt   7
#define JustSplines 8

/*
 * Message types for linked-together programs.
 * Warning: Clients should not depend on these!
 */

typedef struct EventMsg
  {
  	/*
	 * Message format for event requests
	 * and replies
	 */
    short requestcode;
    short fileid;
    short eventcode;
    short x, y, buttons;
    short padding[10];
  } EventReq;


struct ModifyMsg
  {
  	/*
	 * Message format for Modify requests
	 */
    short requestcode;
    short fileid;
    int mode;
    short lines, columns;
    short padding[10];
  };

# define CR_Input 1		/* change CR to LF on input */
# define LF_Output 2		/* change LF to CRLF on output */
# define Echo 4			/* echo input characters */
# define LineBuffer 8		/* Buffer up each line before returning */
# define ReportClick 16		/* report clicks for graphics events */
# define ReportTransition 32	/* report all transitions on buttons */
# define ReportEscSeq 64	/* use "Emacs hack" escape sequences */
# define NoCursor 128		/* no cursor in this pad */
# define ReportMotion 256	/* report any kind of motion */
# define ReportCharacter 512	/* report character events */

/*
 * note that ReportClick and ReportTransition, being mode bits on a VGT,
 * are also members of the set:
 * { ReportCharacter, ReportClick, ReportTransition }
 * of event codes.
 */

# define PadWidth 80		/* default columns in a pad */
# define PadHeight 28	
				/* default size of TTY views */
# define ViewWidth(columns) ( (columns+1)*8+10)
# define ViewHeight(lines) (lines*16+24)

	/*
	 * request codes for message interface
	 */

# define SetBannerRequest 0x3800	
# define SwitchInput 0x2001
# define EventRequest 0x2002
# define RedrawRequest 0x2003
# define LineEditRequest 0x3804
