/*
 * V Kernel - Copyright (c) 1982 by David Cheriton
 * (Transliterated from Zed and Verex Kernel)
 *
 * Vkernel Environment manifests and types.
 */

#ifndef VENVIRON

#define VENVIRON

typedef long Message[8];
typedef unsigned long ProcessId;
typedef unsigned long ContextId;

#define Process_id	ProcessId /* Temporary kludge */

#define	OK		0	/* no error */
#define NULL	0
#define MAXUNSIGNED	(0-1)
#define MSG_SIZE	(8*sizeof(long)) /* Size in bytes of a message */
#define MAX_APPENDED_SEGMENT 1024  /* Maximum amount of data from segment
				    * appended to a send or reply message. */
#define REMOTE_ALIAS_PROCESS	0x8000	/* Bit indicating a remote alias */

/* Indexes in messages and masks used for segment definitions */

#define OPCODE_INDEX		0
#define SEGMENTPTR_INDEX	6
#define SEGMENTSIZE_INDEX	7

#define IDEMPOTENT_MASK		0x20000000
#define SEGMENT_MASK		0x10000000
#define READ_MASK		0x08000000
#define WRITE_MASK		0x04000000

/* Scopes for GetPid and SetPid */
#define	LOCAL_PID		2
#define REMOTE_PID		1
#define ANY_PID			0

/* Logical Id's for GetPid and SetPid */

#define ACTIVE_PROCESS		0
#define EXCEPTION_SERVER	1
#define DEVICE_SERVER		2
#define INTERNET_SERVER		3
#define STORAGE_SERVER		4
#define UNIX_SERVER		5
#define TIME_SERVER		6
#define PRINT_SERVER		7
#define VGT_SERVER		8
#define NAME_SERVER		9
#define CONTEXT_SERVER		10
#define TEAM_SERVER		11
#define PIPE_SERVER		12
#define KERNEL_PROCESS		13
#define HOST_SERVER		14
#define VSTORAGE_SERVER		15
#define VMS_SERVER		16

/* Dummy definitions for kernel operations 
long GetTime();
char *GetTeamSize();
char *SetTeamSize();				*/

/* Standard system reply and request codes.
 * These are designed to fit into 16 bits. The high-order 2 bits
 * flag these as system codes and indicate if a request or a reply
 * code. Only the low-order 8-bits are considered significant in reply codes
 * for generic error reporting. The remaining 6 bits can freely be used
 * to encode server-specific information.
 * Application-specific request and reply codes should be values with the
 * 16-th bit turned off.
 */
typedef unsigned short SystemCode;

#define SYSTEM_CODE		0x4000
#define SYS_REPLY_CODE		0xC000	/* Else a reply code */

/* Standard system reply codes: returned as error reports and return
 * codes by reply messages from system processes.
 */
#define ILLEGAL_REQUEST		0xC001
#define NO_REPLY		0xC002
#define RETRY			0xC003
#define BAD_ARGS		0xC004
#define BAD_ADDRESS		0xC005
#define BAD_BUFFER		0xC006
#define NO_SERVER_RESOURCES	0xC007
#define NO_MEMORY		0xC008
#define NO_PERMISSION		0xC009
#define POWER_FAILURE		0xC00A
#define NOT_FOUND		0xC00B
#define BUSY			0xC00C
#define TIMEOUT			0xC00D
#define BAD_STATE		0xC00E
#define ABORTED			0xC00F
#define NONEXISTENT_PROCESS	0xC010
#define NOT_AWAITINGREPLY	0xC011
#define BAD_PROCESS_PRIORITY	0xC012
#define NO_PDS			0xC013
#define INVALID_FILE_ID		0xC014
#define NOT_READABLE		0xC015
#define NOT_WRITEABLE		0xC016
#define END_OF_FILE		0xC017
#define INVALID_MODE		0xC018
#define MODE_NOT_SUPPORTED	0xC019
#define BAD_BYTE_COUNT		0xC01A
#define BAD_BLOCK_NO		0xC01B
#define IO_BREAK		0xC01C
#define INTERNAL_ERROR		0xC01D
#define DEVICE_ERROR		0xC01E
#define REQUEST_NOT_SUPPORTED	0xC01F
#define NONEXISTENT_SESSION	0xC020
#define DUPLICATE_NAME		0xC021
#define SERVER_NOT_RESPONDING	0xC022
#define INVALID_CONTEXT		0xC023
#define CURRENT_CONTEXT_INVALID	0xC024
#define KERNEL_TIMEOUT		0xC025

/* More reply codes will be added as needed */

/* System Standard Request Codes: to be used requesting all standard
 * system services.
 *
 */
#define CREATE_INSTANCE		0x5801
#define QUERY_INSTANCE		0x6002
#define RELEASE_INSTANCE	0x6003
#define READ_INSTANCE		0x7404
#define WRITE_INSTANCE		0x7805
#define WRITESHORT_INSTANCE	0x6005
#define SET_BREAK_PROCESS	0x6006
#define SET_INSTANCE_OWNER	0x6007
#define QUERY_FILE		0x6008
#define MODIFY_FILE		0x6009
#define SET_PROMPT		0x600A
#define EXCEPTION_REQUEST	0x5C0B
#define REGISTER_HANDLER	0x600C
#define GET_USERNUMBER		0x580D	/* should be idempotent, 0x780D */
#define NQUERY_FILE		0x780E
#define NMODIFY_FILE		0x780F
#define GET_TIME		0x6010
#define TERMINATE_TEAM		0x6012
#define LOOKUP_SERVER		0x7813
#define READ_AND_FORWARD	0x7414
#define REMOVE_FILE		0x5815
#define ADD_CONTEXT_NAME	0x5816
#define DELETE_CONTEXT_NAME	0x7817
#define GET_CONTEXT_ID		0x7818
#define GET_CONTEXT_NAME	0x7419
#define GET_FILE_NAME		0x741A
#define READ_DESCRIPTOR		0x741B
#define NREAD_DESCRIPTOR	0x7C1C
#define WRITE_DESCRIPTOR	0x781D
#define NWRITE_DESCRIPTOR	0x781E

/* Kernel opcodes */
#define CREATE_PROCESS		0x4020
#define DESTROY_PROCESS		0x6021
#define QUERY_PROCESS		0x7422
#define MODIFY_PROCESS		0x7823
#define CREATE_TEAM		0x4024
#define SET_TEAM_PRIORITY	0x6025
#define SET_TEAM_SIZE		0x6026
#define DELAY			0x4027
#define WAKEUP			0x6028
#define GETTIME 		0x6029
#define SETTIME 		0x602a
#define SETPID			0x602b

/* Kernel request format */
typedef struct
  {
    short	opcode;
    short	garbage;
    Process_id	pid;
    unsigned	unspecified[4];
    char	*segment;
    unsigned	length;
  } 
    KernelRequest;

/* Motorola 68000 and SUN workstation specific definitions */


#define Unspec char *
#define BYTES_PER_WORD	4

#define CLICKS_PER_SEC 100	/* Clock interrupts per second */

#endif VENVIRON
