/*
 * loadfile.c
 *
 * This file contains one function, loadfile().  It is used by Vload and
 *  offload to load programs into the Sun Workstation, using the Sun
 *  boot request protocol.
 *
 * 30-Sep-82 (TPM): Corrected length check when symbols are loaded.
 *  2-Feb-83 (TPM): Sets net=0 in boot request, not knowing what net it's on.
 *  7-Feb-83 (TPM): Added default directory code.
 * 26-Mar-83 (TPM): Added EFTP retries, uses random socket.
 *  6-Jun-83 (TPM): One more argument: do we zero bss?
 */

#include <eftp.h>
#include <pupstatus.h>
#include <pupconstants.h>
#include <puproute.h>
#include <b.out.h>
#define MAXPERCALL 1024	/* Buffer size used for receiving */
#define MAX_NAME_LENGTH 128 /* Maximum file name length */

#define TYMEOUT 20 /* seconds (?) */
#define RETRIES 5 /* counts initial try */

#define TRUE 1
#define FALSE 0
#define NUL '\0'
#define error(string) {printf("%s\n%s\n",string,PupErrMsg); exit(); }

loadfile(filename, header, buffer, maxlength, symbols, zeroBss, defaultDir)
    char *buffer, *filename, *defaultDir;
    struct bhdr *header;
    unsigned maxlength;
    int symbols, zeroBss;

  /*
   * This routine requests a file from a boot server.  The file must be
   *  in b.out format.  The header is loaded into the bhdr structure pointed
   *  to by "header," while the file itself is loaded into the buffer pointed
   *  to by "buffer."  If the file is longer than "maxlength," or other
   *  errors occur during loading, a message is printed and exit() is called
   *  to abort the program.  The b.out header is checked for a valid "magic
   *  number" (currently only FMAGIC is allowed), and the bss segment is
   *  zeroed.  The symbol table is loaded just above the bss segment, preceded
   *  by a longword containing its length.
   *
   */

  {
    struct EftpChan loadchan;	/* EFTP channel used for loading */
    struct Port serverport;		/* Server's port (address) */
    int totalsize, rsize, retcode, host, i, retry, socket;
    char *loadptr, *symptr, *p;
    char newfilename[2*MAX_NAME_LENGTH+1];

    /* Parse filename.  If it starts with a '[', take the string
     *   inside the brackets as a host identifier */

    if (*filename == '[')
      {
	p = ++filename;		/* Point to start of host name */
	while (*p != ']' && *p != NUL) p++;
	*p = NUL;  		/* Terminate string at colon */
	retcode = mlookup(filename, &serverport);
	if (retcode != OK) error("?Can't identify host.");
	filename = ++p;  /* Point to rest of filename */
      }
    else
      {
	/* If no host given, broadcast to the net we're on */
	InitRoutingTable(RoutingTable, &ConnectedNets);
		/* ^ kludge courtesy of Jeff Mogul */
	serverport.net = 0;
	serverport.host = 0;
      }

    serverport.socket = MISCSERVICES;

    /* If the next component of the filename does not begin with
     *    '/' or '<', prepend the default directory name */
    if (*filename != '/' && *filename != '<')
      {
	*newfilename = NUL;
	strncat(newfilename, defaultDir, MAX_NAME_LENGTH);
	strncat(newfilename, filename, MAX_NAME_LENGTH);
	filename = newfilename; 
      }

    /* Pick a random socket */
    socket = emt_ticks();
    if (socket <= MAXWELLKNOWNSOCKET) socket += MAXWELLKNOWNSOCKET;

    /* Open Eftp channel */
    if (EfRecOpenS(&loadchan, &serverport, TYMEOUT, 0, socket) != OK)
	error("?Can't open EFTP channel.");

    retry = RETRIES;
    do
      {    
        /* Send out boot request */
        if (msunbootreq(&serverport, socket, 0, filename) != OK)
	    error("?Can't send boot request.");

        /* Read first block of file to get b.out header */
        retcode = EftpRead(&loadchan,buffer,MAXPERCALL,&rsize);

        if (retcode == OK)
	    putchar('!');
	else
	    putchar('.');
      }
    while (retcode == TIMEOUT && --retry);

    if (retcode == TIMEOUT) error("?Timeout.");
    if (retcode != OK && retcode != EFTP_ENDOFFILE)
	error("?Can't load file--EFTP failed.");
    if (rsize < sizeof(struct bhdr)) error("?Not in b.out format.");

    /* Copy b.out header where it belongs */
    for (i=0;i<sizeof(struct bhdr);i++)
        ((char *)header)[i] = buffer[i];
	
    /* Be sure we have a legal magic number */
    if (header->fmagic != FMAGIC)
	error("?Not in b.out format--illegal magic number.");

    if (header->tsize + header->dsize + header->bsize + sizeof(long)
	+ (symbols ? header->ssize : 0)  >  maxlength) 
      {
	error("?File too big.");
      }

    /* Move rest of first packet back to start of buffer */
    loadptr = buffer;
    for (i=0;i<rsize-sizeof(struct bhdr);i++)
      {
	*loadptr = *(loadptr + sizeof(struct bhdr));
	loadptr++;
      }

    /* Receive rest of file */
    totalsize = rsize - sizeof(struct bhdr);
    while (retcode != EFTP_ENDOFFILE)
      {
	retcode = EftpRead(&loadchan,loadptr,MAXPERCALL,&rsize);
	putchar('!');
	totalsize += rsize;
	loadptr += rsize;
	if (retcode == TIMEOUT) error("?Timeout.");
	if (retcode != OK && retcode != EFTP_ENDOFFILE)
	    error("?Can't load file--error during EFTP.");
      }

    /* File all loaded. */
    putchar('\n');

    /* Move up the symbols past the bss area */
    loadptr = buffer + header->tsize + header->dsize + header->ssize;
    symptr = loadptr + header->bsize + sizeof(long);
    if (symbols)
      {
	for (i=0; i < header->ssize; i++)
	    *(--symptr) = *(--loadptr);
        *((long *) (symptr - sizeof(long))) = header->ssize;
      }
    else
      {
        loadptr -= header->ssize;
      }

    if (zeroBss)
      {
	/* Now zero the bss area. */
	for (i=0; i < header->bsize; i++)
	    *loadptr++ = 0;
      }

  }

