/********************************************************/
/*							*/
/*	  Virtual Graphics Terminal Server		*/
/*							*/
/*		(C) COPYRIGHT 1982			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*							*/
/********************************************************/

/*
 * sdf.h - private declarations for the Virtual Graphics Terminal Server
 *
 * Bill Nowicki August 1982
 */

/* Size definitions */

# define MAX_Views 16		/* maximum number of views */
# define MAX_VGTS 16		/* maximum Virtual Graphics Terminals */
# define NumberSDF 8		/* maximum number of SDFs */
# define VGTnameLength 52	/* maximum length of a VGT name (so sizeof vgt
				   is a power of two) */

/* The basic data type in the structured display file is the display_record
   defined below.  It contains pointers to other display records for
   structuring purposes, x and y coordinates for a bounding box for this
   item, a copy of the name used by the host program to identify this item,
   the type of the item (rectangle, point, symbol call, text, etc.), and 
   a few bits for any extra information needed by this type of record.  */

typedef struct display_record
  {
    struct display_record *rightSib,*leftChild;
    short xmin, xmax, ymin, ymax, item;
    unsigned type : 8;
    unsigned typedata : 8;
  } DISPLAY_RECORD, *DISPLAY_RECORD_PTR;



typedef struct VGTDescriptor
	/* 
	 * Descriptor for a Virtual Graphics Terminal,
	 */
  {
    int type;	
		/* Type of display - see usage-type
		   definitions above. */
    DISPLAY_RECORD_PTR sdfPtr;
		/* Ptr into the Structured
		   Display File for the topmost
		   cell definition for this VGT. */
    char *banner;
    char name[VGTnameLength];
  } VGT;

extern VGT VGTtable[];



typedef struct SdfTableRec
	/* Descriptor for a Structured Display File  descriptor */
  {
    int type;			/* Type of sdf - only used and unused now */
    int openXmin, openXmax,
        openYmin, openYmax;	/* Bounding box of symbol being built */
    int redrawXmin, redrawXmax,
        redrawYmin, redrawYmax;	/* Bounding box of changes in edited symbol */
    DISPLAY_RECORD_PTR 
          definingSymbol, 	/* the symbol we are defining */
          currentItem,		/* the last item we added */
	  addList;		/* list of added items */
    int needToClear;		/* true if deletes or changes were done */
  } SdfTableType;

extern SdfTableType SdfTable[];


/*
 * Record type definitions
 */
typedef struct viewPort
	/*
	 * View is a descriptor for a viewport on the terminal's screen.
	 * It contains the world and screen coordinates together
	 * with a few constants to aid in the fast reconstruction
	 *  of the view should the display be updated. 
	 */
  {
    short ScreenXmin, 
          ScreenXmax, 
          ScreenYmin, 
	  ScreenYmax;
			/* Bounding screen coordinates for this viewport */
		 		   
    short WorldXmin, WorldXmax, WorldYmin, WorldYmax;
				/* World coordinates that this window is
				   currently mapped to. */
    short Xconst, Yconst;
    short zoom;			/* Magnification factor for this window. */
    short usage;		/* Type of graphics display being viewed
				   in this window - see usage-type defs. */
    short vgt;			/* Index of VGT which this view is showing. */
    short ViewID;		/* viewport Identifier */ 
    BOOLEAN showGrid;		/* Indicates if a grid pattern should be
		 		   shown in this window. */
    short expansionDepth;	/* how far to expand symbols */
    struct SubView *object;	/* rectangle list for object */
    struct SubView *rect;	/* rectangle list for banner */
    char *banner;		/* text of banner */
    struct viewPort *next;	/* link in front to back list */
  } View, *View_PTR;

extern View ViewTable[];

View *ViewList;		/* front to back list */

struct SubView
  {
	/*
	 * Overlapping windows can be broken up into several rectangles.
	 */
    short ScreenXmin, ScreenXmax, ScreenYmin, ScreenYmax;
    struct SubView *next;
    short EdgeSet;
    short bannerFlag		/* true if banner instead of object */
  };

# define FontHeight 16
# define FontWidth 8
# define BannerHeight 16

#define MaxPixelMiss 8

/*
 * special internal SDF type codes.
 * WARNING: must be disjoint from those give in Vgts.h!!!
 */

# define SDF_InternalText 30	/* overwriting text, for pads */
# define SDF_UpLine 31		/* lines from (xmin,ymin) to (xmax,ymax) */
# define SDF_DownLine 32	/* lines from (xmin,ymax) to (xmax,ymin) */
# define SDF_MaxCode 33
# define SDF_FREE 255

# define CMR_Font 8		/* magic index for default pad font */
# define Menu_Font 7		/* magic number for pop-up menu font*/
