/********************************************************/
/*							*/
/*	  Virtual Graphics Terminal Server		*/
/*							*/
/*		(C) COPYRIGHT 1982			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*							*/
/********************************************************/

/*
 * pad.h - private declarations for the VGTS terminal emulator
 *
 * Bill Nowicki September 1982
 */

enum PadState 
  {
  	/*
	 * This enumerated type defines the current state of an output pad.
	 */
    Normal,		/* just print characters */
    GettingArgs,	/* decoding arguments of escape sequence */
    Escape,		/* decode and escape sequence */
    GettingCharSet	/* decode the VT-100 character set descriptor */
  };

enum EscapeKind 
  {
    NonAnsi,		/* just escape followed by a character */
    Ansi		/* escape, left bracket, character */
  };

typedef struct TtyPadRec
	/* Descriptor for a tty pad.  Contains various 
	   constants which define the pads state. */
  {
    char *cursorPos;		/* pointer to a cursor position */
    short width, length;	/* Width and length of the pad in chars */
    short curColumn, curLine;	/* Current column and line numbers. */
    DISPLAY_RECORD_PTR curItem;	/* points to current item in the SDF */
    short yMinChanged;		/* bounds to be refreshed on next */
    short yMaxChanged;		/* 			cursor flash */
    enum PadState state;	/* state we are in */
    char *strings;		/* space malloc'ed for strings */
    short args[5];		/* save parameters of commands */
    short regionTop, regionBot;	/* region bounds for VT-100 style scrolling */
    char cursorFlag;		/* true if cursor is on */
    char standout;		/* true if in standout mode */
    char insert;		/* true if in insert mode */
    char argCount;		/* number arguments */
    DISPLAY_RECORD_PTR sdfPtr;	/* root of the symbol */
    short vgt;			/* vgt index */
    char junk[12];		/* extra to make a power of two */
   } TtyPadType;

extern TtyPadType TtyPadList[];

