/*
 * newdraw.c
 *
 * David Kaelbling May 1983
 *
 * This file contains all the screen drawing routines.
 * Currently that is a set of routines to manipulate rectangular 
 * regions of the screen.
 * All references to the SUN framebuffer reside in this file.
 */


# include "Vgts.h"
# include "sdf.h"
# include <rasterops.h>
# include <framebuf.h>
# include <confreg.h>
# include "splines.h"

/*
 * SUN framebuffer specific definitions.
 */

extern int GXBase;

extern short ScreenXmin, ScreenYmin, ScreenXmax, ScreenYmax;


/*******************************************************************/
/*******************************************************************/

/*
 * Stripped down version of Per's generalized raster put mechanism.
 *							DRK
 */
    
/* show a MemRaster on the screen, optionally magnified.
 * Per Bothner. March 1983.
 */

static DisplayNib(in,x,y,clip)
  struct mem_raster *in;	/* raster (must be in memory) to display */
  int x,y;			/* top, left corner of FB rectangle. */
  struct SubView *clip;		/* bounding box of raster */
  /* GXfunction must be set before calling this routine */
  {
    short moreWidth = in->width;
    short curOffset = 0;
    int height = in->height;
    short curWidth;
    register shift, i;
    register char *GXBase = (char *)GXDefaultBase;
    register short *yFB = y + (short *)((GXupdate|GXselectY|GXsource)+GXBase);
    short *colTop = in->start;
    register short *memPtr;
    short maxColWidth = 16;

    if (x < clip->ScreenXmin)
      { /* left clipping */
	i = (clip->ScreenXmin - x);
	x += i;
	moreWidth -= i;
	if (moreWidth <= 0) return;
	curOffset += i;
	colTop += in->height * (curOffset >> 4);
	curOffset &= 0xF;
      }
    if (y < clip->ScreenYmin)
      { /* top clipping */
	i = (clip->ScreenYmin - y);
	height -= i;
	if (height <= 0) return;
	colTop += i;
	y += i;
	yFB += i;
      }
    i = x - (clip->ScreenXmax + 1) + moreWidth;
    if (i > 0)
      { /* right clipping */
	moreWidth -= i;
	if (moreWidth <= 0) return;
      }
    i = y - (clip->ScreenYmax + 1) + height;
    if (i > 0)
      { /* bottom clipping */
	height -= i;
	if (height <= 0) return;
      }
    while (moreWidth > 0)
      {
        curWidth = 16 - curOffset;
	if (curWidth > moreWidth) curWidth = moreWidth;
	if (curWidth > maxColWidth) curWidth = maxColWidth;
	memPtr = colTop;
	shift = 16 - curOffset - curWidth;
	GXwidth = curWidth;
	GXBase[x<<1] = shift;
	  {
	    register j; register short word;
		for (i = height; i > 0; i--)
		  { 
		    word = (*memPtr++ >> shift) & ~(-1 << curWidth);
		    *yFB++ = (word <<= 16 - curWidth);
		  }
          }
	x += curWidth;
	moreWidth -= curWidth;
	curOffset += curWidth;
	yFB -= height;
	if (curOffset >= 16) {curOffset = 0; colTop += in->height;}
      }
  }

/*
 *  Code to place a specified bit map onto the screen.
 *
 *  Update History:
 *	February 1983 -- Written by David Kaelbling.
 */
    
    
/* Imports */
extern struct mem_raster Nibs[];
    
    
/* Exports */
extern int XYbrush();
    
    
/* Local Definitions */
static struct fb_raster dest;
    
    
/*
 *  XYbrush()  --  Place the brush with specified nib down on the
 *	screen, using a black inking function.
 */
 
XYbrush( xval, yval, clip, nib )
	register short xval, yval;
	register struct SubView *clip;
	register enum Nib nib;
  {
    register struct mem_raster *nibPtr = &Nibs[(int)nib];
    GXfunction = GXpaintInverted;
    DisplayNib( nibPtr, xval - (nibPtr->width >> 1),
    		    yval - (nibPtr->height >> 1), clip );
  }

/*
 *  Display a raster pattern, optionally using GXcopyPattern instead of
 *  always GXandPattern.
 */
 
XYpattern( dest, pat, opaque )
	register struct fb_raster *dest;
	register short *pat[];
	register short opaque;
  {
    GXwidth = 1;
    GXfunction = ((opaque != 0) ? GXcopyPattern : GXandPattern);
    RasterPattern( dest, pat );
  }
