/********************************************************/
/*							*/
/*	  Virtual Graphics Terminal Server		*/
/*							*/
/*		(C) COPYRIGHT 1983			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*							*/
/********************************************************/

/* keytable.h - Keytable for Line Editing
 *
 *
 * Bill Nowicki September 1983 
 *
 */

enum EditKind
  {
  	/*
	 * This enumerated type gives the commands of the line editor.
	 * Keytables have these as entries.
	 */
    EditNop,		/* Do nothing */
    EditInsert,		/* Self inserting */
    EditRelease,	/* release the buffer (e.g. return) */
    EditReleaseLine,	/* EditRelease + echo CRLF */
    EditDeleteChar,	/* delete the last character */
    EditDeleteWord,	/* delete the last word */
    EditDeleteLine,	/* delete the last line */
    EditDeleteNextChar,	/* delete next character */
    EditDeleteNextWord,	/* delete next word */
    EditDeleteNextLine,	/* delete next line */
    EditForwardChar,	/* move forward character */
    EditForwardWord,	/* move forward word */
    EditForwardLine,	/* move forward line */
    EditBackwardChar,	/* move backward character */
    EditBackwardWord,	/* move backward word */
    EditBackwardLine,	/* move backward line */
    EditTransposeChar,	/* transpose two characters */
    EditBeginLine,	/* move to start of line */
    EditEndLine,	/* move to end of line */
    EditEscape,		/* go into Escape mode */
    EditKillBreak,	/* Kill the break process */
    EditEOF,		/* Cause End-Of-File */
    EditBeep		/* Error, cause Bell to ring */
  };



